/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.scheduler.DrainableForkJoinPool;
import scala.actors.scheduler.ForkJoinScheduler$;
import scala.actors.scheduler.QuitException;
import scala.actors.scheduler.TerminationMonitor;
import scala.actors.scheduler.TerminationMonitor$class;
import scala.actors.scheduler.ThreadPoolConfig$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ManagedBlocker;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinScheduler
implements Runnable,
IScheduler,
TerminationMonitor,
ScalaObject {
    private boolean scala$actors$scheduler$TerminationMonitor$$started;
    private final HashMap terminationHandlers;
    private int activeActors;
    private final int CHECK_FREQ;
    private Collection<ForkJoinTask<?>> drainedTasks;
    private boolean snapshoting;
    private boolean terminating;
    private DrainableForkJoinPool pool;
    private final boolean daemon;
    private final int maxSize;
    private final int initCoreSize;

    public ForkJoinScheduler(int initCoreSize, int maxSize, boolean daemon) {
        this.initCoreSize = initCoreSize;
        this.maxSize = maxSize;
        this.daemon = daemon;
        IScheduler$class.$init$(this);
        TerminationMonitor$class.$init$(this);
        this.pool = this.makeNewPool();
        this.terminating = false;
        this.snapshoting = false;
        this.drainedTasks = null;
        this.CHECK_FREQ = 10;
    }

    private final void liftedTree1$1() {
        try {
            this.wait(this.CHECK_FREQ());
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void restart() {
        block7: {
            // MONITORENTER : this
            if (!this.snapshoting()) break block7;
            if (this.isActive()) {
                String string2 = "scheduler is still active";
                throw new RuntimeException(string2);
            }
            this.snapshoting_$eq(false);
            this.pool_$eq(this.makeNewPool());
            // MONITOREXIT : this
            Iterator<ForkJoinTask<?>> iter = this.drainedTasks().iterator();
            while (true) {
                if (!iter.hasNext()) {
                    this.start();
                    return;
                }
                this.pool().execute(iter.next());
            }
        }
        String string3 = "snapshot has not been invoked";
        throw new RuntimeException(string3);
    }

    public void snapshot() {
        synchronized (this) {
            this.snapshoting_$eq(true);
            return;
        }
    }

    @Override
    public void managedBlock(ManagedBlocker blocker$1) {
        ForkJoinPool.managedBlock(new $anon$3(this, blocker$1), true);
    }

    @Override
    public boolean isActive() {
        synchronized (this) {
            boolean bl = !this.terminating() && this.pool() != null && !this.pool().isShutdown();
            return bl;
        }
    }

    @Override
    public void shutdown() {
        synchronized (this) {
            this.terminating_$eq(true);
            return;
        }
    }

    @Override
    public void execute(Function0<Object> fun$1) {
        this.execute(new $anon$2(this, fun$1));
    }

    @Override
    public void executeFromActor(Runnable task$1) {
        $anon$1 recAction = new $anon$1(this, task$1);
        recAction.fork();
    }

    @Override
    public void execute(Runnable task) {
        this.pool().execute(task);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                synchronized (this) {
                    this.liftedTree1$1();
                    if (this.terminating()) {
                        throw new QuitException();
                    }
                    if (this.allActorsTerminated()) {
                        Debug$.MODULE$.info(new StringAdd(this).$plus(": all actors terminated"));
                        this.terminating_$eq(true);
                        throw new QuitException();
                    }
                    if (this.snapshoting()) {
                        if (this.pool().isQuiescent()) {
                            list = new ArrayList<ForkJoinTask<?>>();
                            num = this.pool().drainTasksTo(list);
                            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": drained ")).append(BoxesRunTime.boxToInteger(num)).append((Object)" tasks").toString());
                            this.drainedTasks_$eq(list);
                            this.terminating_$eq(true);
                            throw new QuitException();
                        }
                    } else {
                        this.gc();
                    }
                    continue;
                }
                break;
            }
        }
        catch (QuitException v1) {
            Debug$.MODULE$.info(new StringAdd(this).$plus(": initiating shutdown..."));
            while (true) {
                if (this.pool().isQuiescent()) {
                    this.pool().shutdown();
                    return;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException v2) {
                    continue;
                }
                break;
            }
        }
        {
            ** while (true)
        }
    }

    public void start() {
        try {
            Thread t = new Thread(this);
            t.setDaemon(this.daemon);
            t.setName("ForkJoinScheduler");
            t.start();
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": could not create scheduler thread: ")).append(exception).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private DrainableForkJoinPool makeNewPool() {
        void var1_1;
        DrainableForkJoinPool p = new DrainableForkJoinPool();
        p.setAsyncMode(true);
        p.setParallelism(this.initCoreSize());
        p.setMaximumPoolSize(this.maxSize());
        int n = p.getParallelism();
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": parallelism ")).append(BoxesRunTime.boxToInteger(n)).toString());
        int n2 = p.getMaximumPoolSize();
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": max pool size ")).append(BoxesRunTime.boxToInteger(n2)).toString());
        return var1_1;
    }

    public ForkJoinScheduler() {
        this(false);
    }

    public ForkJoinScheduler(boolean d) {
        this(ThreadPoolConfig$.MODULE$.corePoolSize(), ThreadPoolConfig$.MODULE$.maxPoolSize(), d);
    }

    public int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private void drainedTasks_$eq(Collection<ForkJoinTask<?>> collection) {
        this.drainedTasks = collection;
    }

    private Collection<ForkJoinTask<?>> drainedTasks() {
        return this.drainedTasks;
    }

    private void snapshoting_$eq(boolean bl) {
        this.snapshoting = bl;
    }

    private boolean snapshoting() {
        return this.snapshoting;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void pool_$eq(DrainableForkJoinPool drainableForkJoinPool) {
        this.pool = drainableForkJoinPool;
    }

    private DrainableForkJoinPool pool() {
        return this.pool;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int initCoreSize() {
        return this.initCoreSize;
    }

    @Override
    public void printActorDump() {
        IScheduler$class.printActorDump(this);
    }

    public void onLockup(int millis, Function0 handler) {
        IScheduler$class.onLockup(this, millis, handler);
    }

    public void onLockup(Function0 handler) {
        IScheduler$class.onLockup(this, handler);
    }

    @Override
    public void tick(Actor a) {
        IScheduler$class.tick(this, a);
    }

    @Override
    public void gc() {
        TerminationMonitor$class.gc(this);
    }

    @Override
    public boolean allTerminated() {
        return TerminationMonitor$class.allTerminated(this);
    }

    @Override
    public boolean allActorsTerminated() {
        return TerminationMonitor$class.allActorsTerminated(this);
    }

    @Override
    public void terminated(Reactor a) {
        TerminationMonitor$class.terminated(this, a);
    }

    public void onTerminate(Reactor a, Function0 f) {
        TerminationMonitor$class.onTerminate(this, a, f);
    }

    @Override
    public void newActor(Reactor a) {
        TerminationMonitor$class.newActor(this, a);
    }

    @Override
    public void scala$actors$scheduler$TerminationMonitor$_setter_$terminationHandlers_$eq(HashMap hashMap) {
        this.terminationHandlers = hashMap;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$started_$eq(boolean bl) {
        this.scala$actors$scheduler$TerminationMonitor$$started = bl;
    }

    @Override
    public final boolean scala$actors$scheduler$TerminationMonitor$$started() {
        return this.scala$actors$scheduler$TerminationMonitor$$started;
    }

    public HashMap terminationHandlers() {
        return this.terminationHandlers;
    }

    @Override
    public void activeActors_$eq(int n) {
        this.activeActors = n;
    }

    @Override
    public int activeActors() {
        return this.activeActors;
    }
}

