/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq($this.loadFactor());
        $this.table_$eq(new HashEntry[HashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold());
    }

    public static final int index(HashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(HashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(HashTable $this, Object key) {
        return key == null || key.equals(null) ? 0 : key.hashCode();
    }

    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        return key1 == key2 ? true : (key1 == null ? false : (key1 instanceof Number || key1 instanceof Character ? BoxesRunTime.equals2(key1, key2) : key1.equals(key2)));
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, HashEntry>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                if (e == null || e.equals(null)) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
            }
        }
        $this.threshold_$eq(HashTable$class.newThreshold($this, newSize));
    }

    private static int newThreshold(HashTable $this, int size2) {
        return (int)((long)size2 * (long)$this._loadFactor() / 1000L);
    }

    public static void clearTable(HashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    public static Iterator entries(HashTable $this) {
        return $this.entriesIterator();
    }

    public static final void foreachEntry(HashTable $this, Function1 f) {
        $this.entriesIterator().foreach(f);
    }

    public static Iterator entriesIterator(HashTable $this) {
        return new HashTable$.anon.1($this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashEntry removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        if (e == null || e.equals(null)) return null;
        if ($this.elemEquals(e.key(), key)) {
            $this.table()[h] = e.next();
            $this.tableSize_$eq($this.tableSize() - 1);
            return e;
        }
        HashEntry e1 = e.next();
        while (true) {
            if (e1 == null || e1.equals(null) || $this.elemEquals(e1.key(), key)) {
                if (e1 == null || e1.equals(null)) {
                    return null;
                }
                e.next_$eq(e1.next());
                $this.tableSize_$eq($this.tableSize() - 1);
                return e1;
            }
            e = e1;
            e1 = (HashEntry)e1.next();
        }
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        while (true) {
            if (e == null || e.equals(null) || $this.elemEquals(e.key(), key)) {
                return e;
            }
            e = e.next();
        }
    }

    private static int capacity(HashTable $this, int expectedSize) {
        int n;
        if (expectedSize == 0) {
            n = 1;
        } else {
            int c0 = expectedSize - 1;
            c0 |= c0 >>> 1;
            c0 |= c0 >>> 2;
            c0 |= c0 >>> 4;
            c0 |= c0 >>> 8;
            c0 |= c0 >>> 16;
            n = c0 + 1;
        }
        return n;
    }

    public static void serializeTo(HashTable $this, ObjectOutputStream out$1, Function1 value$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this.loadFactor());
        out$1.writeInt($this.tableSize());
        $this.foreachEntry(new HashTable$.anonfun.serializeTo.1($this, out$1, value$1));
    }

    public static void init(HashTable $this, ObjectInputStream in, Function2 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new HashEntry[HashTable$class.capacity($this, size2 * 1000 / $this._loadFactor())]);
        Object[] objectArray = $this.table();
        $this.threshold_$eq(HashTable$class.newThreshold($this, new ArrayOps.ofRef<Object>(objectArray).size()));
        for (int index2 = 0; index2 < size2; ++index2) {
            $this.addEntry((HashEntry)f.apply(in.readObject(), in.readObject()));
        }
    }

    private static int initialCapacity(HashTable $this) {
        return HashTable$class.capacity($this, $this.initialSize());
    }

    public static int initialThreshold(HashTable $this) {
        return HashTable$class.newThreshold($this, HashTable$class.initialCapacity($this));
    }

    public static int initialSize(HashTable $this) {
        return 16;
    }

    public static int loadFactor(HashTable $this) {
        return 750;
    }
}

