/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import scala.ScalaObject;
import scala.actors.remote.Service;

public abstract class Serializer
implements ScalaObject {
    private final Service service;

    public Serializer(Service service) {
        this.service = service;
    }

    public void writeObject(DataOutputStream outputStream, Object obj) throws IOException {
        byte[] bytes = this.serialize(obj);
        this.writeBytes(outputStream, bytes);
    }

    private void writeBytes(DataOutputStream outputStream, byte[] bytes) throws IOException {
        int length = bytes.length;
        outputStream.writeInt(length);
        outputStream.write(bytes, 0, length);
        outputStream.flush();
    }

    public Object readObject(DataInputStream inputStream) throws IOException, ClassNotFoundException {
        byte[] bytes = this.readBytes(inputStream);
        return this.deserialize(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(DataInputStream inputStream) throws IOException {
        try {
            void var3_3;
            int length = inputStream.readInt();
            byte[] bytes = new byte[length];
            inputStream.readFully(bytes, 0, length);
            return var3_3;
        }
        catch (NullPointerException nullPointerException) {
            throw new EOFException("Connection closed.");
        }
    }

    public abstract Object deserialize(byte[] var1);

    public abstract byte[] serialize(Object var1);

    public Service service() {
        return this.service;
    }
}

