/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!\u0002\r\u001a\u0005my\u0002\"B\u001e\u0001\t\u0003a\u0004\"\u0002 \u0001\t\u0013y\u0004\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003E\u0011%)\u0005\u00011AA\u0002\u0013%a\tC\u0005M\u0001\u0001\u0007\t\u0011)Q\u0005o!)Q\n\u0001C\u0005\u001d\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0006bB,\u0001\u0001\u0004%I\u0001\u0017\u0005\u00075\u0002\u0001\u000b\u0015\u0002+\t\u000bm\u0003A\u0011\u0002/\t\u000b%\u0004A\u0011\u00026\t\u000be\u0004A\u0011\u0002>\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0017\u0001\u0011%\u0011q\u0006\u0005\b\u0003c\u0001A\u0011BA\u0018\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005=\u0003\u0001\"\u0011\u00020!A\u0011\u0011\u000b\u0001\u0005\u0002m\t\u0019\u0006C\u0004\u0002V\u0001!\t%a\u0015\u0003\u001d!\u000b7\u000f[*fi\n+\u0018\u000e\u001c3fe*\u0011!dG\u0001\nS6lW\u000f^1cY\u0016T!\u0001H\u000f\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001f\u0003\u0015\u00198-\u00197b+\t\u0001SfE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003uI!\u0001J\u000f\u0003\r\u0005s\u0017PU3g!\u00111\u0013fK\u001c\u000e\u0003\u001dR!\u0001K\u000e\u0002\u000f5,H/\u00192mK&\u0011!f\n\u0002\u0010%\u0016,8/\u00192mK\n+\u0018\u000e\u001c3feB\u0011A&\f\u0007\u0001\t\u0015q\u0003A1\u00011\u0005\u0005\t5\u0001A\t\u0003cQ\u0002\"A\t\u001a\n\u0005Mj\"a\u0002(pi\"Lgn\u001a\t\u0003EUJ!AN\u000f\u0003\u0007\u0005s\u0017\u0010E\u00029s-j\u0011!G\u0005\u0003ue\u0011q\u0001S1tQN+G/\u0001\u0004=S:LGO\u0010\u000b\u0002{A\u0019\u0001\bA\u0016\u0002!9,w/R7qif\u0014vn\u001c;O_\u0012,W#\u0001!\u0011\u0007a\n5&\u0003\u0002C3\t!\")\u001b;nCBLe\u000eZ3yK\u0012\u001cV\r\u001e(pI\u0016\fq!\u00197jCN,G-F\u00018\u0003-\tG.[1tK\u0012|F%Z9\u0015\u0005\u001dS\u0005C\u0001\u0012I\u0013\tIUD\u0001\u0003V]&$\bbB&\u0005\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014\u0001C1mS\u0006\u001cX\r\u001a\u0011\u0002\u0013%\u001c\u0018\t\\5bg\u0016$W#A(\u0011\u0005\t\u0002\u0016BA)\u001e\u0005\u001d\u0011un\u001c7fC:\f\u0001B]8pi:{G-Z\u000b\u0002)B\u0019\u0001(V\u0016\n\u0005YK\"aB*fi:{G-Z\u0001\re>|GOT8eK~#S-\u001d\u000b\u0003\u000ffCqa\u0013\u0005\u0002\u0002\u0003\u0007A+A\u0005s_>$hj\u001c3fA\u0005i\u0011N\\:feR,E.Z7f]R$B!X2fOB\u0019!E\u00181\n\u0005}k\"!B!se\u0006L\bC\u0001\u0012b\u0013\t\u0011WDA\u0002J]RDQ\u0001\u001a\u0006A\u0002u\u000b!!Y:\t\u000b\u0019T\u0001\u0019\u00011\u0002\u0005%D\b\"\u00025\u000b\u0001\u0004\u0001\u0017\u0001B3mK6\f1\"\u001b8tKJ$h+\u00197vKV\u00111N\u001e\u000b\u0007\u000f2t\u0007O\u001d;\t\u000b5\\\u0001\u0019\u0001!\u0002\u0005\tl\u0007\"B8\f\u0001\u0004\u0001\u0017A\u00022jiB|7\u000fC\u0003r\u0017\u0001\u00071&A\u0002lKfDQa]\u0006A\u0002\u0001\fAb\u001c:jO&t\u0017\r\u001c%bg\"DQ!^\u0006A\u0002\u0001\fqa[3z\u0011\u0006\u001c\b\u000eB\u0003x\u0017\t\u0007\u0001P\u0001\u0002BcE\u00111\u0006N\u0001\u000ee\u0016lwN^3FY\u0016lWM\u001c;\u0015\u0007u[H\u0010C\u0003e\u0019\u0001\u0007Q\fC\u0003g\u0019\u0001\u0007\u0001-A\fnS\u001e\u0014\u0018\r^3Ge>l\u0017J\u001c7j]\u0016$vNT8eKRAqi`A\u0001\u0003\u000b\t9\u0001C\u0003n\u001b\u0001\u0007\u0001\t\u0003\u0004\u0002\u00045\u0001\r\u0001Y\u0001\fK2,W.\u001a8u\u0011\u0006\u001c\b\u000eC\u0003p\u001b\u0001\u0007\u0001\r\u0003\u0004\u0002\n5\u0001\r\u0001V\u0001\u0005]>$W-\u0001\u0005tKR4\u0016\r\\;f+\u0011\ty!a\u0006\u0015\u000f\u001d\u000b\t\"a\u0005\u0002\u0016!)QN\u0004a\u0001\u0001\")qN\u0004a\u0001A\")\u0001N\u0004a\u0001W\u0011)qO\u0004b\u0001q\u00061Q\u000f\u001d3bi\u0016$2bRA\u000f\u0003C\t)#a\n\u0002*!1\u0011qD\bA\u0002Q\u000bqa]3u\u001d>$W\r\u0003\u0004\u0002$=\u0001\raK\u0001\bK2,W.\u001a8u\u0011\u0015\u0019x\u00021\u0001a\u0011\u0019\t\u0019a\u0004a\u0001A\"1\u00111F\bA\u0002\u0001\fQa\u001d5jMR\fq\"\u001a8tkJ,WK\\1mS\u0006\u001cX\r\u001a\u000b\u0002\u000f\u0006I1m\u001c9z\u000b2,Wn]\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0015\u0003]\na!\u00193e\u001f:,G\u0003BA\u001e\u0003{i\u0011\u0001\u0001\u0005\u0006QN\u0001\raK\u0001\u0007C\u0012$\u0017\t\u001c7\u0015\t\u0005m\u00121\t\u0005\b\u0003\u000b\"\u0002\u0019AA$\u0003\tA8\u000fE\u0003\u0002J\u0005-3&D\u0001\u001c\u0013\r\tie\u0007\u0002\r\u0013R,'/\u00192mK>s7-Z\u0001\u0006G2,\u0017M]\u0001\u0005g&TX-F\u0001a\u0003%Ygn\\<o'&TX\r")
public final class HashSetBuilder<A>
implements ReusableBuilder<A, HashSet<A>> {
    private HashSet<A> aliased;
    private SetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public final int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<HashSet<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable<A> $plus$eq(A elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable<A> $plus$eq(A elem1, A elem2, Seq<A> elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable<A> $plus$plus$eq(IterableOnce<A> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    private BitmapIndexedSetNode<A> newEmptyRootNode() {
        return new BitmapIndexedSetNode(0, 0, (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Any()), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, 0);
    }

    private HashSet<A> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashSet<A> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public SetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode;
    }

    private void scala$collection$immutable$HashSetBuilder$$rootNode_$eq(SetNode<A> x$1) {
        this.scala$collection$immutable$HashSetBuilder$$rootNode = x$1;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <A1> void insertValue(BitmapIndexedSetNode<A> bm, int bitpos, A key, int originalHash, int keyHash) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private int[] removeElement(int[] as, int ix) {
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length - 1];
        System.arraycopy(as, 0, result, 0, ix);
        System.arraycopy(as, ix + 1, result, ix, as.length - ix - 1);
        return var3_3;
    }

    private void migrateFromInlineToNode(BitmapIndexedSetNode<A> bm, int elementHash, int bitpos, SetNode<A> node) {
        int dataIx = bm.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = bm.content().length - 1 - bm.nodeIndex(bitpos);
        Object[] src = bm.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        int[] dstHashes = this.removeElement(bm.originalHashes(), dataIx);
        bm.dataMap_$eq(bm.dataMap() ^ bitpos);
        bm.nodeMap_$eq(bm.nodeMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() - 1 + node.size());
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() - elementHash + node.cachedJavaKeySetHashCode());
    }

    private <A1> void setValue(BitmapIndexedSetNode<A> bm, int bitpos, A elem) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        bm.content()[idx] = elem;
    }

    public void update(SetNode<A> setNode, A element, int originalHash, int elementHash, int shift) {
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            int n = elementHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedSetNode.dataMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.dataMap(), n, n2);
                Object object = bitmapIndexedSetNode.content()[1 * index];
                int n3 = bitmapIndexedSetNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(object, element)) {
                    this.setValue(bitmapIndexedSetNode, n2, object);
                    return;
                }
                int element0Hash = Hashing$.MODULE$.improve(n3);
                SetNode<Object> subNodeNew = bitmapIndexedSetNode.mergeTwoKeyValPairs(object, n3, element0Hash, element, originalHash, elementHash, shift + 5);
                this.migrateFromInlineToNode(bitmapIndexedSetNode, element0Hash, n2, subNodeNew);
                return;
            }
            if ((bitmapIndexedSetNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedSetNode.getNode(index);
                int beforeSize = ((SetNode)subNode).size();
                int beforeHashCode = subNode.cachedJavaKeySetHashCode();
                this.update((SetNode<A>)subNode, element, originalHash, elementHash, shift + 5);
                bitmapIndexedSetNode.size_$eq(bitmapIndexedSetNode.size() + (((SetNode)subNode).size() - beforeSize));
                bitmapIndexedSetNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHashCode));
                return;
            }
            this.insertValue(bitmapIndexedSetNode, n2, element, originalHash, elementHash);
            return;
        }
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            Vector vector = hashCollisionSetNode.content();
            if (vector == null) {
                throw null;
            }
            int n = SeqOps.indexOf$(vector, element);
            if (n < 0) {
                hashCollisionSetNode.content_$eq(hashCollisionSetNode.content().appended(element));
                return;
            }
            Vector vector2 = hashCollisionSetNode.content();
            if (vector2 == null) {
                throw null;
            }
            hashCollisionSetNode.content_$eq(vector2.updateAt(n, element));
            return;
        }
        throw new MatchError(setNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.scala$collection$immutable$HashSetBuilder$$rootNode_$eq(this.scala$collection$immutable$HashSetBuilder$$rootNode().copy());
    }

    @Override
    public HashSet<A> result() {
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashSet<A>(this.scala$collection$immutable$HashSetBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    @Override
    public HashSetBuilder<A> addOne(A elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem);
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashSetBuilder$$rootNode(), elem, h, im, 0);
        return this;
    }

    @Override
    public HashSetBuilder<A> addAll(IterableOnce<A> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashSet) {
            HashSet hashSet = (HashSet)xs;
            new ChampBaseIterator<SetNode<A>>(this, hashSet){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashSetBuilder$$rootNode(), ((SetNode)this.currentValueNode()).getPayload(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<A> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne((Object)it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() > 0) {
            this.scala$collection$immutable$HashSetBuilder$$rootNode_$eq(this.newEmptyRootNode());
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode().size();
    }

    @Override
    public int knownSize() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode().size();
    }
}

