/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=e!\u0002\u000e\u001c\u0005m\t\u0003\"B\"\u0001\t\u0003!\u0005\"\u0002$\u0001\t\u00139\u0005\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0003M\u0011%i\u0005\u00011AA\u0002\u0013%a\nC\u0005U\u0001\u0001\u0007\t\u0011)Q\u0005\u007f!)Q\u000b\u0001C\u0005-\"9!\f\u0001a\u0001\n\u0013Y\u0006bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\u0007E\u0002\u0001\u000b\u0015\u0002/\t\r\r\u0004A\u0011A\u000ee\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u00020\u0001!I!!\r\t\u0011\u0005\u0015\u0003\u0001\"\u0001\u001c\u0003\u000fBq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002^\u0001!I!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA2\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t9\t\u0001C!\u00037B\u0001\"!#\u0001\t\u0003i\u00121\u0012\u0005\b\u0003\u001b\u0003A\u0011IAF\u00059A\u0015m\u001d5NCB\u0014U/\u001b7eKJT!\u0001H\u000f\u0002\u0013%lW.\u001e;bE2,'B\u0001\u0010 \u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002A\u0005)1oY1mCV\u0019!EM\u001f\u0014\u0007\u0001\u0019s\u0005\u0005\u0002%K5\tq$\u0003\u0002'?\t1\u0011I\\=SK\u001a\u0004B\u0001K\u0016.\u007f5\t\u0011F\u0003\u0002+;\u00059Q.\u001e;bE2,\u0017B\u0001\u0017*\u0005=\u0011V-^:bE2,')^5mI\u0016\u0014\b\u0003\u0002\u0013/aqJ!aL\u0010\u0003\rQ+\b\u000f\\33!\t\t$\u0007\u0004\u0001\u0005\u000bM\u0002!\u0019A\u001b\u0003\u0003-\u001b\u0001!\u0005\u00027sA\u0011AeN\u0005\u0003q}\u0011qAT8uQ&tw\r\u0005\u0002%u%\u00111h\b\u0002\u0004\u0003:L\bCA\u0019>\t\u0015q\u0004A1\u00016\u0005\u00051\u0006\u0003\u0002!Baqj\u0011aG\u0005\u0003\u0005n\u0011q\u0001S1tQ6\u000b\u0007/\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB!\u0001\t\u0001\u0019=\u0003AqWm^#naRL(k\\8u\u001d>$W-F\u0001I!\u0011\u0001\u0015\n\r\u001f\n\u0005)[\"\u0001\u0006\"ji6\f\u0007/\u00138eKb,G-T1q\u001d>$W-A\u0004bY&\f7/\u001a3\u0016\u0003}\n1\"\u00197jCN,Gm\u0018\u0013fcR\u0011qJ\u0015\t\u0003IAK!!U\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b'\u0012\t\t\u00111\u0001@\u0003\rAH%M\u0001\tC2L\u0017m]3eA\u0005I\u0011n]!mS\u0006\u001cX\rZ\u000b\u0002/B\u0011A\u0005W\u0005\u00033~\u0011qAQ8pY\u0016\fg.\u0001\u0005s_>$hj\u001c3f+\u0005a\u0006\u0003\u0002!^aqJ!AX\u000e\u0003\u000f5\u000b\u0007OT8eK\u0006a!o\\8u\u001d>$Wm\u0018\u0013fcR\u0011q*\u0019\u0005\b'\"\t\t\u00111\u0001]\u0003%\u0011xn\u001c;O_\u0012,\u0007%A\u0005hKR|%/\u00127tKV\u0011Qm\u001a\u000b\u0004M*d\u0007CA\u0019h\t\u0015A'B1\u0001j\u0005\t1\u0006'\u0005\u0002=s!)1N\u0003a\u0001a\u0005\u00191.Z=\t\u000b5T\u0001\u0019\u00014\u0002\u000bY\fG.^3\u0002\u001b%t7/\u001a:u\u000b2,W.\u001a8u)\u0011\u0001h\u000f\u001f>\u0011\u0007\u0011\n8/\u0003\u0002s?\t)\u0011I\u001d:bsB\u0011A\u0005^\u0005\u0003k~\u00111!\u00138u\u0011\u001598\u00021\u0001q\u0003\t\t7\u000fC\u0003z\u0017\u0001\u00071/\u0001\u0002jq\")1p\u0003a\u0001g\u0006!Q\r\\3n\u0003-Ign]3siZ\u000bG.^3\u0016\u0007y\f)\u0002\u0006\u0007P\u007f\u0006\r\u0011qAA\u0005\u0003\u001b\t\t\u0002\u0003\u0004\u0002\u00021\u0001\r\u0001S\u0001\u0003E6Da!!\u0002\r\u0001\u0004\u0019\u0018A\u00022jiB|7\u000fC\u0003l\u0019\u0001\u0007\u0001\u0007\u0003\u0004\u0002\f1\u0001\ra]\u0001\r_JLw-\u001b8bY\"\u000b7\u000f\u001b\u0005\u0007\u0003\u001fa\u0001\u0019A:\u0002\u000f-,\u0017\u0010S1tQ\"1Q\u000e\u0004a\u0001\u0003'\u00012!MA\u000b\t\u0019\t9\u0002\u0004b\u0001S\n\u0011a+M\u0001\u000ee\u0016lwN^3FY\u0016lWM\u001c;\u0015\u000bA\fi\"a\b\t\u000b]l\u0001\u0019\u00019\t\u000bel\u0001\u0019A:\u0002/5LwM]1uK\u001a\u0013x.\\%oY&tW\rV8O_\u0012,G#C(\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0011\u0019\t\tA\u0004a\u0001\u0011\"1\u0011q\u0002\bA\u0002MDa!!\u0002\u000f\u0001\u0004\u0019\bBBA\u0017\u001d\u0001\u0007A,\u0001\u0003o_\u0012,\u0017\u0001C:fiZ\u000bG.^3\u0016\t\u0005M\u00121\t\u000b\n\u001f\u0006U\u0012qGA\u001d\u0003{Aa!!\u0001\u0010\u0001\u0004A\u0005BBA\u0003\u001f\u0001\u00071\u000f\u0003\u0004\u0002<=\u0001\r\u0001M\u0001\u0007]\u0016<8*Z=\t\u000f\u0005}r\u00021\u0001\u0002B\u0005Aa.Z<WC2,X\rE\u00022\u0003\u0007\"a!a\u0006\u0010\u0005\u0004I\u0017AB;qI\u0006$X\rF\u0007P\u0003\u0013\ni%a\u0014\u0002R\u0005M\u0013Q\u000b\u0005\u0007\u0003\u0017\u0002\u0002\u0019\u0001/\u0002\u000f5\f\u0007OT8eK\")1\u000e\u0005a\u0001a!)Q\u000e\u0005a\u0001y!1\u00111\u0002\tA\u0002MDa!a\u0004\u0011\u0001\u0004\u0019\bBBA,!\u0001\u00071/A\u0003tQ&4G/A\bf]N,(/Z+oC2L\u0017m]3e)\u0005y\u0015!C2paf,E.Z7t\u0003\u0019\u0011Xm];miR\tq(\u0001\u0004bI\u0012|e.\u001a\u000b\u0005\u0003O\nI'D\u0001\u0001\u0011\u0015YH\u00031\u0001.)\u0019\t9'!\u001c\u0002p!)1.\u0006a\u0001a!)Q.\u0006a\u0001y\u00051\u0011\r\u001a3BY2$B!a\u001a\u0002v!9\u0011q\u000f\fA\u0002\u0005e\u0014A\u0001=t!\u0015\tY(!!.\u001d\r!\u0013QP\u0005\u0004\u0003\u007fz\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)I\u0001\u0007Ji\u0016\u0014\u0018M\u00197f\u001f:\u001cWMC\u0002\u0002\u0000}\tQa\u00197fCJ\fAa]5{KV\t1/A\u0005l]><hnU5{K\u0002")
public final class HashMapBuilder<K, V>
implements ReusableBuilder<Tuple2<K, V>, HashMap<K, V>> {
    private HashMap<K, V> aliased;
    private MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public final int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<HashMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable<Tuple2<K, V>> $plus$plus$eq(IterableOnce<Tuple2<K, V>> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    private BitmapIndexedMapNode<K, V> newEmptyRootNode() {
        return new BitmapIndexedMapNode(0, 0, (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Any()), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, 0);
    }

    private HashMap<K, V> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashMap<K, V> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode;
    }

    private void scala$collection$immutable$HashMapBuilder$$rootNode_$eq(MapNode<K, V> x$1) {
        this.scala$collection$immutable$HashMapBuilder$$rootNode = x$1;
    }

    public <V0> V0 getOrElse(K key, V0 value) {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return value;
        }
        int originalHash = Statics.anyHash(key);
        return (V0)this.scala$collection$immutable$HashMapBuilder$$rootNode().getOrElse(key, originalHash, Hashing$.MODULE$.improve(originalHash), 0, (Function0<Object> & Serializable)() -> value);
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <V1> void insertValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private int[] removeElement(int[] as, int ix) {
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length - 1];
        System.arraycopy(as, 0, result, 0, ix);
        System.arraycopy(as, ix + 1, result, ix, as.length - ix - 1);
        return var3_3;
    }

    private void migrateFromInlineToNode(BitmapIndexedMapNode<K, V> bm, int keyHash, int bitpos, MapNode<K, V> node) {
        int dataIx = bm.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = bm.content().length - 2 - bm.nodeIndex(bitpos);
        Object[] src = bm.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(bm.originalHashes(), dataIx);
        bm.dataMap_$eq(bm.dataMap() ^ bitpos);
        bm.nodeMap_$eq(bm.nodeMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() - 1 + node.size());
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + (node.cachedJavaKeySetHashCode() - keyHash));
    }

    private <V1> void setValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K newKey, V1 newValue) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        bm.content()[idx + 1] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    public void update(MapNode<K, V> mapNode, K key, V value, int originalHash, int keyHash, int shift) {
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            int n = keyHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedMapNode.dataMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.dataMap(), n, n2);
                Object object = bitmapIndexedMapNode.content()[2 * index];
                int n3 = bitmapIndexedMapNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(object, key)) {
                    this.setValue(bitmapIndexedMapNode, n2, key, value);
                    return;
                }
                Object object2 = bitmapIndexedMapNode.content()[2 * index + 1];
                int key0Hash = Hashing$.MODULE$.improve(n3);
                MapNode<Object, Object> subNodeNew = bitmapIndexedMapNode.mergeTwoKeyValPairs(object, object2, n3, key0Hash, key, value, originalHash, keyHash, shift + 5);
                this.migrateFromInlineToNode(bitmapIndexedMapNode, key0Hash, n2, subNodeNew);
                return;
            }
            if ((bitmapIndexedMapNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedMapNode.getNode(index);
                int beforeSize = ((MapNode)subNode).size();
                int beforeHash = subNode.cachedJavaKeySetHashCode();
                this.update((MapNode<K, V>)subNode, key, value, originalHash, keyHash, shift + 5);
                bitmapIndexedMapNode.size_$eq(bitmapIndexedMapNode.size() + (((MapNode)subNode).size() - beforeSize));
                bitmapIndexedMapNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedMapNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHash));
                return;
            }
            this.insertValue(bitmapIndexedMapNode, n2, key, originalHash, keyHash, value);
            return;
        }
        if (mapNode instanceof HashCollisionMapNode) {
            void updated_elem;
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            int index = hashCollisionMapNode.indexOf(key);
            if (index < 0) {
                hashCollisionMapNode.content_$eq(hashCollisionMapNode.content().appended(new Tuple2<K, V>(key, value)));
                return;
            }
            Vector vector = hashCollisionMapNode.content();
            Tuple2<K, V> tuple2 = new Tuple2<K, V>(key, value);
            if (vector == null) {
                throw null;
            }
            tuple2 = null;
            hashCollisionMapNode.content_$eq(vector.updateAt(index, updated_elem));
            return;
        }
        throw new MatchError(mapNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.scala$collection$immutable$HashMapBuilder$$rootNode().copy());
    }

    @Override
    public HashMap<K, V> result() {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashMap<K, V>(this.scala$collection$immutable$HashMapBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    public HashMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem._1());
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), elem._1(), elem._2(), h, im, 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value) {
        this.ensureUnaliased();
        int originalHash = Statics.anyHash(key);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashMap) {
            HashMap hashMap = (HashMap)xs;
            new ChampBaseIterator<MapNode<K, V>>(this, hashMap){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashMapBuilder$$rootNode(), ((MapNode)this.currentValueNode()).getKey(this.currentValueCursor()), ((MapNode)this.currentValueNode()).getValue(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<Tuple2<K, V>> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne(it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() > 0) {
            this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.newEmptyRootNode());
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode().size();
    }

    @Override
    public int knownSize() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode().size();
    }
}

