/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalap;

import java.io.Writer;
import scala.Predef$;
import scala.ScalaObject;
import scala.runtime.BoxesRunTime;

public class CodeWriter
implements ScalaObject {
    private boolean line;
    private boolean space;
    private boolean align;
    private int level;
    private String step;
    private String nl;
    private Writer writer;

    public CodeWriter(Writer writer) {
        this.writer = writer;
        this.nl = System.getProperty("line.separator");
        this.step = "  ";
        this.level = 0;
        this.align = false;
        this.space = false;
        this.line = false;
    }

    public String toString() {
        return this.writer.toString();
    }

    public CodeWriter print(String value) {
        try {
            if (this.align()) {
                for (int i = 0; i < this.level(); ++i) {
                    this.writer.write(this.step());
                }
            }
            if (this.space()) {
                this.writer.write(" ");
            }
            this.writer.write(value);
            this.align_$eq(false);
            this.space_$eq(false);
            this.line_$eq(false);
            return this;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.error("IO error");
            return null;
        }
    }

    public CodeWriter print(double value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter print(float value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter print(long value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter print(int value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter print(char value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter print(short value) {
        return this.print(String.valueOf(BoxesRunTime.boxToShort((short)value)));
    }

    public CodeWriter print(byte value) {
        return this.print(String.valueOf(BoxesRunTime.boxToByte((byte)value)));
    }

    public CodeWriter print(boolean value) {
        return this.print(String.valueOf(value));
    }

    public CodeWriter println(String value) {
        return this.print(value).newline();
    }

    public CodeWriter println(double value) {
        return this.print(value).newline();
    }

    public CodeWriter println(float value) {
        return this.print(value).newline();
    }

    public CodeWriter println(long value) {
        return this.print(value).newline();
    }

    public CodeWriter println(int value) {
        return this.print(value).newline();
    }

    public CodeWriter println(char value) {
        return this.print(value).newline();
    }

    public CodeWriter println(short value) {
        return this.print(value).newline();
    }

    public CodeWriter println(byte value) {
        return this.print(value).newline();
    }

    public CodeWriter println(boolean value) {
        return this.print(value).newline();
    }

    public CodeWriter println() {
        return this.newline();
    }

    public void $times() {
    }

    public CodeWriter newspace() {
        this.space_$eq(!this.align());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeWriter newline() {
        CodeWriter codeWriter;
        String string = this.step();
        if (string == null || string.equals(null)) {
            codeWriter = this.newspace();
            return codeWriter;
        }
        if (this.line()) {
            codeWriter = this;
            return codeWriter;
        }
        try {
            this.writer.write(this.nl());
            this.line_$eq(this.align());
            this.align_$eq(true);
            this.space_$eq(false);
            codeWriter = this;
            return codeWriter;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.error("IO error");
            return null;
        }
    }

    public CodeWriter undent() {
        this.level_$eq(this.level() - 1);
        return this;
    }

    public CodeWriter indent() {
        this.level_$eq(this.level() + 1);
        return this;
    }

    public CodeWriter setIndentString(String step) {
        this.step_$eq(step);
        return this;
    }

    public String getIndentString() {
        return this.step();
    }

    public CodeWriter setIndentWidth(int width) {
        StringBuffer buffer = new StringBuffer(width);
        int i = 0;
        while (i < width) {
            buffer.append(' ');
        }
        return this.setIndentString(buffer.toString());
    }

    public int getIndentWidth() {
        String string = this.step();
        return string == null || string.equals(null) ? -1 : this.step().length();
    }

    public CodeWriter setIndentLevel(int level) {
        this.level_$eq(level);
        return this;
    }

    public int getIndentLevel() {
        return this.level();
    }

    public Writer getWriter() {
        return this.writer;
    }

    private /* synthetic */ void line_$eq(boolean x$1) {
        this.line = x$1;
    }

    private /* synthetic */ boolean line() {
        return this.line;
    }

    private /* synthetic */ void space_$eq(boolean x$1) {
        this.space = x$1;
    }

    private /* synthetic */ boolean space() {
        return this.space;
    }

    private /* synthetic */ void align_$eq(boolean x$1) {
        this.align = x$1;
    }

    private /* synthetic */ boolean align() {
        return this.align;
    }

    private /* synthetic */ void level_$eq(int x$1) {
        this.level = x$1;
    }

    private /* synthetic */ int level() {
        return this.level;
    }

    private /* synthetic */ void step_$eq(String x$1) {
        this.step = x$1;
    }

    private /* synthetic */ String step() {
        return this.step;
    }

    private /* synthetic */ String nl() {
        return this.nl;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

