/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApproximateNumeric<Type>
extends Numeric<Type>
implements ScalaObject {
    private final int nativeTypeId;

    public ApproximateNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    @Override
    public String sqlString() {
        block5: {
            String string;
            int tp1 = this.precisionRadix();
            int tp2 = this.precision();
            switch (tp1) {
                default: {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
                }
                case 10: {
                    string = new StringBuilder().append((Object)"FLOAT (").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp2)).toString()).append((Object)")").toString();
                    break;
                }
                case 2: {
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)tp2), (Object)BoxesRunTime.boxToInteger((int)64))) {
                        string = "REAL";
                        break;
                    }
                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)tp2), (Object)BoxesRunTime.boxToInteger((int)128))) break block5;
                    string = "DOUBLE PRECISION";
                }
            }
            return string;
        }
        throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
    }

    @Override
    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType temp3 = datatype;
        if (temp3 instanceof ApproximateNumeric) {
            ApproximateNumeric temp4;
            ApproximateNumeric dt = temp4 = (ApproximateNumeric)temp3;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType temp1 = datatype;
        if (temp1 instanceof ApproximateNumeric) {
            ApproximateNumeric temp2;
            ApproximateNumeric dt = temp2 = (ApproximateNumeric)temp1;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

