/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple3;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesUtility;

public abstract class ExactNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ExactNumeric(int n) {
        this.nativeTypeId = n;
        super(n);
    }

    public String sqlString() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesUtility.boxToInteger((int)this.precisionRadix()), (Object)BoxesUtility.boxToInteger((int)this.precision()), (Object)BoxesUtility.boxToInteger((int)this.scale()));
        if (tuple3 != null) {
            String string;
            Tuple3 tuple32 = tuple3;
            if (BoxesUtility.unboxToInt((Object)tuple32._1()) != 2) {
                if (BoxesUtility.unboxToInt((Object)tuple32._1()) != 10) {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
                }
                string = BoxesUtility.unboxToInt((Object)tuple32._3()) != 0 ? "NUMERIC (" + tuple32._2().toString() + ", " + tuple32._3().toString() + ")" : "NUMERIC (" + tuple32._2().toString() + ")";
            } else if (BoxesUtility.unboxToInt((Object)tuple32._2()) != 16 || BoxesUtility.unboxToInt((Object)tuple32._3()) != 0) {
                if (BoxesUtility.unboxToInt((Object)tuple32._2()) != 32 || BoxesUtility.unboxToInt((Object)tuple32._3()) != 0) {
                    if (BoxesUtility.unboxToInt((Object)tuple32._2()) != 64 || BoxesUtility.unboxToInt((Object)tuple32._3()) != 0) {
                        if (BoxesUtility.unboxToInt((Object)tuple32._2()) != Integer.MAX_VALUE || BoxesUtility.unboxToInt((Object)tuple32._3()) != 0) {
                            throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                        }
                        string = "BIGINT";
                    } else {
                        string = "BIGINT";
                    }
                } else {
                    string = "INTEGER";
                }
            } else {
                string = "SMALLINT";
            }
            return string;
        }
        throw new MatchError((Object)tuple3);
    }

    public abstract int scale();

    public boolean isSubtypeOf(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ExactNumeric)) {
            bl = false;
        } else {
            ExactNumeric exactNumeric;
            ExactNumeric exactNumeric2 = exactNumeric = (ExactNumeric)dataType2;
            bl = this.nativeTypeId() == exactNumeric2.nativeTypeId() && this.precisionRadix() == exactNumeric2.precisionRadix() && this.precision() <= exactNumeric2.precision() && this.scale() <= exactNumeric2.scale() && this.signed() == exactNumeric2.signed();
        }
        return bl;
    }

    public boolean isEquivalent(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ExactNumeric)) {
            bl = false;
        } else {
            ExactNumeric exactNumeric;
            ExactNumeric exactNumeric2 = exactNumeric = (ExactNumeric)dataType2;
            bl = this.nativeTypeId() == exactNumeric2.nativeTypeId() && this.precisionRadix() == exactNumeric2.precisionRadix() && this.precision() == exactNumeric2.precision() && this.scale() == exactNumeric2.scale() && this.signed() == exactNumeric2.signed();
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

