/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.URLZipArchive$;
import scala.tools.nsc.io.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLZipArchive
extends AbstractFile
implements ScalaObject {
    private DirEntry root;
    private final URL url;

    public URLZipArchive(URL url) {
        this.url = url;
        Predef$.MODULE$.assert(url != null);
    }

    private final InputStream getEntryInputStream$1(InputStream in) {
        ArrayBuffer buf = new ArrayBuffer();
        byte[] data = new byte[1024];
        int n = in.read(data);
        while (n > 0) {
            buf.$plus$plus$eq(ScalaRunTime$.MODULE$.boxArray((Object)data), 0, n);
            n = in.read(data);
        }
        Object object = ScalaRunTime$.MODULE$.arrayValue(buf.toArray(), Byte.TYPE);
        return new ByteArrayInputStream((byte[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE) : object));
    }

    private DirEntry getDir(Map<String, DirEntry> dirs, String path) {
        Option temp11;
        block4: {
            DirEntry dirEntry;
            block3: {
                block2: {
                    DirEntry temp13;
                    temp11 = dirs.get((Object)path);
                    if (!(temp11 instanceof Some)) break block2;
                    Some temp12 = (Some)temp11;
                    dirEntry = temp13 = (DirEntry)temp12.x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option = temp11;
                if ((none$ != null ? !none$.equals(option) : option != null) || !(temp11 instanceof None$)) break block4;
                int index = path.lastIndexOf(47, path.length() - 2);
                String name = index < 0 ? path : path.substring(index + 1);
                String home = index < 0 ? "/" : path.substring(0, index + 1);
                DirEntry parent = this.getDir(dirs, home);
                DirEntry dir = new DirEntry(this, name.substring(0, name.length() - 1), path);
                parent.entries().update((Object)name, (Object)dir);
                dirs.update((Object)path, (Object)dir);
                dirEntry = dir;
            }
            return dirEntry;
        }
        throw new MatchError(temp11.toString());
    }

    private void load() {
        this.root_$eq(new DirEntry(this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        ZipInputStream zis = new ZipInputStream(this.input());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String path$2 = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path$2.endsWith("/"), (Function0)new $anonfun$load$2(this, path$2));
            if (entry.isDirectory()) {
                DirEntry dir = this.getDir((Map<String, DirEntry>)dirs, path$2);
                Predef$.MODULE$.assert(dir.entry() == null, (Function0)new $anonfun$load$3(this, path$2));
                dir.entry_$eq(entry);
            } else {
                int index = path$2.lastIndexOf(47);
                String name = index < 0 ? path$2 : path$2.substring(index + 1);
                String home = index < 0 ? "/" : path$2.substring(0, index + 1);
                DirEntry parent = this.getDir((Map<String, DirEntry>)dirs, home);
                Predef$.MODULE$.assert(!parent.entries().contains((Object)path$2), (Function0)new $anonfun$load$4(this, path$2));
                InputStream in = this.getEntryInputStream$1(zis);
                parent.entries().update((Object)name, (Object)new FileEntry(this, name, path$2, entry, in));
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().iterator();
    }

    public Nothing$ output() {
        throw new Error("unsupported");
    }

    @Override
    public InputStream input() {
        return this.url.openStream();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long lastModified() {
        void var1_1;
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.url.openConnection().getLastModified();
        }
        catch (Throwable throwable) {
            exceptionResult2 = 0L;
        }
        return (long)var1_1;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public AbstractFile absolute() {
        return this;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public String path() {
        return this.url.getPath();
    }

    @Override
    public String name() {
        return this.url.getFile();
    }

    public Nothing$ container() {
        throw new Error("unsupported");
    }

    private void root_$eq(DirEntry dirEntry) {
        this.root = dirEntry;
    }

    private DirEntry root() {
        return this.root;
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public Entry(String name, String path) {
            if (URLZipArchive.this == null) {
                throw new NullPointerException();
            }
            super(name, path);
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$Entry$$$outer() {
            return URLZipArchive.this;
        }

        public final String path() {
            return new StringBuilder().append((Object)this.scala$tools$nsc$io$URLZipArchive$Entry$$$outer().toString()).append((Object)"(").append((Object)super.path()).append((Object)")").toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private final Map<String, Entry> entries = new HashMap();

        public DirEntry(URLZipArchive $outer, String name, String path) {
            super(name, path);
        }

        @Override
        public AbstractFile lookupName(String name, boolean directory) {
            Option temp15;
            block4: {
                Entry entry;
                block3: {
                    block2: {
                        Entry temp17;
                        temp15 = this.entries().get((Object)(directory ? new StringBuilder().append((Object)name).append((Object)"/").toString() : name));
                        if (!(temp15 instanceof Some)) break block2;
                        Some temp16 = (Some)temp15;
                        entry = temp17 = (Entry)temp16.x();
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option = temp15;
                    if ((none$ != null ? !none$.equals(option) : option != null) || !(temp15 instanceof None$)) break block4;
                    entry = null;
                }
                return entry;
            }
            throw new MatchError(temp15.toString());
        }

        @Override
        public Iterator<AbstractFile> iterator() {
            return this.entries().valuesIterator();
        }

        @Override
        public long lastModified() {
            return this.entry() != null ? this.entry().getTime() : super.lastModified();
        }

        public Nothing$ input() {
            throw new Error("cannot read directories");
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map<String, Entry> entries() {
            return this.entries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private final InputStream in;
        private final ZipEntry entry;

        public FileEntry(URLZipArchive $outer, String name, String path, ZipEntry entry, InputStream in) {
            this.entry = entry;
            this.in = in;
            super(name, path);
        }

        public Some<Integer> sizeOption() {
            return new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.entry().getSize())));
        }

        @Override
        public InputStream input() {
            return this.in();
        }

        @Override
        public long lastModified() {
            return this.entry().getTime();
        }

        public InputStream in() {
            return this.in;
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }
}

