/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.PrintStream;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileSocket;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.FatalError;
import scala.tools.nsc.Global;
import scala.tools.nsc.OfflineCompilerCommand;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.StandardCompileServer$;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.File;
import scala.tools.nsc.io.Path;
import scala.tools.nsc.io.Path$;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.util.SocketServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardCompileServer
extends SocketServer
implements ScalaObject {
    private final Directory redirectDir;
    private ConsoleReporter reporter;
    private final Runtime runtime;
    private Global compiler = null;
    private boolean shutDown = false;
    private final double MaxCharge;
    private final String versionMsg = new StringBuilder().append((Object)"Fast Scala compiler ").append((Object)Properties$.MODULE$.versionString()).append((Object)" -- ").append((Object)Properties$.MODULE$.copyrightString()).toString();

    public StandardCompileServer() {
        this.MaxCharge = 0.8;
        this.runtime = Runtime.getRuntime();
        Path qual$1 = this.compileSocket().tmpDir().$div(Path$.MODULE$.string2path("output-redirects"));
        boolean x$1 = qual$1.createDirectory$default$1();
        boolean x$2 = qual$1.createDirectory$default$2();
        this.redirectDir = qual$1.createDirectory(x$1, x$2);
    }

    public final void error$1(String msg) {
        this.out().println(new Tuple2((Object)new FakePos("fsc"), (Object)new StringBuilder().append((Object)msg).append((Object)"\n  fsc -help  gives more information").toString()));
    }

    public void main(String[] args2) {
        this.redirect((Function1<PrintStream, Object>)new $anonfun$main$1(this), "scala-compile-server-out.log");
        this.redirect((Function1<PrintStream, Object>)new $anonfun$main$2(this), "scala-compile-server-err.log");
        int n = this.port();
        System.err.println(new StringBuilder().append((Object)"...starting server on socket ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"...").toString());
        System.err.flush();
        this.compileSocket().setPort(this.port());
        this.run();
        this.compileSocket().deletePort(this.port());
        throw this.exit(0);
    }

    private void redirect(Function1<PrintStream, Object> setter2, String filename) {
        Path qual$2 = this.redirectDir().$div(Path$.MODULE$.string2path(filename));
        boolean x$3 = qual$2.createFile$default$1();
        File qual$3 = qual$2.createFile(x$3);
        boolean x$4 = qual$3.bufferedOutput$default$1();
        setter2.apply((Object)new PrintStream(qual$3.bufferedOutput(x$4)));
    }

    private Directory redirectDir() {
        return this.redirectDir;
    }

    @Override
    public void session() {
        Throwable throwable2;
        block16: {
            this.printMemoryStats();
            String password = this.compileSocket().getPassword(this.port());
            String guessedPassword = this.in().readLine();
            String input = this.in().readLine();
            if (input != null) {
                String string = password;
                if (!(string != null ? !string.equals(guessedPassword) : guessedPassword != null)) {
                    Object[] objectArray = input.split("\u0000", -1);
                    List args2 = new ArrayOps.ofRef(objectArray).toList();
                    if (args2.contains((Object)"-shutdown")) {
                        this.out().println("[Compile server exited]");
                        this.shutDown_$eq(true);
                        return;
                    }
                    if (args2.contains((Object)"-reset")) {
                        this.out().println("[Compile server was reset]");
                        this.compiler_$eq(null);
                        return;
                    }
                    OfflineCompilerCommand command$1 = this.newOfflineCompilerCommand((List<String>)args2, new Settings((Function1<String, Object>)new $anonfun$1(this)), (Function1<String, Object>)new $anonfun$2(this), false);
                    this.reporter_$eq(new $anon$2(this, command$1));
                    if (command$1.shouldStopWithInfo()) {
                        this.reporter().info(null, command$1.getInfoMessage(this.newGlobal(command$1.settings(), this.reporter())), true);
                    } else if (command$1.files().isEmpty()) {
                        this.reporter().info(null, command$1.usageMsg(), true);
                    } else {
                        try {
                            if (this.compiler() != null && this.settingsAreCompatible(command$1.settings(), this.compiler().settings())) {
                                this.compiler().settings_$eq(command$1.settings());
                                this.compiler().reporter_$eq(this.reporter());
                            } else {
                                if (args2.contains((Object)"-verbose")) {
                                    this.out().println("[Starting new compile server instance]");
                                }
                                this.compiler_$eq(this.newGlobal(command$1.settings(), this.reporter()));
                            }
                            Global c = this.compiler();
                            Global.Run run2 = c.new Global.Run();
                            run2.compile(command$1.files());
                        }
                        catch (Throwable throwable2) {
                            if (throwable2 instanceof FatalError) {
                                FatalError temp2 = (FatalError)throwable2;
                                String temp3 = temp2.msg();
                                if (BoxesRunTime.unboxToBoolean((Object)command$1.settings().debug().value())) {
                                    temp2.printStackTrace(this.out());
                                }
                                this.reporter().error(null, new StringBuilder().append((Object)"fatal error: ").append((Object)temp3).toString());
                                this.compiler_$eq(null);
                            }
                            if (throwable2 == null) break block16;
                            throwable2.printStackTrace(this.out());
                            this.reporter().error(null, new StringBuilder().append((Object)"fatal error (server aborted): ").append((Object)throwable2.getMessage()).toString());
                            this.shutDown_$eq(true);
                        }
                        this.reporter().printSummary();
                        if (this.isMemoryFullEnough()) {
                            this.compiler_$eq(null);
                        }
                    }
                }
            }
            return;
        }
        throw new MatchError(throwable2.toString());
    }

    public OfflineCompilerCommand newOfflineCompilerCommand(List<String> arguments, Settings settings, Function1<String, Object> error, boolean interactive) {
        return new OfflineCompilerCommand(arguments, settings, error, interactive);
    }

    public boolean isMemoryFullEnough() {
        this.runtime().gc();
        return (double)(this.runtime().totalMemory() - this.runtime().freeMemory()) / (double)this.runtime().maxMemory() > this.MaxCharge();
    }

    public void printMemoryStats() {
        Object[] objectArray = new Object[3];
        long l = this.runtime().totalMemory();
        objectArray[0] = BoxesRunTime.boxToLong((long)l);
        long l2 = this.runtime().maxMemory();
        objectArray[1] = BoxesRunTime.boxToLong((long)l2);
        long l3 = this.runtime().freeMemory();
        objectArray[2] = BoxesRunTime.boxToLong((long)l3);
        System.out.println(Predef$.MODULE$.augmentString("New session, total memory = %s, max memory = %s, free memory = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
        System.out.flush();
    }

    @Override
    public void timeout() {
        if (this.compileSocket().portFile(this.port()).exists()) {
            return;
        }
        throw this.fatal("port file no longer exists; skipping cleanup");
    }

    public Global newGlobal(Settings settings$1, Reporter reporter$1) {
        return new $anon$1(this, settings$1, reporter$1);
    }

    public void reporter_$eq(ConsoleReporter consoleReporter) {
        this.reporter = consoleReporter;
    }

    public ConsoleReporter reporter() {
        return this.reporter;
    }

    private Runtime runtime() {
        return this.runtime;
    }

    private Nothing$ exit(int code) {
        System.err.close();
        System.out.close();
        return Predef$.MODULE$.exit(code);
    }

    private boolean settingsAreCompatible(Settings s1, Settings s2) {
        Settings settings = s1;
        return !(settings != null ? !((Object)settings).equals(s2) : s2 != null);
    }

    private void compiler_$eq(Global global) {
        this.compiler = global;
    }

    private Global compiler() {
        return this.compiler;
    }

    public void shutDown_$eq(boolean bl) {
        this.shutDown = bl;
    }

    @Override
    public boolean shutDown() {
        return this.shutDown;
    }

    public double MaxCharge() {
        return this.MaxCharge;
    }

    public String versionMsg() {
        return this.versionMsg;
    }

    public CompileSocket compileSocket() {
        return CompileSocket$.MODULE$;
    }
}

