/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.util.Signature;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class PEStream
implements Signature {
    public final String name;
    public final int offset;
    public final int size;
    private final PEFile file;
    private final ByteBuffer buffer;

    public PEStream(PEFile pEFile) {
        this.file = pEFile;
        this.offset = pEFile.fromRVA(pEFile.rvaMetadata + pEFile.readInt());
        this.size = pEFile.readInt();
        this.buffer = pEFile.getBuffer(this.offset, this.size);
        int n = 0;
        byte[] byArray = new byte[16];
        do {
            byArray[n] = (byte)pEFile.readByte();
        } while (0 != byArray[++n - 1]);
        this.name = new String(byArray, 0, n - 1);
        pEFile.align(4, pEFile.posMetadata);
    }

    private void seek(int n) {
        try {
            this.buffer.position(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("\nSeek failed in file " + this.file + " for position " + n + " of stream " + this.name + " (" + this.buffer + ")");
            throw illegalArgumentException;
        }
    }

    public String getString(int n) {
        this.seek(n);
        this.buffer.mark();
        int n2 = 0;
        while (this.getByte() != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        this.buffer.reset();
        this.buffer.get(byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public int getByte() {
        return this.buffer.get() + 256 & 0xFF;
    }

    public byte[] getGUID(int n) {
        this.seek(n);
        byte[] byArray = new byte[32];
        try {
            this.buffer.get(byArray);
        }
        catch (Exception exception) {
            System.err.println();
            System.err.println("PEStream.getBlob(): Exception for pos = " + n + " and buf.length = " + byArray.length);
            System.err.println("\tbuffer = " + this.buffer);
            exception.printStackTrace();
            throw new RuntimeException();
        }
        return byArray;
    }

    public int readLength() {
        int n = this.getByte();
        if ((n & 0x80) != 0 && ((n = (n & 0x7F) << 8 | this.getByte()) & 0x4000) != 0) {
            n = (n & 0x3FFF) << 16 | this.getByte() << 8 | this.getByte();
        }
        return n;
    }

    public byte[] getBlob(int n) {
        this.seek(n);
        int n2 = this.readLength();
        byte[] byArray = new byte[n2];
        this.buffer.get(byArray);
        return byArray;
    }

    public PEFile.Sig getSignature(int n) {
        this.seek(n);
        return this.file.newSignature(this.buffer);
    }

    public Object getConstant(int n, int n2) {
        Object var3_3 = null;
        this.seek(n2);
        int n3 = this.readLength();
        switch (n) {
            case 2: {
                assert (n3 == 1);
                return this.buffer.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: {
                assert (n3 == 2) : "length == " + n3;
                return new Character(this.buffer.getChar());
            }
            case 4: 
            case 5: {
                assert (n3 == 1);
                return new Byte(this.buffer.get());
            }
            case 6: 
            case 7: {
                assert (n3 == 2);
                return new Short(this.buffer.getShort());
            }
            case 8: 
            case 9: {
                assert (n3 == 4);
                return new Integer(this.buffer.getInt());
            }
            case 10: 
            case 11: {
                assert (n3 == 8);
                return new Long(this.buffer.getLong());
            }
            case 12: {
                assert (n3 == 4);
                return new Float(this.buffer.getFloat());
            }
            case 13: {
                assert (n3 == 8);
                return new Double(this.buffer.getDouble());
            }
            case 14: {
                try {
                    return new String(this.getBlob(n2), "UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
            }
        }
        throw new RuntimeException("Illegal constant type: " + n);
    }

    public void dump(PrintStream printStream) {
        printStream.println("Stream name:   " + this.name + " (length " + this.name.length() + " characters)");
        printStream.println("Stream offset: 0x" + PEFile.int2hex(this.offset));
        printStream.println("Stream size:   0x" + PEFile.int2hex(this.size));
    }
}

