/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.StandardCompileClient;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.File;
import scala.tools.nsc.io.File$;
import scala.tools.nsc.io.Path;
import scala.tools.nsc.io.Path$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileSocket
implements ScalaObject {
    private final int sleepTime;
    private final int MaxAttempts;
    private final Directory portsDir;
    private final Directory tmpDir;
    private final Pattern errorPattern;
    private final String errorRegex;
    private final String serverClass;
    private final String vmCommand;

    public CompileSocket() {
        String temp1;
        block7: {
            String string;
            block6: {
                Codec x$10;
                block4: {
                    block5: {
                        temp1 = Properties$.MODULE$.scalaHome();
                        if (temp1 != null) break block4;
                        if (!true) break block5;
                        string = this.cmdName();
                        break block6;
                    }
                    throw new MatchError(temp1.toString());
                }
                if (!true) break block7;
                Path x$9 = Path$.MODULE$.string2path(temp1);
                Path trial = File$.MODULE$.apply(x$9, x$10 = File$.MODULE$.apply$default$2(x$9)).$div(Path$.MODULE$.string2path("bin")).$div(Path$.MODULE$.string2path(this.cmdName()));
                string = trial.canRead() ? trial.path() : this.cmdName();
            }
            this.vmCommand = string;
            this.serverClass = "scala.tools.nsc.CompileServer";
            this.errorRegex = ".*(errors? found|don't know|bad option).*";
            this.errorPattern = Pattern.compile(this.errorRegex());
            String udir = (String)Option$.MODULE$.apply((Object)Properties$.MODULE$.userName()).getOrElse((Function0)new $anonfun$1(this));
            Path qual$1 = Path$.MODULE$.apply(Properties$.MODULE$.tmpDir()).$div(Path$.MODULE$.string2path("scala-devel")).$div(Path$.MODULE$.string2path(udir));
            boolean x$3 = qual$1.createDirectory$default$1();
            boolean x$4 = qual$1.createDirectory$default$2();
            Directory f2 = qual$1.createDirectory(x$3, x$4);
            if (f2.isDirectory() && f2.canWrite()) {
                this.info(new StringBuilder().append((Object)"[Temp directory: ").append((Object)f2).append((Object)"]").toString());
                this.tmpDir = f2;
                Path qual$2 = this.tmpDir().$div(Path$.MODULE$.string2path(this.dirName()));
                boolean x$5 = qual$2.createDirectory$default$1();
                boolean x$6 = qual$2.createDirectory$default$2();
                this.portsDir = qual$2.createDirectory(x$5, x$6);
                this.MaxAttempts = 100;
                this.sleepTime = 20;
                return;
            }
            throw this.fatal("Could not find a directory for temporary files");
        }
        throw new MatchError(temp1.toString());
    }

    public final long check$1(File file) {
        Thread.sleep(100L);
        return file.length();
    }

    private final Nothing$ fail$1(String string) {
        return this.fatal(Predef$.MODULE$.augmentString("Malformed server address: %s; exiting").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private final Socket getsock$1(int attempts, String string, boolean bl) {
        Socket socket;
        if (attempts == 0) {
            this.error("Unable to establish connection to compilation daemon");
            socket = null;
        } else {
            Socket exceptionResult3;
            int port;
            int n = port = bl ? this.getPort(string) : this.pollPort();
            if (port < 0) {
                return null;
            }
            InetAddress hostAdr = InetAddress.getLocalHost();
            try {
                Socket result = new Socket(hostAdr, port);
                this.info(new StringBuilder().append((Object)"[Connected to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
                exceptionResult3 = result;
            }
            catch (Exception exception) {
                this.info(exception.toString());
                this.info(new StringBuilder().append((Object)"[Connecting to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)" failed; re-trying...]").toString());
                if (attempts % 2 == 0) {
                    this.portFile(port).delete();
                }
                Thread.sleep(100L);
                exceptionResult3 = this.getsock$1(attempts - 1, string, bl);
            }
            socket = exceptionResult3;
        }
        return socket;
    }

    public String getPassword(int port) {
        File ff$1 = this.portFile(port);
        BufferedReader f2 = ff$1.bufferedReader(ff$1.bufferedReader$default$1());
        if (package$.MODULE$.Iterator().continually((Function0)new $anonfun$getPassword$1(this, ff$1)).take(50).find((Function1)new $anonfun$getPassword$2(this)).isEmpty()) {
            ff$1.delete();
            throw this.fatal("Unable to establish connection to server.");
        }
        String result = f2.readLine();
        f2.close();
        return result;
    }

    public Socket getSocket(String hostName, int port) {
        try {
            Socket exceptionResult2 = new Socket(hostName, port);
            return exceptionResult2;
        }
        catch (Throwable throwable) {
            block10: {
                block11: {
                    block9: {
                        block8: {
                            if (!(throwable instanceof IOException)) break block8;
                            if (!true) {
                                throw new MatchError(throwable.toString());
                            }
                            break block9;
                        }
                        if (!(throwable instanceof SecurityException)) break block10;
                        if (!true) break block11;
                    }
                    String string = "Unable to establish connection to server %s:%d; exiting";
                    throw this.fatal(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)port)})));
                }
                throw new MatchError(throwable.toString());
            }
            if (true) {
                throw throwable;
            }
            throw new MatchError(throwable.toString());
        }
    }

    public Socket getSocket(String serverAdr$1) {
        int temp14 = serverAdr$1.indexOf(58);
        if (temp14 == -1) {
            if (true) {
                throw this.fail$1(serverAdr$1);
            }
            throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp14)).toString());
        }
        if (true) {
            String hostName = (String)new StringOps(serverAdr$1).take(temp14);
            Option<Integer> temp11 = this.parseInt((String)new StringOps(serverAdr$1).drop(temp14 + 1));
            if (temp11 instanceof Some) {
                Some temp12 = (Some)temp11;
                int temp13 = BoxesRunTime.unboxToInt((Object)temp12.x());
                if (true) {
                    return this.getSocket(hostName, temp13);
                }
                throw new MatchError(temp11.toString());
            }
            if (true) {
                throw this.fail$1(serverAdr$1);
            }
            throw new MatchError(temp11.toString());
        }
        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp14)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Option<Integer> parseInt(String x2) {
        void var3_3;
        None$ exceptionResult1;
        try {
            int n = new StringOps(x2).toInt();
            exceptionResult1 = new Some((Object)BoxesRunTime.boxToInteger((int)n));
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var3_3;
    }

    public Socket getOrCreateSocket(String vmArgs$1, boolean create$1) {
        int nAttempts = 49;
        return this.getsock$1(nAttempts, vmArgs$1, create$1);
    }

    public boolean deletePort(int port) {
        return this.portFile(port).delete();
    }

    public void setPort(int port) {
        File file = this.portFile(port);
        int n = new SecureRandom().nextInt();
        String secret = ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        try {
            file.writeAll((Traversable<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{secret})), file.writeAll$default$2(), file.writeAll$default$3());
            return;
        }
        catch (Throwable throwable) {
            block10: {
                block11: {
                    block9: {
                        block8: {
                            if (!(throwable instanceof FileNotFoundException)) break block8;
                            if (!true) {
                                throw new MatchError(throwable.toString());
                            }
                            break block9;
                        }
                        if (!(throwable instanceof SecurityException)) break block10;
                        if (!true) break block11;
                    }
                    String string = "Cannot create file: %s";
                    throw this.fatal(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.path()})));
                }
                throw new MatchError(throwable.toString());
            }
            if (true) {
                throw throwable;
            }
            throw new MatchError(throwable.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPort(String vmArgs) {
        void var3_3;
        int attempts = 0;
        int port = this.pollPort();
        if (port < 0) {
            this.startNewServer(vmArgs);
        }
        while (port < 0 && attempts < this.MaxAttempts()) {
            ++attempts;
            Thread.sleep(this.sleepTime());
            port = this.pollPort();
        }
        this.info(new StringBuilder().append((Object)"[Port number: ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
        if (port < 0) {
            throw this.fatal("Could not connect to compilation daemon.");
        }
        return (int)var3_3;
    }

    private int pollPort() {
        List temp3;
        block5: {
            block6: {
                int n;
                block4: {
                    block2: {
                        block3: {
                            temp3 = this.portsDir().list().toList();
                            Nil$ nil$ = Nil$.MODULE$;
                            if (nil$ != null ? !nil$.equals(temp3) : temp3 != null) break block2;
                            if (!true) break block3;
                            n = -1;
                            break block4;
                        }
                        throw new MatchError(temp3.toString());
                    }
                    if (!(temp3 instanceof .colon.colon)) break block5;
                    .colon.colon temp5 = (.colon.colon)temp3;
                    Path temp6 = (Path)temp5.hd$1();
                    List temp7 = temp5.tl$1();
                    if (!true) break block6;
                    temp7.forall((Function1)new $anonfun$pollPort$1(this));
                    String string = temp6.name();
                    n = new StringOps(string).toInt();
                }
                return n;
            }
            throw new MatchError(temp3.toString());
        }
        throw new MatchError(temp3.toString());
    }

    public File portFile(int port) {
        Path x$7 = Path$.MODULE$.string2path(((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        Codec x$8 = File$.MODULE$.apply$default$2(x$7);
        return this.portsDir().$div(File$.MODULE$.apply(x$7, x$8));
    }

    private void startNewServer(String vmArgs) {
        String cmd = this.serverCommand(vmArgs);
        this.info(new StringBuilder().append((Object)"[Executed command: ").append((Object)cmd).append((Object)"]").toString());
        try {
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            throw this.fatal(new StringBuilder().append((Object)"Cannot start compilation daemon.\ntried command: ").append((Object)cmd).toString());
        }
    }

    private String serverCommand(String vmArgs) {
        return new StringBuilder().append((Object)this.vmCommand()).append((Object)vmArgs).append((Object)" ").append((Object)this.serverClass()).toString();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    public Directory portsDir() {
        return this.portsDir;
    }

    public Directory tmpDir() {
        return this.tmpDir;
    }

    public void info(String msg) {
        if (this.compileClient().verbose()) {
            System.out.println(msg);
        }
    }

    public Nothing$ fatal(String msg) {
        this.error(msg);
        throw new Exception("fsc failure");
    }

    public void error(String msg) {
        System.err.println(msg);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    public String serverClass() {
        return this.serverClass;
    }

    public String vmCommand() {
        return this.vmCommand;
    }

    public String cmdName() {
        return Properties$.MODULE$.cmdName();
    }

    public String dirName() {
        return "scalac-compile-server-port";
    }

    public StandardCompileClient compileClient() {
        return CompileClient$.MODULE$;
    }

    public /* synthetic */ boolean getOrCreateSocket$default$2() {
        return true;
    }
}

