/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.EventInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.PropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Type
extends MemberInfo {
    public static final Type[] EmptyTypes = new Type[0];
    public static final char Delimiter = '.';
    public final String FullName;
    public final String Namespace;
    protected Type baseType;
    public final int Attributes;
    public final Module Module;
    protected FieldInfo[] fields;
    protected MethodInfo[] methods;
    protected ConstructorInfo[] constructors;
    protected PropertyInfo[] properties;
    protected EventInfo[] events;
    protected Type[] interfaces;
    protected Type[] nestedTypes;
    private final Type elemType;
    protected Type underlyingType;
    private int auxAttr;
    private static final Map types = new HashMap();
    protected MemberInfo[] members;
    private boolean initBaseType = true;
    private boolean initInterfaces = true;
    private boolean initNestedTypes = true;
    private boolean initFields = true;
    private boolean initMethods = true;
    private boolean initProperties = true;
    private boolean initEvents = true;
    private static Assembly MSCORLIB;
    private static Module MSCORLIB_DLL;
    private static Type __OBJECT;
    private static Type __STRING;
    private static Type __ARRAY;
    private static Type __VOID;
    private static Type __ENUM;
    private static Type __VALUE_TYPE;

    public final Type BaseType() {
        this.initBaseType();
        return this.baseType;
    }

    public final Assembly Assembly() {
        return this.Module.Assembly;
    }

    public final int MemberType() {
        return this.DeclaringType == null ? 32 : 128;
    }

    protected static Type getType(String string) {
        return (Type)types.get(string);
    }

    protected static Type addType(Type type) {
        Type type2 = types.put(type.FullName, type);
        return type;
    }

    protected Type(Module module, int n, String string, Type type, Type[] typeArray, Type type2, int n2, Type type3) {
        super(string.lastIndexOf(46) < 0 ? string : string.substring(string.lastIndexOf(46) + 1, string.length()), type2);
        this.Module = module;
        this.Attributes = n;
        this.baseType = type;
        if (this.DeclaringType == null) {
            this.FullName = string;
            int n3 = this.FullName.lastIndexOf(46);
            this.Namespace = n3 < 0 ? "" : this.FullName.substring(0, n3);
        } else {
            this.FullName = type2.FullName + "+" + string;
            this.Namespace = this.DeclaringType.Namespace;
        }
        this.interfaces = typeArray;
        this.elemType = type3;
        this.auxAttr = n2;
    }

    public final boolean IsAbstract() {
        return (this.Attributes & 0x80) != 0;
    }

    public final boolean IsPublic() {
        return (this.Attributes & 7) == 1;
    }

    public final boolean IsNotPublic() {
        return (this.Attributes & 7) == 0;
    }

    public final boolean IsNestedPublic() {
        return (this.Attributes & 7) == 2;
    }

    public final boolean IsNestedPrivate() {
        return (this.Attributes & 7) == 3;
    }

    public final boolean IsNestedFamily() {
        return (this.Attributes & 7) == 4;
    }

    public final boolean IsNestedAssembly() {
        return (this.Attributes & 7) == 5;
    }

    public final boolean IsNestedFamORAssem() {
        return (this.Attributes & 7) == 7;
    }

    public final boolean IsNestedFamANDAssem() {
        return (this.Attributes & 7) == 6;
    }

    public final boolean IsSealed() {
        return (this.Attributes & 0x100) != 0;
    }

    public final boolean IsSpecialName() {
        return (this.Attributes & 0x400) != 0;
    }

    public final boolean IsClass() {
        return (this.Attributes & 0x20) == 0;
    }

    public final boolean IsInterface() {
        return (this.Attributes & 0x20) == 32;
    }

    public final boolean IsAutoLayout() {
        return (this.Attributes & 0x18) == 0;
    }

    public final boolean IsExplictitLayout() {
        return (this.Attributes & 0x18) == 16;
    }

    public final boolean IsLayoutSequential() {
        return (this.Attributes & 0x18) == 8;
    }

    public final boolean IsImport() {
        return (this.Attributes & 0x1000) != 0;
    }

    public final boolean IsSerializable() {
        return (this.Attributes & 0x2000) != 0;
    }

    public final boolean IsAnsiClass() {
        return (this.Attributes & 0x30000) == 0;
    }

    public final boolean IsUnicodeClass() {
        return (this.Attributes & 0x30000) == 65536;
    }

    public final boolean IsAutoClass() {
        return (this.Attributes & 0x30000) == 131072;
    }

    public final boolean IsArray() {
        return (this.auxAttr & 1) != 0;
    }

    public final boolean IsByRef() {
        return (this.auxAttr & 2) != 0;
    }

    public final boolean IsPointer() {
        return (this.auxAttr & 8) != 0;
    }

    public final boolean IsPrimitive() {
        return (this.auxAttr & 0x10) != 0;
    }

    public final boolean IsValueType() {
        return this.BaseType() == Type.VALUE_TYPE() || this.IsEnum();
    }

    public final boolean IsEnum() {
        return this.BaseType() == Type.ENUM();
    }

    public final boolean HasElementType() {
        return this.IsArray() || this.IsPointer() || this.IsByRef();
    }

    protected Type(Module module, int n, String string, Type type, Type[] typeArray, Type type2, int n2) {
        this(module, n, string, type, typeArray, type2, n2, null);
    }

    public static Type mkArray(Type type, int n) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < n; ++i) {
            if (i <= 0) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        Type type2 = Type.getType(type.FullName + stringBuffer);
        if (type2 != null) {
            return type2;
        }
        type2 = new PrimitiveType(type.Module, 8449, type.FullName + stringBuffer, Type.ARRAY(), EmptyTypes, null, 1, type);
        return Type.addType(type2);
    }

    public static Type mkPtr(Type type) {
        String string = type.FullName + "*";
        Type type2 = Type.getType(string);
        if (type2 != null) {
            return type2;
        }
        type2 = new PrimitiveType(type.Module, 0, string, null, EmptyTypes, null, 8, type);
        return Type.addType(type2);
    }

    public static Type GetType(String string) {
        CustomAttributeProvider customAttributeProvider;
        Type type = Type.getType(string);
        if (type != null) {
            return type;
        }
        int n = string.lastIndexOf(91);
        int n2 = string.lastIndexOf(93);
        if (n >= 0) {
            if (n2 > n && n2 == string.length() - 1) {
                String string2 = string.substring(0, n);
                Type type2 = Type.GetType(string2);
                if (type2 == null) {
                    throw new RuntimeException("Unknown element type '" + string2 + "' for the array type: " + string);
                }
                int n3 = n2 - n;
                for (int i = n + 1; i < n2; ++i) {
                    if (string.charAt(i) == ',') continue;
                    throw new RuntimeException("Malformed type name: " + string);
                }
                return Type.mkArray(type2, n3);
            }
            throw new RuntimeException("Malformed type name: " + string);
        }
        if (string.charAt(string.length() - 1) == '*') {
            return Type.addType(Type.mkPtr(Type.GetType(string.substring(0, string.length() - 1))));
        }
        n = string.lastIndexOf(43);
        if (n > 0) {
            if (n == 0 || n == string.length() - 1) {
                throw new RuntimeException("malformedTypeName");
            }
            Type type3 = Type.GetType(string.substring(0, n));
            return type3 == null ? null : type3.GetNestedType(string.substring(n + 1));
        }
        Iterator iterator2 = Assembly.assemblies.values().iterator();
        while (type == null && iterator2.hasNext()) {
            customAttributeProvider = (Assembly)iterator2.next();
            type = ((Assembly)customAttributeProvider).GetType(string);
        }
        customAttributeProvider = Type.getType(string);
        if (type == customAttributeProvider) {
            return type;
        }
        return type == null ? null : Type.addType(type);
    }

    public Type GetElementType() {
        return this.elemType;
    }

    public Type getUnderlyingType() {
        if (!this.IsEnum()) {
            return null;
        }
        this.initFields();
        return this.underlyingType;
    }

    public FieldInfo GetField(String string) {
        this.initFields();
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].Name.equals(string) || this.fields[i].IsPrivate()) continue;
            return this.fields[i];
        }
        return null;
    }

    public FieldInfo GetField(String string, int n) {
        FieldInfo[] fieldInfoArray = this.GetFields(n);
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            if (!string.equals(fieldInfoArray[i].Name)) continue;
            return fieldInfoArray[i];
        }
        return null;
    }

    public FieldInfo[] GetFields() {
        return this.GetFields(20);
    }

    public FieldInfo[] GetFields(int n) {
        this.initFields();
        FieldInfo[] fieldInfoArray = this.getAllFields((n & 2) != 0);
        boolean bl = (n & 4) != 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 0x10) != 0;
        boolean bl4 = (n & 0x20) != 0;
        int n2 = 0;
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            boolean bl5;
            FieldInfo fieldInfo = fieldInfoArray[i];
            boolean bl6 = bl5 = bl3 && fieldInfo.IsPublic() || bl4 && !fieldInfo.IsPublic();
            if (!bl5 || fieldInfo.DeclaringType != this && (fieldInfo.DeclaringType == this || fieldInfo.IsPrivate()) || (!bl || fieldInfo.IsStatic()) && (!bl2 || !fieldInfo.IsStatic() || fieldInfo.DeclaringType != this && (n & 0x40) == 0)) continue;
            fieldInfoArray[n2++] = fieldInfo;
        }
        FieldInfo[] fieldInfoArray2 = new FieldInfo[n2];
        System.arraycopy(fieldInfoArray, 0, fieldInfoArray2, 0, n2);
        return fieldInfoArray2;
    }

    protected FieldInfo[] getAllFields(boolean bl) {
        this.initFields();
        FieldInfo[] fieldInfoArray = this.BaseType() == null || bl ? FieldInfo.EMPTY_ARRAY : this.BaseType().getAllFields(bl);
        FieldInfo[] fieldInfoArray2 = new FieldInfo[fieldInfoArray.length + this.fields.length];
        System.arraycopy(fieldInfoArray, 0, fieldInfoArray2, 0, fieldInfoArray.length);
        System.arraycopy(this.fields, 0, fieldInfoArray2, fieldInfoArray.length, this.fields.length);
        return fieldInfoArray2;
    }

    public ConstructorInfo GetConstructor(Type[] typeArray) {
        this.initMethods();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!Type.equalParameters(this.constructors[i].GetParameters(), typeArray)) continue;
            return this.constructors[i];
        }
        return null;
    }

    public ConstructorInfo[] GetConstructors() {
        return this.GetConstructors(20);
    }

    public ConstructorInfo[] GetConstructors(int n) {
        this.initMethods();
        boolean bl = (n & 4) != 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 0x10) != 0;
        boolean bl4 = (n & 0x20) != 0;
        ConstructorInfo[] constructorInfoArray = new ConstructorInfo[this.constructors.length];
        int n2 = 0;
        for (int i = 0; i < this.constructors.length; ++i) {
            boolean bl5;
            ConstructorInfo constructorInfo = this.constructors[i];
            boolean bl6 = bl5 = bl3 && constructorInfo.IsPublic() || bl4 && !constructorInfo.IsPublic();
            if (!bl5 || (!bl || constructorInfo.IsStatic()) && (!bl2 || !constructorInfo.IsStatic())) continue;
            constructorInfoArray[n2++] = constructorInfo;
        }
        ConstructorInfo[] constructorInfoArray2 = new ConstructorInfo[n2];
        System.arraycopy(constructorInfoArray, 0, constructorInfoArray2, 0, n2);
        return constructorInfoArray2;
    }

    public MethodInfo GetMethod(String string, Type[] typeArray) {
        return this.GetMethod(string, typeArray, null);
    }

    public MethodInfo GetMethod(String string, Type[] typeArray, Type type) {
        this.initMethods();
        MethodInfo methodInfo = Type.findMethod(this.methods, string, typeArray, type);
        if (methodInfo != null) {
            return methodInfo;
        }
        if (this.BaseType() != null && (methodInfo = this.BaseType().GetMethod(string, typeArray, type)) != null) {
            return methodInfo;
        }
        return null;
    }

    protected static MethodInfo findMethod(MethodInfo[] methodInfoArray, String string, Type[] typeArray, Type type) {
        for (int i = 0; i < methodInfoArray.length; ++i) {
            if (!string.equals(methodInfoArray[i].Name) || !Type.equalParameters(methodInfoArray[i].GetParameters(), typeArray) || type != null && methodInfoArray[i].ReturnType != type) continue;
            return methodInfoArray[i];
        }
        return null;
    }

    protected static boolean equalParameters(ParameterInfo[] parameterInfoArray, Type[] typeArray) {
        if (parameterInfoArray.length != typeArray.length) {
            return false;
        }
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            if (parameterInfoArray[i].ParameterType == typeArray[i]) continue;
            return false;
        }
        return true;
    }

    public MethodInfo GetMethod(String string, Type[] typeArray, int n) {
        MethodInfo[] methodInfoArray = this.GetMethods(n);
        MethodInfo methodInfo = Type.findMethod(methodInfoArray, string, typeArray, null);
        if (methodInfo == null) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('(');
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(typeArray[n2]);
            }
            stringBuffer.append(')');
            System.out.println("Cannot find method " + stringBuffer + ":");
            System.out.println("Methods of class " + this);
            for (n2 = 0; n2 < methodInfoArray.length; ++n2) {
                System.out.println("\t" + methodInfoArray[n2]);
            }
        }
        return methodInfo;
    }

    public MethodInfo[] GetMethods() {
        return this.GetMethods(20);
    }

    public MethodInfo[] GetMethods(int n) {
        this.initMethods();
        MethodInfo[] methodInfoArray = this.getAllMethods((n & 2) != 0);
        boolean bl = (n & 4) != 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 0x10) != 0;
        boolean bl4 = (n & 0x20) != 0;
        int n2 = 0;
        for (int i = 0; i < methodInfoArray.length; ++i) {
            boolean bl5;
            MethodInfo methodInfo = methodInfoArray[i];
            boolean bl6 = bl5 = bl3 && methodInfo.IsPublic() || bl4 && !methodInfo.IsPublic();
            if (!bl5 || methodInfo.DeclaringType != this && (methodInfo.DeclaringType == this || methodInfo.IsPrivate()) || (!bl || methodInfo.IsStatic()) && (!bl2 || !methodInfo.IsStatic() || methodInfo.DeclaringType != this && (n & 0x40) == 0)) continue;
            methodInfoArray[n2++] = methodInfo;
        }
        MethodInfo[] methodInfoArray2 = new MethodInfo[n2];
        System.arraycopy(methodInfoArray, 0, methodInfoArray2, 0, n2);
        return methodInfoArray2;
    }

    protected MethodInfo[] getAllMethods(boolean bl) {
        this.initMethods();
        MethodInfo[] methodInfoArray = this.BaseType() == null || bl ? MethodInfo.EMPTY_ARRAY : this.BaseType().getAllMethods(bl);
        MethodInfo[] methodInfoArray2 = new MethodInfo[methodInfoArray.length + this.methods.length];
        System.arraycopy(methodInfoArray, 0, methodInfoArray2, 0, methodInfoArray.length);
        System.arraycopy(this.methods, 0, methodInfoArray2, methodInfoArray.length, this.methods.length);
        return methodInfoArray2;
    }

    public PropertyInfo[] GetProperties() {
        this.initProperties();
        return (PropertyInfo[])this.properties.clone();
    }

    public PropertyInfo[] GetProperties(int n) {
        this.initProperties();
        return (PropertyInfo[])this.properties.clone();
    }

    public PropertyInfo GetProperty(String string) {
        this.initProperties();
        for (int i = 0; i < this.properties.length; ++i) {
            if (!string.equals(this.properties[i].Name)) continue;
            return this.properties[i];
        }
        return null;
    }

    public PropertyInfo GetProperty(String string, int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public EventInfo[] GetEvents() {
        this.initEvents();
        return (EventInfo[])this.events.clone();
    }

    public Type GetNestedType(String string) {
        this.initNestedTypes();
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            if (!this.nestedTypes[i].Name.equals(string)) continue;
            return this.nestedTypes[i];
        }
        return null;
    }

    public Type[] GetNestedTypes() {
        this.initNestedTypes();
        return (Type[])this.nestedTypes.clone();
    }

    public Type GetInterface(String string) {
        return this.GetInterface(string, false);
    }

    public Type GetInterface(String string, boolean bl) {
        this.initInterfaces();
        for (int i = 0; i < this.interfaces.length; ++i) {
            Type type = this.interfaces[i];
            if (bl) {
                if (string.equalsIgnoreCase(type.Name)) {
                    return type;
                }
                if (!string.equalsIgnoreCase(type.FullName)) continue;
                return type;
            }
            if (string.equals(type.Name)) {
                return type;
            }
            if (!string.equals(type.FullName)) continue;
            return type;
        }
        return this.BaseType() == null ? null : this.BaseType().GetInterface(string, bl);
    }

    public Type[] GetInterfaces() {
        this.initInterfaces();
        if (this.BaseType() == null) {
            return this.interfaces;
        }
        Type[] typeArray = this.interfaces;
        int n = 0;
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.BaseType().GetInterface(this.interfaces[i].FullName) != null) continue;
            typeArray[n++] = typeArray[i];
        }
        Type[] typeArray2 = this.BaseType().GetInterfaces();
        Type[] typeArray3 = new Type[typeArray2.length + n];
        System.arraycopy(typeArray2, 0, typeArray3, 0, typeArray2.length);
        System.arraycopy(typeArray, 0, typeArray3, typeArray2.length, n);
        return typeArray3;
    }

    public boolean isSubtypeOf(Type type) {
        boolean bl;
        if (this == type || this.BaseType() == type || type == Type.OBJECT()) {
            return true;
        }
        this.initInterfaces();
        for (bl = false; bl < this.interfaces.length; bl += 1) {
            if (!this.interfaces[bl].isSubtypeOf(type)) continue;
            return true;
        }
        bl = this.BaseType() == null ? false : (boolean)this.BaseType().isSubtypeOf(type);
        return bl;
    }

    private static String formatType(Type type) {
        if (type == null) {
            return "<null>";
        }
        String string = type.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "[" + type.Assembly().GetName() + "]" + type + "(" + string + "#" + Integer.toHexString(type.hashCode()) + ")";
    }

    private static String dumpType(Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Type.formatType(type) + " : ");
        stringBuffer.append(Type.formatType(type.BaseType()));
        Type[] typeArray = type.GetInterfaces();
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(", " + Type.formatType(typeArray[i]));
        }
        return stringBuffer.toString();
    }

    public MemberInfo[] GetMember(String string) {
        this.aggregateMembers();
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!string.equals(this.members[i].Name)) continue;
            arrayList.add(this.members[i]);
        }
        return arrayList.toArray(MemberInfo.EMPTY_ARRAY);
    }

    protected void aggregateMembers() {
        if (this.members != null) {
            return;
        }
        this.initFields();
        this.initMethods();
        this.initProperties();
        this.initNestedTypes();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(Arrays.asList(this.fields));
        arrayList.addAll(Arrays.asList(this.constructors));
        arrayList.addAll(Arrays.asList(this.methods));
        arrayList.addAll(Arrays.asList(this.properties));
        arrayList.addAll(Arrays.asList(this.nestedTypes));
        this.members = arrayList.toArray(MemberInfo.EMPTY_ARRAY);
    }

    public FieldInfo[] getFields() {
        this.initFields();
        FieldInfo[] fieldInfoArray = new FieldInfo[this.fields.length];
        System.arraycopy(this.fields, 0, fieldInfoArray, 0, fieldInfoArray.length);
        return fieldInfoArray;
    }

    public ConstructorInfo[] getConstructors() {
        this.initMethods();
        ConstructorInfo[] constructorInfoArray = new ConstructorInfo[this.constructors.length];
        System.arraycopy(this.constructors, 0, constructorInfoArray, 0, constructorInfoArray.length);
        return constructorInfoArray;
    }

    public MethodInfo[] getMethods() {
        this.initMethods();
        MethodInfo[] methodInfoArray = new MethodInfo[this.methods.length];
        System.arraycopy(this.methods, 0, methodInfoArray, 0, methodInfoArray.length);
        return methodInfoArray;
    }

    public PropertyInfo[] getProperties() {
        this.initProperties();
        PropertyInfo[] propertyInfoArray = new PropertyInfo[this.properties.length];
        System.arraycopy(this.properties, 0, propertyInfoArray, 0, propertyInfoArray.length);
        return propertyInfoArray;
    }

    public Type[] getInterfaces() {
        this.initInterfaces();
        Type[] typeArray = new Type[this.interfaces.length];
        System.arraycopy(this.interfaces, 0, typeArray, 0, typeArray.length);
        return typeArray;
    }

    public Type[] getNestedTypes() {
        this.initNestedTypes();
        Type[] typeArray = new Type[this.nestedTypes.length];
        System.arraycopy(this.nestedTypes, 0, typeArray, 0, typeArray.length);
        return typeArray;
    }

    public String toString() {
        return this.FullName;
    }

    protected final void initBaseType() {
        if (this.initBaseType) {
            this.loadBaseType();
            this.initBaseType = false;
        }
    }

    protected void loadBaseType() {
    }

    protected void initInterfaces() {
        if (this.initInterfaces) {
            this.loadInterfaces();
            this.initInterfaces = false;
        }
        assert (this.interfaces != null) : "In type " + this;
    }

    protected void loadInterfaces() {
    }

    protected void initNestedTypes() {
        if (this.initNestedTypes) {
            this.loadNestedTypes();
            this.initNestedTypes = false;
        }
        assert (this.nestedTypes != null) : "In type " + this;
    }

    protected void loadNestedTypes() {
    }

    protected void initFields() {
        if (this.initFields) {
            this.loadFields();
            this.initFields = false;
        }
        assert (this.fields != null) : "In type " + this;
    }

    protected void loadFields() {
    }

    protected void initMethods() {
        if (this.initMethods) {
            this.loadMethods();
            this.initMethods = false;
        }
        assert (this.constructors != null) : "In type " + this;
        assert (this.methods != null) : "In type " + this;
    }

    protected void loadMethods() {
    }

    protected void initProperties() {
        if (this.initProperties) {
            this.initMethods();
            this.loadProperties();
            this.initProperties = false;
        }
        assert (this.properties != null) : "In type " + this;
    }

    protected void loadProperties() {
    }

    protected void initEvents() {
        if (this.initEvents) {
            this.initMethods();
            this.loadEvents();
            this.initEvents = false;
        }
        assert (this.events != null) : "In type " + this;
    }

    protected void loadEvents() {
    }

    public static Type OBJECT() {
        return __OBJECT;
    }

    public static Type STRING() {
        return __STRING;
    }

    public static Type ARRAY() {
        return __ARRAY;
    }

    public static Type VOID() {
        return __VOID;
    }

    public static Type ENUM() {
        return __ENUM;
    }

    public static Type VALUE_TYPE() {
        return __VALUE_TYPE;
    }

    public static void initMSCORLIB(Assembly assembly) {
        if (MSCORLIB != null) {
            throw new RuntimeException("mscorlib already initialized");
        }
        MSCORLIB = assembly;
        MSCORLIB_DLL = MSCORLIB.GetModules()[0];
        __OBJECT = assembly.GetType("System.Object");
        __STRING = assembly.GetType("System.String");
        __ARRAY = assembly.GetType("System.Array");
        __VOID = assembly.GetType("System.Void");
        __ENUM = assembly.GetType("System.Enum");
        __VALUE_TYPE = assembly.GetType("System.ValueType");
    }

    protected static final class AuxAttr {
        public static final int None = 0;
        public static final int Array = 1;
        public static final int ByRef = 2;
        public static final int Pointer = 8;
        public static final int Primitive = 16;

        protected AuxAttr() {
        }
    }

    static final class PrimitiveType
    extends Type {
        public PrimitiveType(Module module, int n, String string, Type type, Type[] typeArray, Type type2, int n2, Type type3) {
            super(module, n, string, type, typeArray, type2, n2, type3);
        }
    }
}

