/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import scala.Iterator;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedByteArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.VirtualFile;

public final class URLZipArchive
extends AbstractFile
implements ScalaObject {
    private DirEntry root;
    private final URL url;

    public URLZipArchive(URL url) {
        this.url = url;
        Predef$.MODULE$.assert(url != null);
    }

    private final InputStream getEntryInputStream$1(InputStream in) {
        ArrayBuffer buf = new ArrayBuffer();
        byte[] data = new byte[1024];
        int n = in.read(data);
        while (n > 0) {
            buf.$plus$plus$eq((BoxedArray)new BoxedByteArray(data), 0, n);
            n = in.read(data);
        }
        Object object = ScalaRunTime$.MODULE$.arrayValue(buf.toArray(), Byte.TYPE);
        return new ByteArrayInputStream((byte[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE) : object));
    }

    private DirEntry getDir(Map dirs, String path) {
        Option option;
        block4: {
            DirEntry dirEntry;
            block3: {
                block2: {
                    option = dirs.get((Object)path);
                    if (!(option instanceof Some)) break block2;
                    dirEntry = (DirEntry)((Some)option).x();
                    break block3;
                }
                if (None$.MODULE$ != option) break block4;
                int index = path.lastIndexOf(47, path.length() - 2);
                String name = index < 0 ? path : path.substring(index + 1);
                String home = index < 0 ? "/" : path.substring(0, index + 1);
                DirEntry parent = this.getDir(dirs, home);
                DirEntry dir = new DirEntry(this, name.substring(0, name.length() - 1), path);
                parent.entries().update((Object)name, (Object)dir);
                dirs.update((Object)path, (Object)dir);
                dirEntry = dir;
            }
            return dirEntry;
        }
        throw new MatchError((Object)option);
    }

    private void load() {
        this.root_$eq(new DirEntry(this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        ZipInputStream zis = new ZipInputStream(this.input());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String path = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path.endsWith("/"), (Object)(this.toString() + " - " + path));
            if (entry.isDirectory()) {
                DirEntry dir = this.getDir((Map)dirs, path);
                Predef$.MODULE$.assert(dir.entry() == null, (Object)(this.toString() + " - " + path));
                dir.entry_$eq(entry);
            } else {
                int index = path.lastIndexOf(47);
                String name = index < 0 ? path : path.substring(index + 1);
                String home = index < 0 ? "/" : path.substring(0, index + 1);
                DirEntry parent = this.getDir((Map)dirs, home);
                Predef$.MODULE$.assert(!parent.entries().contains((Object)path), (Object)(this.toString() + " - " + path));
                InputStream in = this.getEntryInputStream$1(zis);
                parent.entries().update((Object)name, (Object)new FileEntry(this, name, path, entry, in));
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        return;
    }

    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    public Iterator elements() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().elements();
    }

    public InputStream input() {
        return this.url.openStream();
    }

    /*
     * WARNING - void declaration
     */
    public long lastModified() {
        void var1_1;
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.url.openConnection().getLastModified();
        }
        catch (Throwable throwable) {
            exceptionResult2 = 0L;
        }
        return (long)var1_1;
    }

    public boolean isDirectory() {
        return true;
    }

    public File file() {
        return null;
    }

    public String path() {
        return this.url.getPath();
    }

    public String name() {
        return this.url.getFile();
    }

    public Nothing$ container() {
        throw new Error("unsupported");
    }

    private void root_$eq(DirEntry x$1) {
        this.root = x$1;
    }

    private DirEntry root() {
        return this.root;
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public Entry(String name, String path) {
            if (URLZipArchive.this == null) {
                throw new NullPointerException();
            }
            super(name, path);
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$Entry$$$outer() {
            return URLZipArchive.this;
        }

        public final String path() {
            return this.scala$tools$nsc$io$URLZipArchive$Entry$$$outer().toString() + "(" + super.path() + ")";
        }
    }

    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private final Map entries = new HashMap();

        public DirEntry(URLZipArchive $outer, String name, String path) {
            super(name, path);
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$DirEntry$$$outer() {
            return URLZipArchive.this;
        }

        public AbstractFile lookupName(String name, boolean directory) {
            Option option;
            block4: {
                AbstractFile abstractFile;
                block3: {
                    block2: {
                        option = this.entries().get((Object)(directory ? name + "/" : name));
                        if (!(option instanceof Some)) break block2;
                        abstractFile = (AbstractFile)((Some)option).x();
                        break block3;
                    }
                    if (None$.MODULE$ != option) break block4;
                    abstractFile = null;
                }
                return abstractFile;
            }
            throw new MatchError((Object)option);
        }

        public Iterator elements() {
            return this.entries().values();
        }

        public long lastModified() {
            return this.entry() == null ? super.lastModified() : this.entry().getTime();
        }

        public Nothing$ input() {
            throw new Error("cannot read directories");
        }

        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry x$1) {
            this.entry = x$1;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map entries() {
            return this.entries;
        }
    }

    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private final InputStream in;
        private final ZipEntry entry;

        public FileEntry(URLZipArchive $outer, String name, String path, ZipEntry entry, InputStream in) {
            this.entry = entry;
            this.in = in;
            super(name, path);
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$FileEntry$$$outer() {
            return URLZipArchive.this;
        }

        public Some size() {
            return new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.entry().getSize())));
        }

        public InputStream input() {
            return this.in();
        }

        public long lastModified() {
            return this.entry().getTime();
        }

        public InputStream in() {
            return this.in;
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }
}

