/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.concurrent.ops$;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileSocket;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.FatalError;
import scala.tools.nsc.Global;
import scala.tools.nsc.OfflineCompilerCommand;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.StandardCompileServer$;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.util.SocketServer;

public class StandardCompileServer
extends SocketServer
implements ScalaObject {
    private File redirectDir;
    private ConsoleReporter reporter;
    private Runtime runtime;
    private boolean scala$tools$nsc$StandardCompileServer$$progress = false;
    private boolean scala$tools$nsc$StandardCompileServer$$inSession = false;
    private Global compiler = null;
    private boolean shutDown = false;
    private double MaxCharge = 0.8;
    private String versionMsg = "Fast Scala compiler " + Properties$.MODULE$.versionString() + " -- " + Properties$.MODULE$.copyrightString();

    public StandardCompileServer() {
        this.runtime = Runtime.getRuntime();
        this.redirectDir = new File(this.compileSocket().tmpDir(), "output-redirects");
        this.redirectDir().mkdirs();
    }

    public final void error$0(String msg) {
        this.out().println(new Tuple2((Object)new FakePos("fsc"), (Object)(msg + "\n  fsc -help  gives more information")));
    }

    public void main(String[] args) {
        this.redirect(new $anonfun$4(this), "scala-compile-server-out.log");
        this.redirect(new $anonfun$5(this), "scala-compile-server-err.log");
        System.err.println("...starting server on socket " + BoxesUtility.boxToInteger((int)this.port()) + "...");
        System.err.flush();
        this.spawnWatchDog();
        this.compileSocket().setPort(this.port());
        this.run();
        this.compileSocket().deletePort(this.port());
        this.exit(0);
    }

    private void redirect(Function1 setter, String filename) {
        setter.apply((Object)new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.redirectDir(), filename)))));
    }

    private File redirectDir() {
        return this.redirectDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void session() {
        System.out.println("New session, total memory = " + BoxesUtility.boxToLong((long)this.runtime().totalMemory()) + ", max memory = " + BoxesUtility.boxToLong((long)this.runtime().maxMemory()) + ", free memory = " + BoxesUtility.boxToLong((long)this.runtime().freeMemory()));
        System.out.flush();
        String password = this.compileSocket().getPassword(this.port());
        String guessedPassword = this.in().readLine();
        String input = this.in().readLine();
        if (input == null) return;
        String string = password;
        String string2 = guessedPassword;
        if (string != null ? !string.equals(string2) : string2 != null) return;
        try {
            this.scala$tools$nsc$StandardCompileServer$$inSession_$eq(true);
            this.scala$tools$nsc$StandardCompileServer$$progress_$eq(true);
            List args = new BoxedObjectArray((Object[])input.split("\u0000", -1)).toList();
            if (args.contains((Object)"-shutdown")) {
                this.out().println("[Compile server exited]");
                this.shutDown_$eq(true);
                this.scala$tools$nsc$StandardCompileServer$$inSession_$eq(false);
                return;
            }
            if (args.contains((Object)"-reset")) {
                this.out().println("[Compile server was reset]");
                this.compiler_$eq(null);
                this.scala$tools$nsc$StandardCompileServer$$inSession_$eq(false);
                return;
            }
            OfflineCompilerCommand command$0 = this.newOfflineCompilerCommand(args, new Settings(new $anonfun$2(this)), new $anonfun$3(this), false);
            this.reporter_$eq(new $anon$1(this, command$0));
            if (command$0.settings().version().value()) {
                this.reporter().info(null, this.versionMsg(), true);
            } else if (command$0.settings().help().value() || command$0.settings().Xhelp().value()) {
                if (command$0.settings().help().value()) {
                    this.reporter().info(null, command$0.usageMsg(), true);
                }
                if (command$0.settings().Xhelp().value()) {
                    this.reporter().info(null, command$0.xusageMsg(), true);
                }
            } else if (command$0.files().isEmpty()) {
                this.reporter().info(null, command$0.usageMsg(), true);
            } else {
                try {
                    if (this.compiler() != null && this.settingsAreCompatible(command$0.settings(), this.compiler().settings())) {
                        this.compiler().settings_$eq(command$0.settings());
                        this.compiler().reporter_$eq(this.reporter());
                    } else {
                        if (args.contains((Object)"-verbose")) {
                            this.out().println("[Starting new compile server instance]");
                        }
                        this.compiler_$eq(this.newGlobal(command$0.settings(), this.reporter()));
                    }
                    Global c = this.compiler();
                    Global.Run run = new Global.Run(c);
                    run.compile(command$0.files());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FatalError) {
                        FatalError fatalError = (FatalError)throwable2;
                        if (command$0.settings().debug().value()) {
                            fatalError.printStackTrace(this.out());
                        }
                        this.reporter().error(null, "fatal error: " + fatalError.msg());
                        this.compiler_$eq(null);
                    }
                    if (throwable2 == null) {
                        throw new MatchError((Object)throwable2);
                    }
                    Throwable ex = throwable2;
                    ex.printStackTrace(this.out());
                    this.reporter().error(null, "fatal error (server aborted): " + ex.getMessage());
                    this.shutDown_$eq(true);
                }
                this.reporter().printSummary();
                this.runtime().gc();
                if (!((double)(this.runtime().totalMemory() - this.runtime().freeMemory()) / (double)this.runtime().maxMemory() <= this.MaxCharge())) {
                    this.compiler_$eq(null);
                }
            }
            this.scala$tools$nsc$StandardCompileServer$$inSession_$eq(false);
            return;
        }
        catch (Throwable throwable) {
            this.scala$tools$nsc$StandardCompileServer$$inSession_$eq(false);
            throw throwable;
        }
    }

    public OfflineCompilerCommand newOfflineCompilerCommand(List arguments, Settings settings, Function1 error, boolean interactive) {
        return new OfflineCompilerCommand(arguments, settings, error, interactive);
    }

    public Global newGlobal(Settings settings$0, Reporter reporter$0) {
        return new $anon$0(this, settings$0, reporter$0);
    }

    public void reporter_$eq(ConsoleReporter x$1) {
        this.reporter = x$1;
    }

    public ConsoleReporter reporter() {
        return this.reporter;
    }

    private Runtime runtime() {
        return this.runtime;
    }

    private void spawnWatchDog() {
        ops$.MODULE$.spawn((Function0)new $anonfun$0(this));
    }

    private Nothing$ exit(int code) {
        System.err.close();
        System.out.close();
        return Predef$.MODULE$.exit(code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean settingsAreCompatible(Settings s1, Settings s2) {
        String string = s1.encoding().value();
        String string2 = s2.encoding().value();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = s1.classpath().value();
        string2 = s2.classpath().value();
        if (string3 == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string3.equals(string2)) return false;
        String string4 = s1.sourcepath().value();
        string2 = s2.sourcepath().value();
        if (string4 == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string4.equals(string2)) return false;
        String string5 = s1.outdir().value();
        string2 = s2.outdir().value();
        if (string5 == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string5.equals(string2)) return false;
        String string6 = s1.bootclasspath().value();
        string2 = s2.bootclasspath().value();
        if (string6 == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string6.equals(string2)) return false;
        String string7 = s1.extdirs().value();
        string2 = s2.extdirs().value();
        if (string7 == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string7.equals(string2)) return false;
            return true;
        }
    }

    public final void scala$tools$nsc$StandardCompileServer$$progress_$eq(boolean x$1) {
        this.scala$tools$nsc$StandardCompileServer$$progress = x$1;
    }

    public final boolean scala$tools$nsc$StandardCompileServer$$progress() {
        return this.scala$tools$nsc$StandardCompileServer$$progress;
    }

    private void scala$tools$nsc$StandardCompileServer$$inSession_$eq(boolean x$1) {
        this.scala$tools$nsc$StandardCompileServer$$inSession = x$1;
    }

    public final boolean scala$tools$nsc$StandardCompileServer$$inSession() {
        return this.scala$tools$nsc$StandardCompileServer$$inSession;
    }

    private void compiler_$eq(Global x$1) {
        this.compiler = x$1;
    }

    private Global compiler() {
        return this.compiler;
    }

    public void shutDown_$eq(boolean x$1) {
        this.shutDown = x$1;
    }

    public boolean shutDown() {
        return this.shutDown;
    }

    public double MaxCharge() {
        return this.MaxCharge;
    }

    public String versionMsg() {
        return this.versionMsg;
    }

    public CompileSocket compileSocket() {
        return CompileSocket$.MODULE$;
    }
}

