/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import scala.ScalaObject;
import scala.actors.remote.Service;

public abstract class Serializer
implements ScalaObject {
    private Service service;

    public Serializer(Service service) {
        this.service = service;
    }

    public void writeObject(DataOutputStream dataOutputStream, Object object) throws IOException {
        byte[] byArray = this.serialize(object);
        this.writeBytes(dataOutputStream, byArray);
    }

    public void writeBytes(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.flush();
    }

    public Object readObject(DataInputStream dataInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray = this.readBytes(dataInputStream);
        return this.deserialize(byArray);
    }

    public byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        try {
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray, 0, n);
            return byArray;
        }
        catch (NullPointerException nullPointerException) {
            throw new EOFException("Connection closed.");
        }
    }

    public abstract Object deserialize(byte[] var1);

    public abstract byte[] serialize(Object var1);

    public Service service() {
        return this.service;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

