/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.QuitException;
import scala.actors.Reaction;
import scala.actors.TaskRejectedHandler;
import scala.actors.TimerThread$;
import scala.actors.WorkerThread;
import scala.compat.Platform$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JDK5Scheduler
extends Thread
implements IScheduler,
ScalaObject {
    private Reaction QUIT_TASK;
    private Function0 lockupHandler;
    private int CHECK_FREQ;
    private int TICK_FREQ;
    private int pendingReactions;
    private int submittedTasks;
    private long lastActivity;
    private boolean terminating;
    private int coreSize;
    private ThreadPoolExecutor executor;
    private int maxSize;
    private int initCoreSize;

    public JDK5Scheduler(int n, int n2) {
        this.maxSize = n2;
        IScheduler$class.$init$(this);
        this.executor = new ThreadPoolExecutor(n, n, 5000L, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(), new TaskRejectedHandler(this));
        this.coreSize = n;
        this.terminating = false;
        this.lastActivity = Platform$.MODULE$.currentTime();
        this.submittedTasks = 0;
        this.pendingReactions = 0;
        this.TICK_FREQ = 5;
        this.CHECK_FREQ = 50;
        this.lockupHandler = null;
    }

    private final void liftedTry0$0() {
        block2: {
            try {
                this.wait(Predef$.MODULE$.int2long(this.CHECK_FREQ()));
            }
            catch (InterruptedException interruptedException) {
                if (this.terminating()) break block2;
            }
            return;
        }
        throw new QuitException();
    }

    public Runnable getTask(WorkerThread workerThread) {
        this.getTask(workerThread);
        return null;
    }

    public void shutdown() {
        JDK5Scheduler jDK5Scheduler = this;
        synchronized (jDK5Scheduler) {
            this.terminating_$eq(true);
            this.executor().shutdown();
            TimerThread$.MODULE$.t().interrupt();
            return;
        }
    }

    public void tick(Actor actor) {
        this.lastActivity_$eq(Platform$.MODULE$.currentTime());
    }

    public Null$ getTask(WorkerThread workerThread) {
        return null;
    }

    public void execute(Reaction reaction) {
        JDK5Scheduler jDK5Scheduler = this;
        synchronized (jDK5Scheduler) {
            this.submittedTasks_$eq(this.submittedTasks() + 1);
            this.executor().execute(reaction);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.terminating()) {
            JDK5Scheduler jDK5Scheduler = this;
            synchronized (jDK5Scheduler) {
                BoxedUnit boxedUnit;
                this.liftedTry0$0();
                if (this.executor().getQueue().size() <= 0 || Platform$.MODULE$.currentTime() - this.lastActivity() < (long)this.TICK_FREQ() || this.coreSize() >= this.maxSize) {
                    if (this.pendingReactions() == 0 && this.executor().getActiveCount() == 0) {
                        this.executor().shutdown();
                        TimerThread$.MODULE$.t().interrupt();
                        throw new QuitException();
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.coreSize_$eq(this.coreSize() + 1);
                    this.executor().setCorePoolSize(this.coreSize());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return;
        {
            catch (QuitException quitException) {}
            return;
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    private void lockupHandler_$eq(Function0 function0) {
        this.lockupHandler = function0;
    }

    private Function0 lockupHandler() {
        return this.lockupHandler;
    }

    public void onLockup(int n, Function0 function0) {
        this.lockupHandler_$eq(function0);
    }

    public void onLockup(Function0 function0) {
        this.lockupHandler_$eq(function0);
    }

    private void CHECK_FREQ_$eq(int n) {
        this.CHECK_FREQ = n;
    }

    private int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private void TICK_FREQ_$eq(int n) {
        this.TICK_FREQ = n;
    }

    private int TICK_FREQ() {
        return this.TICK_FREQ;
    }

    public void terminated(Actor actor) {
    }

    public void start(Reaction reaction) {
        JDK5Scheduler jDK5Scheduler = this;
        synchronized (jDK5Scheduler) {
            this.pendingReactions_$eq(this.pendingReactions() + 1);
            this.submittedTasks_$eq(this.submittedTasks() + 1);
            this.execute(reaction);
            return;
        }
    }

    public void printActorDump() {
    }

    public void unPendReaction() {
        JDK5Scheduler jDK5Scheduler = this;
        synchronized (jDK5Scheduler) {
            this.pendingReactions_$eq(this.pendingReactions() - 1);
            return;
        }
    }

    public void pendReaction() {
        JDK5Scheduler jDK5Scheduler = this;
        synchronized (jDK5Scheduler) {
            this.pendingReactions_$eq(this.pendingReactions() + 1);
            return;
        }
    }

    private void pendingReactions_$eq(int n) {
        this.pendingReactions = n;
    }

    private int pendingReactions() {
        return this.pendingReactions;
    }

    private void submittedTasks_$eq(int n) {
        this.submittedTasks = n;
    }

    private int submittedTasks() {
        return this.submittedTasks;
    }

    private void lastActivity_$eq(long l) {
        this.lastActivity = l;
    }

    private long lastActivity() {
        return this.lastActivity;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void coreSize_$eq(int n) {
        this.coreSize = n;
    }

    private int coreSize() {
        return this.coreSize;
    }

    private ThreadPoolExecutor executor() {
        return this.executor;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public final void QUIT_TASK_$eq(Reaction reaction) {
        this.QUIT_TASK = reaction;
    }

    public final Reaction QUIT_TASK() {
        return this.QUIT_TASK;
    }
}

