/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Iterator;
import scala.List$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.actors.ActorProxy;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.QuitException;
import scala.actors.Reaction;
import scala.actors.TickedScheduler$;
import scala.actors.TimerThread$;
import scala.actors.WorkerThread;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Stack;
import scala.compat.Platform$;
import scala.runtime.BoxedLong;
import scala.runtime.BoxedNumber;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TickedScheduler
extends Thread
implements IScheduler,
ScalaObject {
    private Reaction QUIT_TASK;
    private Function0 lockupHandler;
    private boolean stateChanged;
    private int lockupCnt;
    private int LOCKUP_CHECK_FREQ;
    private int CHECK_FREQ;
    private int TICK_FREQ;
    private HashSet alive;
    private Stack pendingReactions;
    private boolean terminating;
    private HashMap scala$actors$TickedScheduler$$occupied;
    private HashMap ticks;
    private Queue idle;
    private Buffer scala$actors$TickedScheduler$$workers;
    private Queue tasks;

    public TickedScheduler() {
        IScheduler$class.$init$(this);
        this.tasks = new Queue();
        this.scala$actors$TickedScheduler$$workers = new ArrayBuffer();
        this.idle = new Queue();
        this.ticks = new HashMap();
        this.scala$actors$TickedScheduler$$occupied = new HashMap();
        this.terminating = false;
        this.pendingReactions = new Stack();
        this.alive = new HashSet();
        this.TICK_FREQ = 5;
        this.CHECK_FREQ = 50;
        this.LOCKUP_CHECK_FREQ = 10;
        this.lockupCnt = 0;
        this.stateChanged = false;
        List$.MODULE$.range(0, 2).foreach((Function1)new $anonfun$1(this));
        this.lockupHandler = null;
    }

    private final void liftedTry0$0() {
        block6: {
            try {
                this.wait(Predef$.MODULE$.int2long(this.CHECK_FREQ()));
                if (!this.stateChanged()) {
                    this.lockupCnt_$eq(this.lockupCnt() + 1);
                } else {
                    this.stateChanged_$eq(false);
                }
                if (this.lockupCnt() == this.LOCKUP_CHECK_FREQ()) {
                    this.lockupCnt_$eq(0);
                    Function0 function0 = this.lockupHandler();
                    if (function0 != null && !function0.equals(null)) {
                        this.lockupHandler().apply();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.terminating()) break block6;
            }
            return;
        }
        throw new QuitException();
    }

    public Runnable getTask(WorkerThread workerThread) {
        return this.getTask(workerThread);
    }

    public void shutdown() {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            this.terminating_$eq(true);
            Iterator iterator = this.idle().elements();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                WorkerThread workerThread = (WorkerThread)iterator.next();
                workerThread.running_$eq(false);
                workerThread.interrupt();
            }
        }
    }

    public void tick(Actor actor) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            this.stateChanged_$eq(true);
            Option option = this.scala$actors$TickedScheduler$$occupied().get((Object)actor);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                this.ticks().update(((Some)option).x(), (Object)BoxedLong.box((long)Platform$.MODULE$.currentTime()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Reaction getTask(WorkerThread workerThread) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            Reaction reaction;
            if (this.terminating()) {
                this.QUIT_TASK();
            }
            this.stateChanged_$eq(true);
            if (this.tasks().length() <= 0) {
                this.idle().$plus$eq((Object)workerThread);
                reaction = null;
            } else {
                Reaction reaction2 = (Reaction)this.tasks().dequeue();
                this.scala$actors$TickedScheduler$$occupied().update((Object)reaction2.actor(), (Object)workerThread);
                reaction = reaction2;
            }
            return reaction;
        }
    }

    public void execute(Reaction reaction) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            if (!this.terminating()) {
                if (this.idle().length() <= 0) {
                    this.tasks().$plus$eq((Object)reaction);
                } else {
                    WorkerThread workerThread = (WorkerThread)this.idle().dequeue();
                    this.scala$actors$TickedScheduler$$occupied().update((Object)reaction.actor(), (Object)workerThread);
                    workerThread.execute(reaction);
                }
                this.stateChanged_$eq(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.terminating()) {
            TickedScheduler tickedScheduler = this;
            synchronized (tickedScheduler) {
                block14: {
                    BoxedUnit boxedUnit;
                    this.liftedTry0$0();
                    if (this.tasks().length() <= 0) {
                        if (!this.pendingReactions().isEmpty() || this.scala$actors$TickedScheduler$$workers().length() != this.idle().length()) {
                            boxedUnit = BoxedUnit.UNIT;
                            break block14;
                        } else {
                            Debug$.MODULE$.info("all threads idle, terminating");
                            Iterator iterator = this.idle().elements();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    TimerThread$.MODULE$.t().interrupt();
                                    throw new QuitException();
                                }
                                WorkerThread workerThread = (WorkerThread)iterator.next();
                                workerThread.running_$eq(false);
                                workerThread.interrupt();
                            }
                        }
                    }
                    Iterator iterator2 = this.scala$actors$TickedScheduler$$workers().elements();
                    boolean bl = false;
                    while (iterator2.hasNext() && !bl) {
                        WorkerThread workerThread = (WorkerThread)iterator2.next();
                        bl = this.isActive(workerThread);
                    }
                    if (!bl) {
                        WorkerThread workerThread = new WorkerThread(this);
                        this.scala$actors$TickedScheduler$$workers().$plus$eq((Object)workerThread);
                        Reaction reaction = (Reaction)this.tasks().dequeue();
                        this.scala$actors$TickedScheduler$$occupied().update((Object)reaction.actor(), (Object)workerThread);
                        workerThread.execute(reaction);
                        workerThread.start();
                        this.stateChanged_$eq(true);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return;
        {
            catch (QuitException quitException) {}
            return;
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    public boolean isActive(WorkerThread workerThread) {
        boolean bl;
        Option option = this.ticks().get((Object)workerThread);
        if (option != None$.MODULE$) {
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            long l = Platform$.MODULE$.currentTime();
            Object object = ((Some)option).x();
            bl = l - (object == null ? 0L : ((BoxedNumber)object).longValue()) < (long)this.TICK_FREQ();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isActive(Actor actor) {
        boolean bl;
        Option option = this.scala$actors$TickedScheduler$$occupied().get((Object)actor);
        if (option != None$.MODULE$) {
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            bl = this.isActive((WorkerThread)((Some)option).x());
        } else {
            bl = false;
        }
        return bl;
    }

    private void lockupHandler_$eq(Function0 function0) {
        this.lockupHandler = function0;
    }

    private Function0 lockupHandler() {
        return this.lockupHandler;
    }

    public void onLockup(int n, Function0 function0) {
        this.LOCKUP_CHECK_FREQ_$eq(n / this.CHECK_FREQ());
        this.lockupHandler_$eq(function0);
    }

    public void onLockup(Function0 function0) {
        this.lockupHandler_$eq(function0);
    }

    private void stateChanged_$eq(boolean bl) {
        this.stateChanged = bl;
    }

    private boolean stateChanged() {
        return this.stateChanged;
    }

    private void lockupCnt_$eq(int n) {
        this.lockupCnt = n;
    }

    private int lockupCnt() {
        return this.lockupCnt;
    }

    private void LOCKUP_CHECK_FREQ_$eq(int n) {
        this.LOCKUP_CHECK_FREQ = n;
    }

    private int LOCKUP_CHECK_FREQ() {
        return this.LOCKUP_CHECK_FREQ;
    }

    private void CHECK_FREQ_$eq(int n) {
        this.CHECK_FREQ = n;
    }

    private int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private void TICK_FREQ_$eq(int n) {
        this.TICK_FREQ = n;
    }

    private int TICK_FREQ() {
        return this.TICK_FREQ;
    }

    public void terminated(Actor actor) {
        this.alive().$minus$eq((Object)actor);
    }

    public void start(Reaction reaction) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            Debug$.MODULE$.info("Starting " + reaction.actor());
            this.alive().$plus$eq((Object)reaction.actor());
            Actor actor = Actor$.MODULE$.self();
            if (!(actor instanceof ActorProxy)) {
                reaction.actor().name_$eq(actor.nextChildName());
            } else {
                String string = Predef$.MODULE$.currentThread().toString();
                if (string.indexOf("main") != -1) {
                    reaction.actor().name_$eq(actor.nextChildName());
                } else {
                    Console$.MODULE$.println((Object)"Warning: Some debugging features not available if actors are created by non-main Java threads.");
                }
            }
            this.execute(reaction);
            return;
        }
    }

    public void printActorDump() {
        IntRef intRef = new IntRef(0);
        this.alive().elements().foreach((Function1)new $anonfun$0(this, intRef));
    }

    private HashSet alive() {
        return this.alive;
    }

    public void unPendReaction() {
        if (!this.pendingReactions().isEmpty()) {
            this.pendingReactions().pop();
        }
    }

    public void pendReaction() {
        this.pendingReactions().push((Seq)new BoxedObjectArray((Object[])new BoxedUnit[]{BoxedUnit.UNIT}));
    }

    private void pendingReactions_$eq(Stack stack) {
        this.pendingReactions = stack;
    }

    private Stack pendingReactions() {
        return this.pendingReactions;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    public HashMap scala$actors$TickedScheduler$$occupied() {
        return this.scala$actors$TickedScheduler$$occupied;
    }

    private HashMap ticks() {
        return this.ticks;
    }

    private Queue idle() {
        return this.idle;
    }

    public Buffer scala$actors$TickedScheduler$$workers() {
        return this.scala$actors$TickedScheduler$$workers;
    }

    private Queue tasks() {
        return this.tasks;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public final void QUIT_TASK_$eq(Reaction reaction) {
        this.QUIT_TASK = reaction;
    }

    public final Reaction QUIT_TASK() {
        return this.QUIT_TASK;
    }
}

