/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.actors.Debug$;
import scala.actors.Reaction$;
import scala.actors.Scheduler$;
import scala.actors.SuspendActorException;
import scala.runtime.BoxedBoolean;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;

public class Reaction
implements Runnable,
ScalaObject {
    private boolean runnable;
    private Object msg;
    private PartialFunction f;
    private Actor a;

    public Reaction(Actor actor, PartialFunction partialFunction, Object object) {
        this.a = actor;
        this.f = partialFunction;
        this.msg = object;
        this.runnable = false;
    }

    public void setRunnable(boolean bl) {
        Reaction reaction = this;
        synchronized (reaction) {
            this.runnable_$eq(bl);
            return;
        }
    }

    public boolean isRunnable() {
        Reaction reaction = this;
        synchronized (reaction) {
            BoxedBoolean boxedBoolean = BoxedBoolean.box((boolean)this.runnable());
            return boxedBoolean == null ? false : boxedBoolean.value;
        }
    }

    private void runnable_$eq(boolean bl) {
        this.runnable = bl;
    }

    private boolean runnable() {
        return this.runnable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        Thread thread = Predef$.MODULE$.currentThread();
        Actor actor = (Actor)Actor$.MODULE$.selfs().get(thread);
        Actor$.MODULE$.selfs().put(thread, this.a);
        Scheduler$.MODULE$.unPendReaction();
        this.a.isDetached_$eq(false);
        try {
            Object object;
            PartialFunction partialFunction = this.f;
            if (partialFunction != null && !partialFunction.equals(null)) {
                object = this.f.apply(this.msg);
            } else {
                this.a.act();
                object = BoxedUnit.UNIT;
            }
            if (Predef$.MODULE$.currentThread().isInterrupted()) throw new InterruptedException();
            this.a.kill().apply();
            if (Predef$.MODULE$.currentThread().isInterrupted()) throw new InterruptedException();
            this.a.exit("normal");
            if (Predef$.MODULE$.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Actor$.MODULE$.selfs().put(thread, actor);
            return;
        }
        catch (Throwable throwable) {
            Actor$.MODULE$.selfs().put(thread, actor);
            throw throwable;
        }
        catch (Throwable throwable) {
            this.log(throwable);
            this.a.exitLinked();
            Actor$.MODULE$.selfs().put(thread, actor);
            return;
        }
        catch (SuspendActorException suspendActorException) {
            Actor$.MODULE$.selfs().put(thread, actor);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.log(interruptedException);
            this.a.exitLinked();
            Actor$.MODULE$.selfs().put(thread, actor);
        }
    }

    public void log(Throwable throwable) {
        Debug$.MODULE$.info("logging " + throwable);
        Logger logger = Logger.getLogger("Scheduler");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Exception caught by task:\n");
        stringBuffer.append(throwable.toString() + "\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        new BoxedObjectArray((Object[])stackTraceElementArray).foreach((Function1)new $anonfun$0(this, stringBuffer));
        logger.log(Level.FINE, stringBuffer.toString());
    }

    public Actor actor() {
        return this.a;
    }

    public Reaction(Actor actor) {
        this(actor, null, null);
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

