/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.account;

import com.binance.api.client.constant.BinanceApiConstants;
import com.binance.api.client.domain.OrderSide;
import com.binance.api.client.domain.OrderType;
import com.binance.api.client.domain.TimeInForce;
import com.binance.api.client.domain.account.NewOrderResponseType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NewOrder {
    private String symbol;
    private OrderSide side;
    private OrderType type;
    private TimeInForce timeInForce;
    private String quantity;
    private String quoteOrderQty;
    private String price;
    private String newClientOrderId;
    private String stopPrice;
    private String stopLimitPrice;
    private String icebergQty;
    private NewOrderResponseType newOrderRespType;
    private Long recvWindow;
    private long timestamp;

    public NewOrder(String symbol, OrderSide side, OrderType type, TimeInForce timeInForce, String quantity) {
        this.symbol = symbol;
        this.side = side;
        this.type = type;
        this.timeInForce = timeInForce;
        this.quantity = quantity;
        this.newOrderRespType = NewOrderResponseType.RESULT;
        this.timestamp = System.currentTimeMillis();
        this.recvWindow = 60000L;
    }

    public NewOrder(String symbol, OrderSide side, OrderType type, TimeInForce timeInForce, String quantity, String price) {
        this(symbol, side, type, timeInForce, quantity);
        this.price = price;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public NewOrder symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public NewOrder side(OrderSide side) {
        this.side = side;
        return this;
    }

    public OrderType getType() {
        return this.type;
    }

    public NewOrder type(OrderType type) {
        this.type = type;
        return this;
    }

    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public NewOrder timeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
        return this;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public NewOrder quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    public String getQuoteOrderQty() {
        return this.quoteOrderQty;
    }

    public NewOrder quoteOrderQty(String quoteOrderQty) {
        this.quoteOrderQty = quoteOrderQty;
        return this;
    }

    public String getPrice() {
        return this.price;
    }

    public NewOrder price(String price) {
        this.price = price;
        return this;
    }

    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public NewOrder newClientOrderId(String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
        return this;
    }

    public String getStopPrice() {
        return this.stopPrice;
    }

    public NewOrder stopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
        return this;
    }

    public String getStopLimitPrice() {
        return this.stopLimitPrice;
    }

    public NewOrder stopLimitPrice(String stopLimitPrice) {
        this.stopLimitPrice = stopLimitPrice;
        return this;
    }

    public String getIcebergQty() {
        return this.icebergQty;
    }

    public NewOrder icebergQty(String icebergQty) {
        this.icebergQty = icebergQty;
        return this;
    }

    public NewOrderResponseType getNewOrderRespType() {
        return this.newOrderRespType;
    }

    public NewOrder newOrderRespType(NewOrderResponseType newOrderRespType) {
        this.newOrderRespType = newOrderRespType;
        return this;
    }

    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public NewOrder recvWindow(Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public NewOrder timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public static NewOrder marketBuy(String symbol, String quantity) {
        return new NewOrder(symbol, OrderSide.BUY, OrderType.MARKET, null, quantity);
    }

    public static NewOrder marketSell(String symbol, String quantity) {
        return new NewOrder(symbol, OrderSide.SELL, OrderType.MARKET, null, quantity);
    }

    public static NewOrder limitBuy(String symbol, TimeInForce timeInForce, String quantity, String price) {
        return new NewOrder(symbol, OrderSide.BUY, OrderType.LIMIT, timeInForce, quantity, price);
    }

    public static NewOrder limitSell(String symbol, TimeInForce timeInForce, String quantity, String price) {
        return new NewOrder(symbol, OrderSide.SELL, OrderType.LIMIT, timeInForce, quantity, price);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, BinanceApiConstants.TO_STRING_BUILDER_STYLE).append("symbol", (Object)this.symbol).append("side", (Object)this.side).append("type", (Object)this.type).append("timeInForce", (Object)this.timeInForce).append("quantity", (Object)this.quantity).append("quoteOrderQty", (Object)this.quoteOrderQty).append("price", (Object)this.price).append("newClientOrderId", (Object)this.newClientOrderId).append("stopPrice", (Object)this.stopPrice).append("stopLimitPrice", (Object)this.stopLimitPrice).append("icebergQty", (Object)this.icebergQty).append("newOrderRespType", (Object)this.newOrderRespType).append("recvWindow", (Object)this.recvWindow).append("timestamp", this.timestamp).toString();
    }
}

