/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaCodec;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaCodec.class, minSdk=16)
public class ShadowMediaCodec {
    private static final int BUFFER_SIZE = 512;
    private static final int EVENT_CALLBACK = 1;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    @RealObject
    private MediaCodec realCodec;
    private MediaCodec.Callback callback;
    private final ByteBuffer[] inputBuffers = new ByteBuffer[]{ByteBuffer.wrap(new byte[512])};
    private final ByteBuffer[] outputBuffers = new ByteBuffer[]{ByteBuffer.wrap(new byte[512])};
    private boolean reachedEos = false;

    @Implementation(minSdk=21)
    protected void native_setCallback(MediaCodec.Callback callback) {
        this.callback = callback;
    }

    @Implementation(minSdk=21)
    protected void native_start() {
        if (this.callback == null) {
            return;
        }
        HashMap<String, ByteBuffer> format = new HashMap<String, ByteBuffer>();
        format.put("csd-0", ByteBuffer.wrap(new byte[]{19, 16}));
        format.put("csd-1", ByteBuffer.wrap(new byte[0]));
        this.postFakeNativeEvent(1, 4, 0, format);
        this.reachedEos = false;
        this.makeInputBufferAvailable(0);
    }

    @Implementation
    protected ByteBuffer[] getBuffers(boolean input) {
        return input ? this.inputBuffers : this.outputBuffers;
    }

    @Implementation(minSdk=21)
    protected ByteBuffer getBuffer(boolean input, int index) {
        ByteBuffer[] buffers = input ? this.inputBuffers : this.outputBuffers;
        return index >= 0 && index < buffers.length ? buffers[index] : null;
    }

    @Implementation(minSdk=21)
    protected void native_queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        if ((flags & 4) != 0) {
            this.reachedEos = true;
        }
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        info.set(offset, size, presentationTimeUs, flags);
        this.makeOutputBufferAvailable(index, info);
    }

    @Implementation(minSdk=21)
    protected void releaseOutputBuffer(int index, boolean render, boolean updatePTS, long timeNs) {
        if (this.reachedEos) {
            return;
        }
        this.makeInputBufferAvailable(index);
    }

    private void makeInputBufferAvailable(int index) {
        if (index < 0 || index >= this.inputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent input available.");
        }
        this.inputBuffers[index].clear();
        this.postFakeNativeEvent(1, 1, index, null);
    }

    private void makeOutputBufferAvailable(int index, MediaCodec.BufferInfo info) {
        if (index < 0 || index >= this.outputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent output buffer available.");
        }
        this.outputBuffers[index].clear();
        this.inputBuffers[index].rewind();
        this.outputBuffers[index].put(this.inputBuffers[index]);
        this.outputBuffers[index].rewind();
        this.postFakeNativeEvent(1, 2, index, info);
    }

    private void postFakeNativeEvent(int what, int arg1, int arg2, Object obj) {
        ReflectionHelpers.callInstanceMethod(MediaCodec.class, (Object)this.realCodec, (String)"postEventFromNative", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)what), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg2), ReflectionHelpers.ClassParameter.from(Object.class, (Object)obj)});
    }

    @Implementation(minSdk=21)
    protected void invalidateByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void validateInputByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void revalidateByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void validateOutputByteBuffer(ByteBuffer[] buffers, int index, MediaCodec.BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    @Implementation(minSdk=21)
    protected void invalidateByteBuffers(ByteBuffer[] buffers) {
    }

    @Implementation(minSdk=21)
    protected void freeByteBuffer(ByteBuffer buffer) {
    }

    @Implements(className="android.media.MediaCodec$BufferMap$CodecBuffer", minSdk=21)
    protected static class ShadowCodecBuffer {
        @Implementation
        protected void __constructor__() {
        }

        @Implementation
        protected void free() {
        }
    }
}

