/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.UserHandle;
import android.util.Pair;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowBroadcastPendingResult;
import org.robolectric.shadows.ShadowBroadcastReceiver;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.WithType;

@Implements(value=Instrumentation.class, looseSignatures=true)
public class ShadowInstrumentation {
    @RealObject
    private Instrumentation realObject;
    private List<Intent> startedActivities = new ArrayList<Intent>();
    private List<ShadowActivity.IntentForResult> startedActivitiesForResults = new ArrayList<ShadowActivity.IntentForResult>();
    private Map<Intent.FilterComparison, Integer> intentRequestCodeMap = new HashMap<Intent.FilterComparison, Integer>();
    private List<Intent.FilterComparison> startedServices = new ArrayList<Intent.FilterComparison>();
    private List<Intent.FilterComparison> stoppedServices = new ArrayList<Intent.FilterComparison>();
    private List<Intent> broadcastIntents = new ArrayList<Intent>();
    private List<ServiceConnection> boundServiceConnections = Collections.synchronizedList(new ArrayList());
    private List<ServiceConnection> unboundServiceConnections = Collections.synchronizedList(new ArrayList());
    private List<ShadowApplication.Wrapper> registeredReceivers = new ArrayList<ShadowApplication.Wrapper>();
    private final Map<Pair<Integer, Integer>, Set<String>> grantedPermissionsMap = new HashMap<Pair<Integer, Integer>, Set<String>>();
    private boolean unbindServiceShouldThrowIllegalArgument = false;
    private Map<Intent.FilterComparison, ServiceConnectionDataWrapper> serviceConnectionDataForIntent = new HashMap<Intent.FilterComparison, ServiceConnectionDataWrapper>();
    private ServiceConnectionDataWrapper defaultServiceConnectionData = new ServiceConnectionDataWrapper(null, null);
    private List<String> unbindableActions = new ArrayList<String>();
    private Map<String, Intent> stickyIntents = new LinkedHashMap<String, Intent>();
    private Handler mainHandler;
    private Map<ServiceConnection, ServiceConnectionDataWrapper> serviceConnectionDataForServiceConnection = new HashMap<ServiceConnection, ServiceConnectionDataWrapper>();
    private boolean checkActivities;

    @Implementation(minSdk=28)
    protected Activity startActivitySync(Intent intent, Bundle options) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation
    protected Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        this.logStartedActivity(intent, requestCode, options);
        if (who == null) {
            return null;
        }
        return ((Instrumentation)Shadow.directlyOn((Object)this.realObject, Instrumentation.class)).execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    @Implementation(maxSdk=22)
    protected Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        this.logStartedActivity(intent, requestCode, options);
        return null;
    }

    private void logStartedActivity(Intent intent, int requestCode, Bundle options) {
        this.startedActivities.add(intent);
        this.intentRequestCodeMap.put(new Intent.FilterComparison(intent), requestCode);
        this.startedActivitiesForResults.add(new ShadowActivity.IntentForResult(intent, requestCode, options));
    }

    private void verifyActivityInManifest(Intent intent) {
        if (this.checkActivities && RuntimeEnvironment.application.getPackageManager().resolveActivity(intent, 65536) == null) {
            throw new ActivityNotFoundException(intent.getAction());
        }
    }

    @Implementation
    protected void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        for (Intent intent : intents) {
            this.execStartActivity(who, contextThread, token, target, intent, -1, options);
        }
    }

    @Implementation(minSdk=21)
    protected void execStartActivityFromAppTask(Context who, IBinder contextThread, Object appTask, Intent intent, Bundle options) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation(minSdk=23)
    protected Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        this.logStartedActivity(intent, requestCode, options);
        return ((Instrumentation)Shadow.directlyOn((Object)this.realObject, Instrumentation.class)).execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    @Implementation(minSdk=17)
    protected Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String resultWho, Intent intent, int requestCode, Bundle options, UserHandle user) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation(minSdk=23, maxSdk=28)
    protected Instrumentation.ActivityResult execStartActivityAsCaller(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, boolean ignoreTargetSecurity, int userId) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras, Context context) {
        List<ShadowApplication.Wrapper> receivers = this.getAppropriateWrappers(intent, receiverPermission);
        this.sortByPriority(receivers);
        receivers.add(new ShadowApplication.Wrapper(resultReceiver, null, context, null, scheduler));
        this.postOrderedToWrappers(receivers, intent, initialCode, initialData, initialExtras, context);
    }

    void assertNoBroadcastListenersOfActionRegistered(ContextWrapper context, String action) {
        for (ShadowApplication.Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context.getBaseContext()) continue;
            Iterator actions = registeredReceiver.intentFilter.actionsIterator();
            while (actions.hasNext()) {
                if (!((String)actions.next()).equals(action)) continue;
                IllegalStateException e = new IllegalStateException("Unexpected BroadcastReceiver on " + context + " with action " + action + " " + registeredReceiver.broadcastReceiver + " that was originally registered here:");
                e.setStackTrace(registeredReceiver.exception.getStackTrace());
                throw e;
            }
        }
    }

    private List<ShadowApplication.Wrapper> getAppropriateWrappers(Intent intent, String receiverPermission) {
        this.broadcastIntents.add(intent);
        ArrayList<ShadowApplication.Wrapper> result = new ArrayList<ShadowApplication.Wrapper>();
        ArrayList<ShadowApplication.Wrapper> copy = new ArrayList<ShadowApplication.Wrapper>();
        copy.addAll(this.registeredReceivers);
        String intentClass = intent.getComponent() != null ? intent.getComponent().getClassName() : null;
        for (ShadowApplication.Wrapper wrapper : copy) {
            int match;
            if ((!this.hasMatchingPermission(wrapper.broadcastPermission, receiverPermission) || !wrapper.intentFilter.matchAction(intent.getAction())) && (intentClass == null || !intentClass.equals(wrapper.broadcastReceiver.getClass().getName())) || (match = wrapper.intentFilter.matchData(intent.getType(), intent.getScheme(), intent.getData())) == -2 || match == -1) continue;
            result.add(wrapper);
        }
        return result;
    }

    private void postIntent(Intent intent, ShadowApplication.Wrapper wrapper, final AtomicBoolean abort, final Context context, final int resultCode) {
        Handler scheduler = wrapper.scheduler != null ? wrapper.scheduler : this.getMainHandler(context);
        final BroadcastReceiver receiver = wrapper.broadcastReceiver;
        final ShadowBroadcastReceiver shReceiver = (ShadowBroadcastReceiver)Shadow.extract((Object)receiver);
        final Intent broadcastIntent = intent;
        scheduler.post(new Runnable(){

            @Override
            public void run() {
                receiver.setPendingResult(ShadowBroadcastPendingResult.create(resultCode, null, null, false));
                shReceiver.onReceive(context, broadcastIntent, abort);
            }
        });
    }

    private void postToWrappers(List<ShadowApplication.Wrapper> wrappers, Intent intent, Context context, int resultCode) {
        AtomicBoolean abort = new AtomicBoolean(false);
        for (ShadowApplication.Wrapper wrapper : wrappers) {
            this.postIntent(intent, wrapper, abort, context, resultCode);
        }
    }

    private void postOrderedToWrappers(List<ShadowApplication.Wrapper> wrappers, Intent intent, int initialCode, String data, Bundle extras, final Context context) {
        AtomicBoolean abort = new AtomicBoolean(false);
        ListenableFuture<BroadcastResultHolder> future = Futures.immediateFuture((Object)new BroadcastResultHolder(initialCode, data, extras));
        for (ShadowApplication.Wrapper wrapper : wrappers) {
            future = this.postIntent(wrapper, intent, future, abort, context);
        }
        ListenableFuture<BroadcastResultHolder> finalFuture = future;
        future.addListener(new Runnable((ListenableFuture)finalFuture){
            final /* synthetic */ ListenableFuture val$finalFuture;
            {
                this.val$finalFuture = listenableFuture;
            }

            @Override
            public void run() {
                ShadowInstrumentation.this.getMainHandler(context).post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            val$finalFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }, MoreExecutors.directExecutor());
    }

    private ListenableFuture<BroadcastResultHolder> postIntent(final ShadowApplication.Wrapper wrapper, final Intent intent, ListenableFuture<BroadcastResultHolder> oldResult, final AtomicBoolean abort, final Context context) {
        final Handler scheduler = wrapper.scheduler != null ? wrapper.scheduler : this.getMainHandler(context);
        return Futures.transformAsync(oldResult, (AsyncFunction)new AsyncFunction<BroadcastResultHolder, BroadcastResultHolder>(){

            public ListenableFuture<BroadcastResultHolder> apply(BroadcastResultHolder broadcastResultHolder) throws Exception {
                BroadcastReceiver.PendingResult result = ShadowBroadcastPendingResult.create(broadcastResultHolder.resultCode, broadcastResultHolder.resultData, broadcastResultHolder.resultExtras, true);
                wrapper.broadcastReceiver.setPendingResult(result);
                scheduler.post(() -> {
                    ShadowBroadcastReceiver shadowBroadcastReceiver = (ShadowBroadcastReceiver)Shadow.extract((Object)wrapper2.broadcastReceiver);
                    shadowBroadcastReceiver.onReceive(context, intent, abort);
                });
                return BroadcastResultHolder.transform(result);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    void sendBroadcastWithPermission(Intent intent, String receiverPermission, Context context) {
        this.sendBroadcastWithPermission(intent, receiverPermission, context, 0);
    }

    void sendBroadcastWithPermission(Intent intent, String receiverPermission, Context context, int resultCode) {
        List<ShadowApplication.Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        this.postToWrappers(wrappers, intent, context, resultCode);
    }

    void sendOrderedBroadcastWithPermission(Intent intent, String receiverPermission, Context context) {
        List<ShadowApplication.Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        this.sortByPriority(wrappers);
        this.postOrderedToWrappers(wrappers, intent, 0, null, null, context);
    }

    private void sortByPriority(List<ShadowApplication.Wrapper> wrappers) {
        Collections.sort(wrappers, new Comparator<ShadowApplication.Wrapper>(){

            @Override
            public int compare(ShadowApplication.Wrapper o1, ShadowApplication.Wrapper o2) {
                return Integer.compare(o2.getIntentFilter().getPriority(), o1.getIntentFilter().getPriority());
            }
        });
    }

    List<Intent> getBroadcastIntents() {
        return this.broadcastIntents;
    }

    Intent getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(this.startedActivities.size() - 1);
    }

    Intent peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.get(this.startedActivities.size() - 1);
    }

    void clearNextStartedActivities() {
        this.startedActivities.clear();
    }

    ShadowActivity.IntentForResult getNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.remove(this.startedActivitiesForResults.size() - 1);
    }

    ShadowActivity.IntentForResult peekNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.get(this.startedActivitiesForResults.size() - 1);
    }

    void checkActivities(boolean checkActivities) {
        this.checkActivities = checkActivities;
    }

    int getRequestCodeForIntent(Intent requestIntent) {
        Integer requestCode = this.intentRequestCodeMap.get(new Intent.FilterComparison(requestIntent));
        if (requestCode == null) {
            throw new RuntimeException("No intent matches " + requestIntent + " among " + this.intentRequestCodeMap.keySet());
        }
        return requestCode;
    }

    protected ComponentName startService(Intent intent) {
        this.startedServices.add(new Intent.FilterComparison(intent));
        if (intent.getComponent() != null) {
            return intent.getComponent();
        }
        return new ComponentName("some.service.package", "SomeServiceName-FIXME");
    }

    boolean stopService(Intent name) {
        this.stoppedServices.add(new Intent.FilterComparison(name));
        return this.startedServices.contains(new Intent.FilterComparison(name));
    }

    void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        this.defaultServiceConnectionData = new ServiceConnectionDataWrapper(name, service);
    }

    void setComponentNameAndServiceForBindServiceForIntent(Intent intent, ComponentName name, IBinder service) {
        this.serviceConnectionDataForIntent.put(new Intent.FilterComparison(intent), new ServiceConnectionDataWrapper(name, service));
    }

    protected boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        this.boundServiceConnections.add(serviceConnection);
        this.unboundServiceConnections.remove(serviceConnection);
        if (this.unbindableActions.contains(intent.getAction())) {
            return false;
        }
        this.startedServices.add(new Intent.FilterComparison(intent));
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> {
            Intent.FilterComparison filterComparison = new Intent.FilterComparison(intent);
            ServiceConnectionDataWrapper serviceConnectionDataWrapper = this.serviceConnectionDataForIntent.containsKey(filterComparison) ? this.serviceConnectionDataForIntent.get(filterComparison) : this.defaultServiceConnectionData;
            this.serviceConnectionDataForServiceConnection.put(serviceConnection, serviceConnectionDataWrapper);
            serviceConnection.onServiceConnected(serviceConnectionDataWrapper.componentNameForBindService, serviceConnectionDataWrapper.binderForBindService);
        });
        return true;
    }

    protected void unbindService(ServiceConnection serviceConnection) {
        if (this.unbindServiceShouldThrowIllegalArgument) {
            throw new IllegalArgumentException();
        }
        this.unboundServiceConnections.add(serviceConnection);
        this.boundServiceConnections.remove(serviceConnection);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> {
            ServiceConnectionDataWrapper serviceConnectionDataWrapper = this.serviceConnectionDataForServiceConnection.containsKey(serviceConnection) ? this.serviceConnectionDataForServiceConnection.get(serviceConnection) : this.defaultServiceConnectionData;
            serviceConnection.onServiceDisconnected(serviceConnectionDataWrapper.componentNameForBindService);
        });
    }

    protected List<ServiceConnection> getBoundServiceConnections() {
        return this.boundServiceConnections;
    }

    void setUnbindServiceShouldThrowIllegalArgument(boolean flag) {
        this.unbindServiceShouldThrowIllegalArgument = flag;
    }

    protected List<ServiceConnection> getUnboundServiceConnections() {
        return this.unboundServiceConnections;
    }

    void declareActionUnbindable(String action) {
        this.unbindableActions.add(action);
    }

    public List<String> getUnbindableActions() {
        return this.unbindableActions;
    }

    Intent getNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.remove(0).getIntent();
    }

    Intent peekNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.get(0).getIntent();
    }

    void clearStartedServices() {
        this.startedServices.clear();
    }

    Intent getNextStoppedService() {
        if (this.stoppedServices.isEmpty()) {
            return null;
        }
        return this.stoppedServices.remove(0).getIntent();
    }

    void sendStickyBroadcast(Intent intent, Context context) {
        this.stickyIntents.put(intent.getAction(), intent);
        this.sendBroadcast(intent, context);
    }

    void sendBroadcast(Intent intent, Context context) {
        this.sendBroadcastWithPermission(intent, null, context);
    }

    Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, Context context) {
        return this.registerReceiver(receiver, filter, null, null, context);
    }

    Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        return this.registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, context);
    }

    Intent registerReceiverWithContext(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        if (receiver != null) {
            this.registeredReceivers.add(new ShadowApplication.Wrapper(receiver, filter, context, broadcastPermission, scheduler));
        }
        return this.processStickyIntents(filter, receiver, context);
    }

    private Intent processStickyIntents(IntentFilter filter, BroadcastReceiver receiver, Context context) {
        Intent result = null;
        for (Intent stickyIntent : this.stickyIntents.values()) {
            if (!filter.matchAction(stickyIntent.getAction())) continue;
            if (result == null) {
                result = stickyIntent;
            }
            if (receiver != null) {
                receiver.setPendingResult(ShadowBroadcastPendingResult.createSticky(stickyIntent));
                receiver.onReceive(context, stickyIntent);
                receiver.setPendingResult(null);
                continue;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        boolean found = false;
        Iterator<ShadowApplication.Wrapper> iterator = this.registeredReceivers.iterator();
        while (iterator.hasNext()) {
            ShadowApplication.Wrapper wrapper = iterator.next();
            if (wrapper.broadcastReceiver != broadcastReceiver) continue;
            iterator.remove();
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
        }
    }

    void clearRegisteredReceivers() {
        this.registeredReceivers.clear();
    }

    @Deprecated
    boolean hasReceiverForIntent(Intent intent) {
        for (ShadowApplication.Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    List<BroadcastReceiver> getReceiversForIntent(Intent intent) {
        ArrayList<BroadcastReceiver> broadcastReceivers = new ArrayList<BroadcastReceiver>();
        for (ShadowApplication.Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            broadcastReceivers.add(wrapper.getBroadcastReceiver());
        }
        return broadcastReceivers;
    }

    List<ShadowApplication.Wrapper> getRegisteredReceivers() {
        return this.registeredReceivers;
    }

    int checkPermission(String permission2, int pid, int uid) {
        Set<String> grantedPermissionsForPidUid = this.grantedPermissionsMap.get(new Pair((Object)pid, (Object)uid));
        return grantedPermissionsForPidUid != null && grantedPermissionsForPidUid.contains(permission2) ? 0 : -1;
    }

    void grantPermissions(String ... permissionNames) {
        this.grantPermissions(Process.myPid(), Process.myUid(), permissionNames);
    }

    void grantPermissions(int pid, int uid, String ... permissions) {
        Set<String> grantedPermissionsForPidUid = this.grantedPermissionsMap.get(new Pair((Object)pid, (Object)uid));
        if (grantedPermissionsForPidUid == null) {
            grantedPermissionsForPidUid = new HashSet<String>();
            this.grantedPermissionsMap.put((Pair<Integer, Integer>)new Pair((Object)pid, (Object)uid), grantedPermissionsForPidUid);
        }
        Collections.addAll(grantedPermissionsForPidUid, permissions);
    }

    void denyPermissions(String ... permissionNames) {
        this.denyPermissions(Process.myPid(), Process.myUid(), permissionNames);
    }

    void denyPermissions(int pid, int uid, String ... permissions) {
        Set<String> grantedPermissionsForPidUid = this.grantedPermissionsMap.get(new Pair((Object)pid, (Object)uid));
        if (grantedPermissionsForPidUid != null) {
            for (String permissionName : permissions) {
                grantedPermissionsForPidUid.remove(permissionName);
            }
        }
    }

    private boolean hasMatchingPermission(String permission1, String permission2) {
        return permission1 == null ? permission2 == null : permission1.equals(permission2);
    }

    private Handler getMainHandler(Context context) {
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(context.getMainLooper());
        }
        return this.mainHandler;
    }

    public static Instrumentation getInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        if (activityThread != null) {
            return activityThread.getInstrumentation();
        }
        return null;
    }

    private static class ServiceConnectionDataWrapper {
        public final ComponentName componentNameForBindService;
        public final IBinder binderForBindService;

        private ServiceConnectionDataWrapper(ComponentName componentNameForBindService, IBinder binderForBindService) {
            this.componentNameForBindService = componentNameForBindService;
            this.binderForBindService = binderForBindService;
        }
    }

    private static final class BroadcastResultHolder {
        private final int resultCode;
        private final String resultData;
        private final Bundle resultExtras;

        private BroadcastResultHolder(int resultCode, String resultData, Bundle resultExtras) {
            this.resultCode = resultCode;
            this.resultData = resultData;
            this.resultExtras = resultExtras;
        }

        private static ListenableFuture<BroadcastResultHolder> transform(BroadcastReceiver.PendingResult result) {
            ShadowBroadcastPendingResult shadowBroadcastPendingResult = (ShadowBroadcastPendingResult)Shadow.extract((Object)result);
            return Futures.transform(shadowBroadcastPendingResult.getFuture(), pendingResult -> new BroadcastResultHolder(pendingResult.getResultCode(), pendingResult.getResultData(), pendingResult.getResultExtras(false)), (Executor)MoreExecutors.directExecutor());
        }
    }

    @ForType(value=Instrumentation.class)
    public static interface _Instrumentation_ {
        public void init(ActivityThread var1, Context var2, Context var3, ComponentName var4, @WithType(value="android.app.IInstrumentationWatcher") Object var5);

        public void init(ActivityThread var1, Context var2, Context var3, ComponentName var4, @WithType(value="android.app.IInstrumentationWatcher") Object var5, @WithType(value="android.app.IUiAutomationConnection") Object var6);
    }
}

