/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.DropBoxManager;
import java.util.SortedMap;
import java.util.TreeMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=DropBoxManager.class)
public class ShadowDropBoxManager {
    private final SortedMap<Long, DropBoxManager.Entry> entries = new TreeMap<Long, DropBoxManager.Entry>();

    public ShadowDropBoxManager() {
        this.reset();
    }

    void addData(String tag, long timestamp, byte[] data) {
        this.entries.put(timestamp, new DropBoxManager.Entry(tag, timestamp, data, 2));
    }

    public void reset() {
        this.entries.clear();
    }

    @Implementation
    protected DropBoxManager.Entry getNextEntry(String tag, long millis) {
        for (DropBoxManager.Entry entry : this.entries.tailMap(millis).values()) {
            if (tag != null && !entry.getTag().equals(tag) || entry.getTimeMillis() <= millis) continue;
            return entry;
        }
        return null;
    }
}

