/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.CrossProfileApps;
import android.content.pm.ICrossProfileApps;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CrossProfileApps.class, minSdk=28)
public class ShadowCrossProfileApps {
    private final Set<UserHandle> targetUserProfiles = new LinkedHashSet<UserHandle>();
    private final List<StartedMainActivity> startedMainActivities = new ArrayList<StartedMainActivity>();
    private PackageManager packageManager;

    @Implementation
    protected void __constructor__(Context context, ICrossProfileApps service) {
        this.packageManager = context.getPackageManager();
    }

    @Implementation
    protected List<UserHandle> getTargetUserProfiles() {
        return ImmutableList.copyOf(this.targetUserProfiles);
    }

    @Implementation
    protected Drawable getProfileSwitchingIconDrawable(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return new ColorDrawable(userHandle.getIdentifier());
    }

    @Implementation
    protected CharSequence getProfileSwitchingLabel(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return "Switch to " + userHandle;
    }

    @Implementation
    protected void startMainActivity(ComponentName componentName, UserHandle targetUser) {
        this.verifyCanAccessUser(targetUser);
        this.verifyMainActivityInManifest(componentName);
        this.startedMainActivities.add(new StartedMainActivity(componentName, targetUser));
    }

    public void addTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.add(userHandle);
    }

    public void removeTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.remove(userHandle);
    }

    public void clearTargetUserProfiles() {
        this.targetUserProfiles.clear();
    }

    public StartedMainActivity peekNextStartedMainActivity() {
        if (this.startedMainActivities.isEmpty()) {
            return null;
        }
        return (StartedMainActivity)Iterables.getLast(this.startedMainActivities);
    }

    private void verifyCanAccessUser(UserHandle userHandle) {
        if (!this.targetUserProfiles.contains(userHandle)) {
            throw new SecurityException("Not allowed to access " + userHandle + " (did you forget to call addTargetUserProfile?)");
        }
    }

    private void verifyMainActivityInManifest(ComponentName component) {
        Intent launchIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER").addFlags(0x10200000).setPackage(component.getPackageName());
        boolean existsMatchingActivity = Iterables.any((Iterable)this.packageManager.queryIntentActivities(launchIntent, 786432), resolveInfo -> {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            return TextUtils.equals((CharSequence)activityInfo.packageName, (CharSequence)component.getPackageName()) && TextUtils.equals((CharSequence)activityInfo.name, (CharSequence)component.getClassName()) && activityInfo.exported;
        });
        if (!existsMatchingActivity) {
            throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER or activity is not exported" + component);
        }
    }

    public static class StartedMainActivity {
        private final ComponentName componentName;
        private final UserHandle userHandle;

        public StartedMainActivity(ComponentName componentName, UserHandle userHandle) {
            this.componentName = (ComponentName)Preconditions.checkNotNull((Object)componentName);
            this.userHandle = (UserHandle)Preconditions.checkNotNull((Object)userHandle);
        }

        public ComponentName getComponentName() {
            return this.componentName;
        }

        public UserHandle getUserHandle() {
            return this.userHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedMainActivity that = (StartedMainActivity)o;
            return Objects.equals(this.componentName, that.componentName) && Objects.equals(this.userHandle, that.userHandle);
        }

        public int hashCode() {
            return Objects.hash(this.componentName, this.userHandle);
        }
    }
}

