/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.Map;
import java.util.function.BooleanSupplier;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.app.SystemServiceRegistry", isInAndroidSdk=false, minSdk=23)
public class ShadowSystemServiceRegistry {
    private static final String STATIC_SERVICE_FETCHER_CLASS_NAME = "android.app.SystemServiceRegistry$StaticServiceFetcher";
    private static final String IS_CACHED_FIELD_NAME = "mIsCached";
    private static final String STATIC_CONTEXT_SERVICE_FETCHER_CLASS_NAME_M = "android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher";
    private static final String STATIC_CONTEXT_SERVICE_FETCHER_CLASS_NAME_N = "android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher";
    private static final String CACHED_SERVICE_FETCHER_CLASS_NAME = "android.app.SystemServiceRegistry$CachedServiceFetcher";
    private static volatile BooleanSupplier isStaticServiceFetcherIsCachedPresent = () -> {
        boolean isFieldPresent = ReflectionHelpers.hasField(ShadowSystemServiceRegistry.classForName(STATIC_SERVICE_FETCHER_CLASS_NAME), (String)IS_CACHED_FIELD_NAME);
        isStaticServiceFetcherIsCachedPresent = () -> isFieldPresent;
        return isFieldPresent;
    };

    @Resetter
    public static void reset() {
        Map<String, Object> fetchers = ((SystemServiceRegistryReflector)Reflector.reflector(SystemServiceRegistryReflector.class)).getSystemServiceFetchers();
        for (Map.Entry<String, Object> oFetcher : fetchers.entrySet()) {
            ServiceFetcherReflector.get(oFetcher.getKey(), oFetcher.getValue()).clearInstance();
        }
    }

    @Implementation(minSdk=26)
    protected static void onServiceNotFound(@ClassName(value="android.os.ServiceManager$ServiceNotFoundException") @ClassName(value="android.os.ServiceManager$ServiceNotFoundException") Object e0) {
        Exception e = (Exception)e0;
        e.printStackTrace();
    }

    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @ForType(className="android.app.SystemServiceRegistry")
    static interface SystemServiceRegistryReflector {
        @Accessor(value="SYSTEM_SERVICE_FETCHERS")
        public Map<String, Object> getSystemServiceFetchers();
    }

    static interface ServiceFetcherReflector {
        public void setCachedInstance(Object var1);

        public static ServiceFetcherReflector get(String key, Object serviceFetcher) {
            String serviceFetcherClassName = ServiceFetcherReflector.getConcreteClassName(serviceFetcher);
            if (serviceFetcherClassName == null) {
                throw new IllegalStateException("could not find class name for serviceFetcher " + key);
            }
            switch (serviceFetcherClassName) {
                case "android.app.SystemServiceRegistry$StaticServiceFetcher": {
                    return (ServiceFetcherReflector)Reflector.reflector(StaticServiceFetcherReflector.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher": {
                    return (ServiceFetcherReflector)Reflector.reflector(ServiceFetcherReflectorM.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher": {
                    return (ServiceFetcherReflector)Reflector.reflector(ServiceFetcherReflectorN.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$CachedServiceFetcher": {
                    return o -> {};
                }
            }
            if (key.equals("input_method")) {
                return o -> {};
            }
            if (key.equals("input")) {
                return o -> {};
            }
            throw new IllegalStateException("did not recognize serviceFetcher class name " + serviceFetcherClassName + " for key '" + key + "'");
        }

        public static String getConcreteClassName(Object serviceFetcher) {
            Class<?> serviceFetcherClass;
            for (serviceFetcherClass = serviceFetcher.getClass(); serviceFetcherClass != null && serviceFetcherClass.getCanonicalName() == null; serviceFetcherClass = serviceFetcherClass.getSuperclass()) {
            }
            return serviceFetcherClass == null ? null : serviceFetcherClass.getName();
        }

        default public void clearInstance() {
            this.setCachedInstance(null);
            if (this instanceof StaticServiceFetcherReflector && isStaticServiceFetcherIsCachedPresent.getAsBoolean()) {
                ((StaticServiceFetcherReflector)this).setIsCached(false);
            }
        }
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher")
    public static interface ServiceFetcherReflectorN
    extends ServiceFetcherReflector {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher")
    public static interface ServiceFetcherReflectorM
    extends ServiceFetcherReflector {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticServiceFetcher")
    public static interface StaticServiceFetcherReflector
    extends ServiceFetcherReflector {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);

        @Accessor(value="mIsCached")
        public void setIsCached(boolean var1);
    }
}

