/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Process;
import android.os.health.HealthStats;
import android.os.health.SystemHealthManager;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.HealthStatsBuilder;

@Implements(value=SystemHealthManager.class, minSdk=24)
public class ShadowSystemHealthManager {
    private static final HealthStats DEFAULT_HEALTH_STATS = HealthStatsBuilder.newBuilder().setDataType("default_health_stats").build();
    private static final HashMap<Integer, HealthStats> uidToHealthStats = new HashMap();

    @Resetter
    public static void reset() {
        uidToHealthStats.clear();
    }

    @Implementation
    protected HealthStats takeMyUidSnapshot() {
        return this.takeUidSnapshot(Process.myUid());
    }

    @Implementation
    protected HealthStats takeUidSnapshot(int uid) {
        return uidToHealthStats.getOrDefault(uid, DEFAULT_HEALTH_STATS);
    }

    @Implementation
    protected HealthStats[] takeUidSnapshots(int[] uids) {
        HealthStats[] stats = new HealthStats[uids.length];
        for (int i = 0; i < uids.length; ++i) {
            stats[i] = this.takeUidSnapshot(uids[i]);
        }
        return stats;
    }

    public void addHealthStatsForUid(int uid, HealthStats stats) {
        uidToHealthStats.put(uid, stats);
    }

    public void addHealthStats(HealthStats stats) {
        this.addHealthStatsForUid(Process.myUid(), stats);
    }
}

