/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.role.IRoleManager;
import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.UserHandle;
import com.android.internal.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=RoleManager.class, minSdk=29)
public class ShadowRoleManager {
    @RealObject
    protected RoleManager roleManager;
    private static final ImmutableSet<String> DEFAULT_APPLICATION_ROLES = ImmutableSet.of((Object)"android.app.role.ASSISTANT", (Object)"android.app.role.BROWSER", (Object)"android.app.role.CALL_REDIRECTION", (Object)"android.app.role.CALL_SCREENING", (Object)"android.app.role.DIALER", (Object)"android.app.role.HOME", (Object[])new String[]{"android.app.role.SMS"});
    private Context context;
    private static final Map<UserHandle, RoleUserState> userStates = new HashMap<UserHandle, RoleUserState>();

    @Implementation(maxSdk=30)
    protected void __constructor__(Context context) {
        this.context = context;
        Shadow.invokeConstructor(RoleManager.class, (Object)this.roleManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation(minSdk=31)
    protected void __constructor__(Context context, IRoleManager service) {
        this.context = context;
        Shadow.invokeConstructor(RoleManager.class, (Object)this.roleManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IRoleManager.class, (Object)service)});
    }

    public static void addRoleHolder(@Nonnull String roleName, @Nonnull String roleHolder, @Nonnull UserHandle user) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        Objects.requireNonNull(roleHolder);
        Objects.requireNonNull(user);
        Preconditions.checkArgument((user.getIdentifier() >= 0 ? 1 : 0) != 0, (Object)"Invalid user");
        RoleUserState.getUserState(user).addRoleHolder(roleName, roleHolder);
    }

    public static void removeRoleHolder(@Nonnull String roleName, @Nonnull String roleHolder, @Nonnull UserHandle user) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        Objects.requireNonNull(roleHolder);
        Objects.requireNonNull(user);
        Preconditions.checkArgument((user.getIdentifier() >= 0 ? 1 : 0) != 0, (Object)"Invalid user");
        Preconditions.checkArgument((boolean)RoleUserState.getUserState((UserHandle)user).roleHolders.containsKey(roleName), (Object)"the supplied roleName was never added.");
        RoleUserState.getUserState(user).removeRoleHolder(roleName, roleHolder);
    }

    @Deprecated
    public void addHeldRole(@Nonnull String roleName) {
        ShadowRoleManager.addRoleHolder(roleName, this.context.getPackageName(), this.context.getUser());
    }

    @Deprecated
    public void removeHeldRole(@Nonnull String roleName) {
        ShadowRoleManager.removeRoleHolder(roleName, this.context.getPackageName(), this.context.getUser());
    }

    @Deprecated
    public void addAvailableRole(@Nonnull String roleName) {
        ShadowRoleManager.addRoleHolder(roleName, "", this.context.getUser());
    }

    @Deprecated
    public void removeAvailableRole(@Nonnull String roleName) {
        ShadowRoleManager.removeRoleHolder(roleName, "", this.context.getUser());
    }

    @Implementation
    protected boolean isRoleHeld(@Nonnull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return RoleUserState.getUserState((UserHandle)this.context.getUser()).roleHolders.getOrDefault(roleName, (Set<String>)ImmutableSet.of()).contains(this.context.getPackageName());
    }

    @Implementation
    protected boolean isRoleAvailable(@Nonnull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return RoleUserState.getUserState((UserHandle)this.context.getUser()).roleHolders.containsKey(roleName);
    }

    @Nullable
    @Implementation(minSdk=34)
    protected String getDefaultApplication(@Nonnull String roleName) {
        return RoleUserState.getUserState((UserHandle)this.context.getUser()).roleHolders.getOrDefault(roleName, (Set<String>)ImmutableSet.of()).stream().findFirst().orElse(null);
    }

    @Implementation(minSdk=34)
    protected void setDefaultApplication(@Nonnull String roleName, @Nullable String packageName, int flags, @Nonnull Executor executor, @Nonnull Consumer<Boolean> callback) {
        Preconditions.checkArgument((boolean)DEFAULT_APPLICATION_ROLES.contains((Object)roleName), (Object)"the supplied roleName in not a default app.");
        try {
            this.context.getPackageManager().getPackageInfo(packageName, 0);
            if (this.isRoleAvailable(roleName)) {
                RoleUserState.getUserState(this.context.getUser()).addRoleHolder(roleName, packageName);
                executor.execute(() -> callback.accept(true));
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        executor.execute(() -> callback.accept(false));
    }

    @Implementation
    protected void addOnRoleHoldersChangedListenerAsUser(@Nonnull Executor executor, @Nonnull OnRoleHoldersChangedListener listener, @Nonnull UserHandle user) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        Objects.requireNonNull(user);
        RoleUserState.getUserState((UserHandle)user).roleHoldersListener.put(listener, executor);
    }

    @Implementation
    protected void removeOnRoleHoldersChangedListenerAsUser(@Nonnull OnRoleHoldersChangedListener listener, @Nonnull UserHandle user) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(user);
        RoleUserState.getUserState((UserHandle)user).roleHoldersListener.remove(listener);
    }

    @Implementation
    protected List<String> getRoleHolders(@Nonnull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return this.getRoleHoldersAsUser(roleName, this.context.getUser());
    }

    @Implementation
    protected List<String> getRoleHoldersAsUser(@Nonnull String roleName, @Nonnull UserHandle user) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        Objects.requireNonNull(user);
        return ImmutableList.copyOf(new ArrayList(RoleUserState.getUserState((UserHandle)user).roleHolders.getOrDefault(roleName, (Set<String>)ImmutableSet.of())));
    }

    @Resetter
    public static void reset() {
        userStates.clear();
    }

    private static class RoleUserState {
        final Map<String, Set<String>> roleHolders = new HashMap<String, Set<String>>();
        final Map<OnRoleHoldersChangedListener, Executor> roleHoldersListener = new HashMap<OnRoleHoldersChangedListener, Executor>();
        final UserHandle user;

        RoleUserState(UserHandle u) {
            this.user = u;
        }

        void addRoleHolder(String roleName, String roleHolder) {
            Set holders = this.roleHolders.computeIfAbsent(roleName, k -> new HashSet());
            if (!roleHolder.isEmpty()) {
                holders.add(roleHolder);
            }
            this.broadcastRoleHoldersChanged(roleName);
        }

        void removeRoleHolder(String roleName, String roleHolder) {
            Preconditions.checkArgument((this.roleHolders.get(roleName) != null ? 1 : 0) != 0, (Object)"the supplied roleName was never added for this user");
            Preconditions.checkArgument((roleHolder.isEmpty() || this.roleHolders.get(roleName).contains(roleHolder) ? 1 : 0) != 0, (Object)"the supplied roleHolder does not hold this role for this user.");
            if (!roleHolder.isEmpty()) {
                this.roleHolders.get(roleName).remove(roleHolder);
            }
            if (this.roleHolders.get(roleName).isEmpty()) {
                this.roleHolders.remove(roleName);
            }
            this.broadcastRoleHoldersChanged(roleName);
        }

        private void broadcastRoleHoldersChanged(String roleName) {
            this.roleHoldersListener.forEach((listener, executor) -> executor.execute(() -> listener.onRoleHoldersChanged(roleName, this.user)));
            RoleUserState.getUserState((UserHandle)UserHandle.ALL).roleHoldersListener.forEach((listener, executor) -> executor.execute(() -> listener.onRoleHoldersChanged(roleName, this.user)));
        }

        static RoleUserState getUserState(UserHandle u) {
            return userStates.computeIfAbsent(u, RoleUserState::new);
        }
    }
}

