/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.Choreographer;
import android.view.RenderNodeAnimator;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=RenderNodeAnimator.class, isInAndroidSdk=false, maxSdk=29)
public class ShadowRenderNodeAnimator {
    private static final int STATE_FINISHED = 3;
    @RealObject
    RenderNodeAnimator realObject;
    private final Choreographer choreographer = Choreographer.getInstance();
    private boolean scheduled = false;
    private long startTime = -1L;
    private boolean isEnding = false;
    private final Choreographer.FrameCallback frameCallback = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ShadowRenderNodeAnimator.this.scheduled = false;
            if (ShadowRenderNodeAnimator.this.startTime == -1L) {
                ShadowRenderNodeAnimator.this.startTime = frameTimeNanos;
            }
            long duration = ShadowRenderNodeAnimator.this.realObject.getDuration();
            long curTime = frameTimeNanos - ShadowRenderNodeAnimator.this.startTime;
            if (curTime >= duration) {
                ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)ShadowRenderNodeAnimator.this.realObject)).onFinished();
            } else {
                ShadowRenderNodeAnimator.this.schedule();
            }
        }
    };

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() <= 29) {
            ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class)).setAnimationHelper(new ThreadLocal());
        }
    }

    @Implementation
    public void moveToRunningState() {
        ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject)).moveToRunningState();
        if (!this.isEnding) {
            this.schedule();
        }
    }

    @Implementation
    public void doStart() {
        ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject)).doStart();
    }

    @Implementation
    public void cancel() {
        RenderNodeAnimatorReflector renderNodeReflector = (RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject);
        renderNodeReflector.cancel();
    }

    @Implementation
    public void end() {
        RenderNodeAnimatorReflector renderNodeReflector = (RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject);
        this.isEnding = true;
        renderNodeReflector.end();
        this.isEnding = false;
        this.unschedule();
        int state = renderNodeReflector.getState();
        if (state != 3) {
            renderNodeReflector.onFinished();
        }
    }

    private void schedule() {
        if (!this.scheduled) {
            this.scheduled = true;
            this.choreographer.postFrameCallback(this.frameCallback);
        }
    }

    private void unschedule() {
        if (this.scheduled) {
            this.choreographer.removeFrameCallback(this.frameCallback);
            this.scheduled = false;
        }
    }

    @ForType(value=RenderNodeAnimator.class)
    static interface RenderNodeAnimatorReflector {
        @Accessor(value="mState")
        public int getState();

        @Static
        @Accessor(value="sAnimationHelper")
        public void setAnimationHelper(ThreadLocal<?> var1);

        public void onFinished();

        @Direct
        public void doStart();

        @Direct
        public void cancel();

        @Direct
        public void moveToRunningState();

        @Direct
        public void end();
    }
}

