/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Os.class)
public final class ShadowOs {
    private static final Map<Integer, Long> sysconfValues = new HashMap<Integer, Long>();
    private static final Map<FileDescriptor, Long> offsetValues = new HashMap<FileDescriptor, Long>();

    private ShadowOs() {
    }

    public static void setSysconfValue(int name, long value) {
        sysconfValues.put(name, value);
    }

    @Implementation
    protected static long sysconf(int name) {
        return sysconfValues.getOrDefault(name, -1L);
    }

    @Implementation
    protected static long lseek(FileDescriptor fd, long offset, int whence) throws ErrnoException {
        if (whence == OsConstants.SEEK_SET) {
            offsetValues.put(fd, offset);
            return offset;
        }
        if (whence == OsConstants.SEEK_CUR) {
            long newOffset = offsetValues.getOrDefault(fd, 0L) + offset;
            offsetValues.put(fd, newOffset);
            return newOffset;
        }
        return ((OsReflector)Reflector.reflector(OsReflector.class)).lseek(fd, offset, whence);
    }

    @ForType(value=Os.class)
    static interface OsReflector {
        @Direct
        @Static
        public long lseek(FileDescriptor var1, long var2, int var4);
    }
}

