/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.SQLiteConnectionNatives;
import org.robolectric.shadows.ShadowSQLiteConnection;
import org.robolectric.util.PerfStatsCollector;

@Implements(className="android.database.sqlite.SQLiteConnection", isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeSQLiteConnection
extends ShadowSQLiteConnection {
    @Implementation(maxSdk=26)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        return ShadowNativeSQLiteConnection.nativeOpen(path, openFlags, label, enableTrace, enableProfile, 0, 0);
    }

    @Implementation(minSdk=27, maxSdk=34)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile, int lookasideSlotSize, int lookasideSlotCount) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeOpen((String)path, (int)openFlags, (String)label, (boolean)enableTrace, (boolean)enableProfile, (int)lookasideSlotSize, (int)lookasideSlotCount));
    }

    @Implementation(maxSdk=34)
    protected static void nativeClose(long connectionPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeClose((long)connectionPtr));
    }

    @Implementation(maxSdk=34)
    protected static long nativePrepareStatement(long connectionPtr, String sql) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativePrepareStatement((long)connectionPtr, (String)sql));
    }

    @Implementation(maxSdk=34)
    protected static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeFinalizeStatement((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetParameterCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetParameterCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeIsReadOnly(long connectionPtr, long statementPtr) {
        return (Boolean)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeIsReadOnly((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static String nativeExecuteForString(long connectionPtr, long statementPtr) {
        return (String)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForString((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterLocalizedCollators((long)connectionPtr, (String)locale));
    }

    @Implementation(maxSdk=34)
    protected static long nativeExecuteForLong(long connectionPtr, long statementPtr) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForLong((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=32)
    protected static void nativeExecute(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecute((long)connectionPtr, (long)statementPtr, (boolean)false));
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected static void nativeExecute(long connectionPtr, long statementPtr, boolean isPragmaStmt) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecute((long)connectionPtr, (long)statementPtr, (boolean)isPragmaStmt));
    }

    @Implementation(maxSdk=34)
    protected static int nativeExecuteForChangedRowCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForChangedRowCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetColumnCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetColumnCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static String nativeGetColumnName(long connectionPtr, long statementPtr, int index) {
        return (String)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetColumnName((long)connectionPtr, (long)statementPtr, (int)index));
    }

    @Implementation(maxSdk=34)
    protected static void nativeBindNull(long connectionPtr, long statementPtr, int index) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindNull((long)connectionPtr, (long)statementPtr, (int)index));
    }

    @Implementation(maxSdk=34)
    protected static void nativeBindLong(long connectionPtr, long statementPtr, int index, long value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindLong((long)connectionPtr, (long)statementPtr, (int)index, (long)value));
    }

    @Implementation(maxSdk=34)
    protected static void nativeBindDouble(long connectionPtr, long statementPtr, int index, double value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindDouble((long)connectionPtr, (long)statementPtr, (int)index, (double)value));
    }

    @Implementation(maxSdk=34)
    protected static void nativeBindString(long connectionPtr, long statementPtr, int index, String value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindString((long)connectionPtr, (long)statementPtr, (int)index, (String)value));
    }

    @Implementation(maxSdk=34)
    protected static void nativeBindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindBlob((long)connectionPtr, (long)statementPtr, (int)index, (byte[])value));
    }

    @Implementation(maxSdk=34)
    protected static void nativeResetStatementAndClearBindings(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeResetStatementAndClearBindings((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static long nativeExecuteForLastInsertedRowId(long connectionPtr, long statementPtr) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForLastInsertedRowId((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static long nativeExecuteForCursorWindow(long connectionPtr, long statementPtr, long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForCursorWindow((long)connectionPtr, (long)statementPtr, (long)windowPtr, (int)startPos, (int)requiredPos, (boolean)countAllRows));
    }

    @Implementation(maxSdk=34)
    protected static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForBlobFileDescriptor((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=34)
    protected static void nativeCancel(long connectionPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeCancel((long)connectionPtr));
    }

    @Implementation(maxSdk=34)
    protected static void nativeResetCancel(long connectionPtr, boolean cancelable) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeResetCancel((long)connectionPtr, (boolean)cancelable));
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static void nativeRegisterCustomScalarFunction(long connectionPtr, String name, UnaryOperator<String> function) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterCustomScalarFunction((long)connectionPtr, (String)name, (UnaryOperator)function));
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static void nativeRegisterCustomAggregateFunction(long connectionPtr, String name, BinaryOperator<String> function) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterCustomAggregateFunction((long)connectionPtr, (String)name, (BinaryOperator)function));
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetDbLookaside(long connectionPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetDbLookaside((long)connectionPtr));
    }
}

