/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.content.res.AssetManager;
import android.graphics.fonts.Font;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppAssetManager2;
import org.robolectric.res.android.Registries;
import org.robolectric.shadows.ShadowArscAssetManager10;

@Implements(value=Font.Builder.class, minSdk=29)
@RequiresApi(api=29)
public class ShadowFontBuilder {
    private static final Map<Long, FontInternal> resettableByteBuffers = new HashMap<Long, FontInternal>();

    @Resetter
    public static void reset() {
        for (Map.Entry<Long, FontInternal> entry : resettableByteBuffers.entrySet()) {
            FontInternal fontInternal = entry.getValue();
            if (fontInternal == null || fontInternal.buffer == null) continue;
            ByteBuffer buffer = fontInternal.buffer;
            buffer.rewind();
            buffer.clear();
        }
        resettableByteBuffers.clear();
    }

    static ByteBuffer getBuffer(long ptr) {
        FontInternal fontInternal = resettableByteBuffers.get(ptr);
        if (fontInternal == null) {
            return ByteBuffer.allocate(0);
        }
        return fontInternal.buffer;
    }

    static int getPackedStyle(long ptr) {
        FontInternal fontInternal = resettableByteBuffers.get(ptr);
        if (fontInternal == null) {
            return 400;
        }
        return ShadowFontBuilder.pack(fontInternal.weight, fontInternal.italic);
    }

    private static int pack(int weight, boolean italic) {
        return weight | (italic ? 65536 : 0);
    }

    @Implementation(maxSdk=29)
    protected static long nGetNativeAsset(AssetManager assetMgr, String path, boolean isAsset, int cookie) {
        Objects.requireNonNull(assetMgr);
        Objects.requireNonNull(path);
        CppAssetManager2 mgr = ShadowArscAssetManager10.AssetManagerForJavaObject(assetMgr);
        if (mgr == null) {
            return 0L;
        }
        Asset asset = isAsset ? mgr.Open(path, Asset.AccessMode.ACCESS_BUFFER) : (cookie > 0 ? mgr.OpenNonAsset(path, ApkAssetsCookie.forInt((int)(cookie - 1)), Asset.AccessMode.ACCESS_BUFFER) : mgr.OpenNonAsset(path, Asset.AccessMode.ACCESS_BUFFER));
        return Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
    }

    @Implementation(maxSdk=29)
    protected static ByteBuffer nGetAssetBuffer(long nativeAsset) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(nativeAsset);
        return ByteBuffer.wrap(asset.getBuffer(false));
    }

    @Implementation(maxSdk=29)
    protected static long nGetReleaseNativeAssetFunc() {
        return 0L;
    }

    @Implementation(minSdk=30)
    protected static ByteBuffer createBuffer(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
        Objects.requireNonNull(am, "assetManager can not be null");
        Objects.requireNonNull(path, "path can not be null");
        try (InputStream assetStream = isAsset ? am.open(path, 3) : am.openNonAsset(cookie, path, 3);){
            int capacity = assetStream.available();
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.order(ByteOrder.nativeOrder());
            assetStream.read(buffer.array(), buffer.arrayOffset(), assetStream.available());
            if (assetStream.read() != -1) {
                throw new IOException("Unable to access full contents of " + path);
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    @Implementation(minSdk=31)
    protected static long nBuild(long builderPtr, ByteBuffer buffer, String filePath, String localeList, int weight, boolean italic, int ttcIndex) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(filePath);
        Objects.requireNonNull(localeList);
        buffer.rewind();
        long ptr = (long)buffer.hashCode() * 32L + (long)ShadowFontBuilder.pack(weight, italic);
        FontInternal fontInternal = new FontInternal();
        fontInternal.buffer = buffer;
        fontInternal.filePath = filePath;
        fontInternal.localeList = localeList;
        fontInternal.weight = weight;
        fontInternal.italic = italic;
        fontInternal.ttcIndex = ttcIndex;
        resettableByteBuffers.put(ptr, fontInternal);
        return ptr;
    }

    private static class FontInternal {
        ByteBuffer buffer;
        String filePath;
        String localeList;
        int weight;
        boolean italic;
        int ttcIndex;

        private FontInternal() {
        }
    }
}

