/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.view.Choreographer;
import android.view.DisplayEventReceiver;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowBackdropFrameRenderer;
import org.robolectric.shadows.ShadowLegacyChoreographer;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedChoreographer;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=Choreographer.class, shadowPicker=Picker.class)
public abstract class ShadowChoreographer {
    @RealObject
    Choreographer realObject;
    private ChoreographerReflector reflector;
    private static volatile boolean isPaused = false;
    private static volatile Duration frameDelay = Duration.ofMillis(ShadowChoreographer.getDefaultFrameDelay());
    private static volatile long nextVsyncTimeNanos;

    public static void setFrameDelay(Duration delay) {
        Preconditions.checkState((!ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY) ? 1 : 0) != 0, (String)"Looper cannot be %s", (Object)LooperMode.Mode.LEGACY);
        frameDelay = delay;
    }

    public static Duration getFrameDelay() {
        Preconditions.checkState((!ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY) ? 1 : 0) != 0, (String)"Looper cannot be %s", (Object)LooperMode.Mode.LEGACY);
        return frameDelay;
    }

    public static void setPaused(boolean paused) {
        Preconditions.checkState((!ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY) ? 1 : 0) != 0, (String)"Looper cannot be %s", (Object)LooperMode.Mode.LEGACY);
        isPaused = paused;
    }

    public static boolean isPaused() {
        Preconditions.checkState((!ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY) ? 1 : 0) != 0, (String)"Looper cannot be %s", (Object)LooperMode.Mode.LEGACY);
        return isPaused;
    }

    @Deprecated
    public static long getNextVsyncTime() {
        return Duration.ofNanos(ShadowChoreographer.getNextVsyncTimeNanos()).toMillis();
    }

    public static long getNextVsyncTimeNanos() {
        return nextVsyncTimeNanos;
    }

    static void setNextVsyncTimeNanos(long nextVsyncTimeNanos) {
        ShadowChoreographer.nextVsyncTimeNanos = nextVsyncTimeNanos;
    }

    @Deprecated
    public static void setPostCallbackDelay(int delayMillis) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        ShadowLegacyChoreographer.setPostCallbackDelay(delayMillis);
    }

    @Deprecated
    public static void setPostFrameCallbackDelay(int delayMillis) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.LEGACY) {
            ShadowLegacyChoreographer.setPostFrameCallbackDelay(delayMillis);
        } else {
            ShadowChoreographer.setPaused(delayMillis != 0);
            ShadowChoreographer.setFrameDelay(Duration.ofMillis(delayMillis == 0 ? 1L : (long)delayMillis));
        }
    }

    @Deprecated
    public static long getFrameInterval() {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        return ShadowLegacyChoreographer.getFrameInterval();
    }

    @Deprecated
    public static void setFrameInterval(long frameInterval) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        ShadowLegacyChoreographer.setFrameInterval(frameInterval);
    }

    @Implementation(maxSdk=30)
    protected void doFrame(long frameTimeNanos, int frame) {
        if (this.reflector == null) {
            this.reflector = (ChoreographerReflector)Reflector.reflector(ChoreographerReflector.class, (Object)this.realObject);
        }
        PerfStatsCollector.getInstance().measure("doFrame", () -> this.reflector.doFrame(frameTimeNanos, frame));
    }

    @Implementation(minSdk=31)
    protected void doFrame(long frameTimeNanos, int frame, @ClassName(value="android.view.DisplayEventReceiver$VsyncEventData") @ClassName(value="android.view.DisplayEventReceiver$VsyncEventData") Object vsyncEventData) {
        if (this.reflector == null) {
            this.reflector = (ChoreographerReflector)Reflector.reflector(ChoreographerReflector.class, (Object)this.realObject);
        }
        PerfStatsCollector.getInstance().measure("doFrame", () -> this.reflector.doFrame(frameTimeNanos, frame, vsyncEventData));
    }

    @Resetter
    public static void reset() {
        nextVsyncTimeNanos = 0L;
        isPaused = false;
        frameDelay = Duration.ofMillis(ShadowChoreographer.getDefaultFrameDelay());
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            ShadowBackdropFrameRenderer.reset();
        }
    }

    @Implementation(minSdk=37)
    protected static long getDefaultFrameDelay() {
        return Integer.getInteger("robolectric.defaultFrameDelayMs", 15).intValue();
    }

    @ForType(value=Choreographer.class)
    protected static interface ChoreographerReflector {
        @Accessor(value="mLastFrameTimeNanos")
        public void setLastFrameTimeNanos(long var1);

        @Accessor(value="mCallbackQueues")
        public Object[] getCallbackQueues();

        @Accessor(value="mCallbackPool")
        public void setCallbackPool(Object var1);

        @Accessor(value="mFrameScheduled")
        public void setFrameScheduled(boolean var1);

        @Accessor(value="mCallbacksRunning")
        public void setCallbacksRunning(boolean var1);

        @Direct
        public void doFrame(long var1, int var3);

        @Direct
        public void doFrame(long var1, int var3, @WithType(value="android.view.DisplayEventReceiver$VsyncEventData") Object var4);

        @Accessor(value="mDisplayEventReceiver")
        public DisplayEventReceiver getReceiver();

        @Accessor(value="sThreadInstance")
        @Static
        public ThreadLocal<Choreographer> getThreadInstance();

        @Accessor(value="mLooper")
        public Looper getLooper();

        @Direct
        public void __constructor__(Looper var1);

        @Direct
        public void __constructor__(Looper var1, int var2, long var3);

        @Direct
        public void __constructor__(Looper var1, int var2);

        @Accessor(value="mFrameData")
        public Object getFrameData();

        @Accessor(value="mLastFrameIntervalNanos")
        public void setLastFrameIntervalNanos(long var1);

        @Accessor(value="mFrameInfo")
        public Object getFrameInfo();
    }

    @ForType(className="android.view.Choreographer$CallbackQueue")
    protected static interface CallbackQueueReflector {
        @Accessor(value="mHead")
        public void setHead(Object var1);
    }

    public static class Picker
    extends LooperShadowPicker<ShadowChoreographer> {
        public Picker() {
            super(ShadowLegacyChoreographer.class, ShadowPausedChoreographer.class);
        }
    }
}

