/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.os.Build;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Build.class)
public class ShadowBuild {
    private static String radioVersionOverride = null;
    private static String serialOverride = "unknown";

    public static void setBoard(String board) {
        ReflectionHelpers.setStaticField(Build.class, (String)"BOARD", (Object)board);
    }

    public static void setDevice(String device) {
        ReflectionHelpers.setStaticField(Build.class, (String)"DEVICE", (Object)device);
    }

    public static void setFingerprint(String fingerprint) {
        ReflectionHelpers.setStaticField(Build.class, (String)"FINGERPRINT", (Object)fingerprint);
    }

    public static void setId(String id) {
        ReflectionHelpers.setStaticField(Build.class, (String)"ID", (Object)id);
    }

    public static void setProduct(String product) {
        ReflectionHelpers.setStaticField(Build.class, (String)"PRODUCT", (Object)product);
    }

    public static void setDebuggable(Boolean isDebuggable) {
        ReflectionHelpers.setStaticField(Build.class, (String)"IS_DEBUGGABLE", (Object)isDebuggable);
    }

    public static void setModel(String model) {
        ReflectionHelpers.setStaticField(Build.class, (String)"MODEL", (Object)model);
    }

    public static void setManufacturer(String manufacturer) {
        ReflectionHelpers.setStaticField(Build.class, (String)"MANUFACTURER", (Object)manufacturer);
    }

    public static void setBrand(String brand) {
        ReflectionHelpers.setStaticField(Build.class, (String)"BRAND", (Object)brand);
    }

    public static void setHardware(String hardware) {
        ReflectionHelpers.setStaticField(Build.class, (String)"HARDWARE", (Object)hardware);
    }

    public static void setSerial(String serial) {
        serialOverride = serial;
    }

    public static void setVersionCodename(String versionCodename) {
        ReflectionHelpers.setStaticField(Build.VERSION.class, (String)"CODENAME", (Object)versionCodename);
    }

    public static void setVersionIncremental(String versionIncremental) {
        ReflectionHelpers.setStaticField(Build.VERSION.class, (String)"INCREMENTAL", (Object)versionIncremental);
    }

    @RequiresApi(value=31)
    public static void setVersionMediaPerformanceClass(int performanceClass) {
        ReflectionHelpers.setStaticField(Build.VERSION.class, (String)"MEDIA_PERFORMANCE_CLASS", (Object)performanceClass);
    }

    public static void setVersionRelease(String release) {
        ReflectionHelpers.setStaticField(Build.VERSION.class, (String)"RELEASE", (Object)release);
    }

    @RequiresApi(value=23)
    public static void setVersionSecurityPatch(String securityPatch) {
        ReflectionHelpers.setStaticField(Build.VERSION.class, (String)"SECURITY_PATCH", (Object)securityPatch);
    }

    public static void setTags(String tags) {
        ReflectionHelpers.setStaticField(Build.class, (String)"TAGS", (Object)tags);
    }

    public static void setType(String type) {
        ReflectionHelpers.setStaticField(Build.class, (String)"TYPE", (Object)type);
    }

    public static void setSupported32BitAbis(String[] supported32BitAbis) {
        ReflectionHelpers.setStaticField(Build.class, (String)"SUPPORTED_32_BIT_ABIS", (Object)supported32BitAbis);
    }

    public static void setSupported64BitAbis(String[] supported64BitAbis) {
        ReflectionHelpers.setStaticField(Build.class, (String)"SUPPORTED_64_BIT_ABIS", (Object)supported64BitAbis);
    }

    public static void setSupportedAbis(String[] supportedAbis) {
        ReflectionHelpers.setStaticField(Build.class, (String)"SUPPORTED_ABIS", (Object)supportedAbis);
    }

    public static void setRadioVersion(String radioVersion) {
        radioVersionOverride = radioVersion;
    }

    public static void setSystemOnChipManufacturer(String systemOnChipManufacturer) {
        ReflectionHelpers.setStaticField(Build.class, (String)"SOC_MANUFACTURER", (Object)systemOnChipManufacturer);
    }

    public static void setSystemOnChipModel(String systemOnChipModel) {
        ReflectionHelpers.setStaticField(Build.class, (String)"SOC_MODEL", (Object)systemOnChipModel);
    }

    public static void setOdmSku(String odmSku) {
        ((BuildReflector)Reflector.reflector(BuildReflector.class)).setOdmSku(odmSku);
    }

    public static void setSku(String sku) {
        ((BuildReflector)Reflector.reflector(BuildReflector.class)).setSku(sku);
    }

    @Implementation
    protected static String getRadioVersion() {
        if (radioVersionOverride != null) {
            return radioVersionOverride;
        }
        return ((BuildReflector)Reflector.reflector(BuildReflector.class)).getRadioVersion();
    }

    @Implementation(minSdk=26)
    protected static String getSerial() {
        return serialOverride;
    }

    @Resetter
    public static synchronized void reset() {
        radioVersionOverride = null;
        serialOverride = "unknown";
        ((BuildReflector)Reflector.reflector(BuildReflector.class)).__staticInitializer__();
        ((VersionReflector)Reflector.reflector(VersionReflector.class)).__staticInitializer__();
    }

    @ForType(value=Build.class)
    private static interface BuildReflector {
        @Static
        public void __staticInitializer__();

        @Static
        @Accessor(value="ODM_SKU")
        public void setOdmSku(String var1);

        @Static
        @Accessor(value="SKU")
        public void setSku(String var1);

        @Static
        @Direct
        public String getRadioVersion();
    }

    @ForType(value=Build.VERSION.class)
    private static interface VersionReflector {
        @Static
        public void __staticInitializer__();
    }
}

