/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BluetoothSocket.class)
public class ShadowBluetoothSocket {
    private final PipedOutputStream inputStreamFeeder = new PipedOutputStream();
    private final PipedInputStream outputStreamSink = new PipedInputStream();
    private OutputStream outputStream;
    private final InputStream inputStream;
    private final Semaphore connectSemaphore = new Semaphore(1);
    private final AtomicBoolean wasBlockRequested = new AtomicBoolean(false);
    private volatile SocketState state = SocketState.INIT;
    @Nullable
    private IOException connectExceptionOverride = null;

    public ShadowBluetoothSocket() {
        try {
            this.outputStream = new PipedOutputStream(this.outputStreamSink);
            this.inputStream = new PipedInputStream(this.inputStreamFeeder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOutputStream(PipedOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public PipedOutputStream getInputStreamFeeder() {
        return this.inputStreamFeeder;
    }

    public PipedInputStream getOutputStreamSink() {
        return this.outputStreamSink;
    }

    public void blockConnect() {
        if (!this.wasBlockRequested.compareAndSet(false, true)) {
            throw new IllegalStateException("blockConnect() was previously called");
        }
        this.acquireConnectSemaphore();
    }

    public void unblockConnect() {
        if (!this.wasBlockRequested.get()) {
            throw new IllegalStateException("blockConnect() was not called");
        }
        this.connectSemaphore.release();
    }

    public void setConnectException(IOException connectException) {
        this.connectExceptionOverride = connectException;
    }

    @Implementation
    protected InputStream getInputStream() {
        return this.inputStream;
    }

    @Implementation
    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Implementation
    protected boolean isConnected() {
        return this.state == SocketState.CONNECTED;
    }

    @Implementation
    protected void connect() throws IOException {
        this.throwIfClosed();
        this.state = SocketState.CONNECTED;
        this.acquireConnectSemaphore();
        this.connectSemaphore.release();
        this.throwIfClosed();
    }

    private void acquireConnectSemaphore() {
        try {
            this.connectSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for connect semaphore", e);
        }
    }

    private void throwIfClosed() throws IOException {
        if (this.state == SocketState.CLOSED) {
            if (this.connectExceptionOverride != null) {
                throw this.connectExceptionOverride;
            }
            throw new IOException("socket closed");
        }
    }

    @Implementation
    protected void close() throws IOException {
        this.state = SocketState.CLOSED;
        this.connectSemaphore.release();
    }

    static BluetoothSocket create(BluetoothDevice device) {
        BluetoothSocket newSocket = (BluetoothSocket)Shadow.newInstanceOf(BluetoothSocket.class);
        if (RuntimeEnvironment.getApiLevel() > 36 && ReflectionHelpers.hasField(BluetoothSocket.class, (String)"mRemoteDevice")) {
            ((BluetoothSocketReflector)Reflector.reflector(BluetoothSocketReflector.class, (Object)newSocket)).setRemoteDevice(Optional.of(device));
        } else {
            ((BluetoothSocketReflector)Reflector.reflector(BluetoothSocketReflector.class, (Object)newSocket)).setDevice(device);
        }
        return newSocket;
    }

    private static enum SocketState {
        INIT,
        CONNECTED,
        CLOSED;

    }

    @ForType(value=BluetoothSocket.class)
    private static interface BluetoothSocketReflector {
        @Accessor(value="mRemoteDevice")
        public void setRemoteDevice(Optional<BluetoothDevice> var1);

        @Accessor(value="mDevice")
        public void setDevice(BluetoothDevice var1);
    }
}

