/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothLeBroadcast;
import android.bluetooth.BluetoothLeBroadcastSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothLeBroadcast.class, minSdk=34, isInAndroidSdk=false)
public class ShadowBluetoothLeBroadcast {
    private final Map<BluetoothLeBroadcast.Callback, Executor> mCallbackExecutorMap = new HashMap<BluetoothLeBroadcast.Callback, Executor>();
    private final List<Integer> activeBroadcastIds = new ArrayList<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void registerCallback(Executor executor, BluetoothLeBroadcast.Callback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<BluetoothLeBroadcast.Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mCallbackExecutorMap.put(callback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void unregisterCallback(BluetoothLeBroadcast.Callback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<BluetoothLeBroadcast.Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.remove(callback) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
    }

    @Implementation
    protected void startBroadcast(BluetoothLeBroadcastSettings broadcastSettings) {
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (broadcastSettings == null) {
            this.sendOnBroadcastStartFailed(1201, this.mCallbackExecutorMap);
        } else {
            int broadcastId = this.activeBroadcastIds.size();
            this.activeBroadcastIds.add(broadcastId);
            this.sendOnBroadcastStarted(16, broadcastId, this.mCallbackExecutorMap);
        }
    }

    @Implementation
    protected void stopBroadcast(int broadcastId) {
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.activeBroadcastIds.contains(broadcastId)) {
            this.sendOnBroadcastStopFailed(1200, this.mCallbackExecutorMap);
        } else {
            this.activeBroadcastIds.remove((Object)broadcastId);
            this.sendOnBroadcastStopped(16, broadcastId, this.mCallbackExecutorMap);
        }
    }

    @Implementation
    protected void updateBroadcast(int broadcastId, BluetoothLeBroadcastSettings broadcastSettings) {
        Objects.requireNonNull(broadcastSettings, "broadcastSettings cannot be null");
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        if (!this.activeBroadcastIds.contains(broadcastId)) {
            this.sendOnBroadcastUpdateFailed(1200, broadcastId, this.mCallbackExecutorMap);
        } else {
            this.sendOnBroadcastUpdated(16, broadcastId, this.mCallbackExecutorMap);
        }
    }

    public Map<BluetoothLeBroadcast.Callback, Executor> getCallbackExecutorMap() {
        return this.mCallbackExecutorMap;
    }

    private void sendOnBroadcastStartFailed(int reason, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastStartFailed(reason));
        }
    }

    private void sendOnBroadcastStarted(int reason, int broadcastId, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastStarted(reason, broadcastId));
        }
    }

    private void sendOnBroadcastStopFailed(int reason, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastStopFailed(reason));
        }
    }

    private void sendOnBroadcastStopped(int reason, int broadcastId, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastStopped(reason, broadcastId));
        }
    }

    private void sendOnBroadcastUpdateFailed(int reason, int broadcastId, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastUpdateFailed(reason, broadcastId));
        }
    }

    private void sendOnBroadcastUpdated(int reason, int broadcastId, Map<BluetoothLeBroadcast.Callback, Executor> callbackExecutorMap) {
        for (Map.Entry<BluetoothLeBroadcast.Callback, Executor> entry : callbackExecutorMap.entrySet()) {
            BluetoothLeBroadcast.Callback callback = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> callback.onBroadcastUpdated(reason, broadcastId));
        }
    }
}

