/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowBinderBridge;

@Implements(value=Binder.class)
public class ShadowBinder {
    @RealObject
    Binder realObject;
    private static Integer callingUid;
    private static Integer callingPid;
    private static UserHandle callingUserHandle;
    private final List<WeakReference<IBinder.DeathRecipient>> deathRecipients = new ArrayList<WeakReference<IBinder.DeathRecipient>>();

    @Implementation
    protected boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        boolean result;
        block5: {
            if (data != null) {
                data.setDataPosition(0);
            }
            try {
                result = new ShadowBinderBridge(this.realObject).onTransact(code, data, reply, flags);
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (Exception e) {
                result = true;
                if (reply == null) break block5;
                reply.writeException(e);
            }
        }
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return result;
    }

    @Implementation
    protected void linkToDeath(IBinder.DeathRecipient deathRecipient, int flags) {
        this.deathRecipients.add(new WeakReference<IBinder.DeathRecipient>(deathRecipient));
    }

    @Implementation
    protected boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int flags) {
        WeakReference<IBinder.DeathRecipient> itemToRemove = null;
        for (WeakReference<IBinder.DeathRecipient> item : this.deathRecipients) {
            if (item.get() != deathRecipient) continue;
            itemToRemove = item;
            break;
        }
        if (itemToRemove != null) {
            this.deathRecipients.remove(itemToRemove);
            return true;
        }
        return false;
    }

    @Implementation
    protected static int getCallingPid() {
        if (callingPid != null) {
            return callingPid;
        }
        return Process.myPid();
    }

    @Implementation
    protected static int getCallingUid() {
        if (callingUid != null) {
            return callingUid;
        }
        return Process.myUid();
    }

    @Implementation(minSdk=29)
    protected static int getCallingUidOrThrow() {
        if (callingUid != null) {
            return callingUid;
        }
        throw new IllegalStateException("Thread is not in a binder transcation");
    }

    @Implementation
    protected static UserHandle getCallingUserHandle() {
        if (callingUserHandle != null) {
            return callingUserHandle;
        }
        return Process.myUserHandle();
    }

    public List<IBinder.DeathRecipient> getDeathRecipients() {
        return this.deathRecipients.stream().map(Reference::get).filter(Objects::nonNull).toList();
    }

    public static void setCallingPid(int pid) {
        callingPid = pid;
    }

    public static void setCallingUid(int uid) {
        callingUid = uid;
    }

    public static void setCallingUserHandle(UserHandle userHandle) {
        callingUserHandle = userHandle;
    }

    @Resetter
    public static void reset() {
        callingPid = null;
        callingUid = null;
        callingUserHandle = null;
    }
}

