/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.os.Build;
import android.telephony.CellIdentity;
import android.telephony.DataSpecificRegistrationInfo;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.VoiceSpecificRegistrationInfo;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=29)
public class NetworkRegistrationInfoTestBuilder {
    private final NetworkRegistrationInfo.Builder buider = new NetworkRegistrationInfo.Builder();
    private VoiceSpecificRegistrationInfo voiceSpecificInfo;
    private DataSpecificRegistrationInfo dataSpecificInfo;
    private int roamingType;

    public static NetworkRegistrationInfoTestBuilder newBuilder() {
        return new NetworkRegistrationInfoTestBuilder();
    }

    public NetworkRegistrationInfo build() {
        NetworkRegistrationInfo networkRegistrationInfo = this.buider.build();
        if (Build.VERSION.SDK_INT < 29) {
            throw new IllegalStateException("NetworkRegistrationInfo not available on SDK : " + RuntimeEnvironment.getApiLevel());
        }
        if (Build.VERSION.SDK_INT < 33) {
            ((NetworkRegistrationInfoReflector)Reflector.reflector(NetworkRegistrationInfoReflector.class, (Object)networkRegistrationInfo)).setVoiceSpecificInfo(this.voiceSpecificInfo);
            ((NetworkRegistrationInfoReflector)Reflector.reflector(NetworkRegistrationInfoReflector.class, (Object)networkRegistrationInfo)).setDataSpecificInfo(this.dataSpecificInfo);
        }
        networkRegistrationInfo.setRoamingType(this.roamingType);
        return networkRegistrationInfo;
    }

    public NetworkRegistrationInfoTestBuilder setAccessNetworkTechnology(int value) {
        this.buider.setAccessNetworkTechnology(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setAvailableServices(List<Integer> value) {
        this.buider.setAvailableServices(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setCellIdentity(CellIdentity value) {
        this.buider.setCellIdentity(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setDomain(int value) {
        this.buider.setDomain(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setEmergencyOnly(boolean value) {
        this.buider.setEmergencyOnly(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setRegisteredPlmn(String value) {
        if (Build.VERSION.SDK_INT == 29) {
            throw new IllegalStateException("Registered PLMN is not available on SDK : " + RuntimeEnvironment.getApiLevel());
        }
        this.buider.setRegisteredPlmn(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setRegistrationState(int value) {
        this.buider.setRegistrationState(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setRejectCause(int value) {
        this.buider.setRejectCause(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setTransportType(int value) {
        this.buider.setTransportType(value);
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setDataSpecificInfo(DataSpecificRegistrationInfo value) {
        if (Build.VERSION.SDK_INT >= 33) {
            this.buider.setDataSpecificInfo(value);
        } else {
            this.dataSpecificInfo = value;
        }
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setVoiceSpecificInfo(VoiceSpecificRegistrationInfo value) {
        if (Build.VERSION.SDK_INT >= 33) {
            this.buider.setVoiceSpecificInfo(value);
        } else {
            this.voiceSpecificInfo = value;
        }
        return this;
    }

    public NetworkRegistrationInfoTestBuilder setRoamingType(int value) {
        this.roamingType = value;
        return this;
    }

    @ForType(value=NetworkRegistrationInfo.class)
    private static interface NetworkRegistrationInfoReflector {
        @Accessor(value="mDataSpecificInfo")
        public void setDataSpecificInfo(DataSpecificRegistrationInfo var1);

        @Accessor(value="mVoiceSpecificInfo")
        public void setVoiceSpecificInfo(VoiceSpecificRegistrationInfo var1);
    }
}

