/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.fakes.RoboMenuItem;
import org.robolectric.fakes.RoboSubMenu;

public class RoboMenu
implements Menu {
    private final List<MenuItem> menuItems = new ArrayList<MenuItem>();
    private final Context context;

    public RoboMenu() {
        this((Context)RuntimeEnvironment.getApplication());
    }

    public RoboMenu(Context context) {
        this.context = context;
    }

    public MenuItem add(CharSequence title) {
        return this.add(0, 0, 0, title);
    }

    public MenuItem add(int titleRes) {
        return this.add(0, 0, 0, titleRes);
    }

    public MenuItem add(int groupId, int itemId, int order, CharSequence title) {
        RoboMenuItem menuItem = new RoboMenuItem(this.context);
        menuItem.setOrder(order);
        this.menuItems.add(menuItem);
        menuItem.setGroupId(groupId);
        Collections.sort(this.menuItems, new CustomMenuItemComparator());
        menuItem.setItemId(itemId);
        menuItem.setTitle(title);
        return menuItem;
    }

    public MenuItem add(int groupId, int itemId, int order, int titleRes) {
        return this.add(groupId, itemId, order, this.context.getResources().getString(titleRes));
    }

    public SubMenu addSubMenu(CharSequence title) {
        RoboSubMenu tsm = new RoboSubMenu(this.context);
        RoboMenuItem menuItem = new RoboMenuItem(this.context);
        this.menuItems.add(menuItem);
        menuItem.setTitle(title);
        menuItem.setSubMenu(tsm);
        return tsm;
    }

    public SubMenu addSubMenu(int titleRes) {
        RoboSubMenu tsm = new RoboSubMenu(this.context);
        RoboMenuItem menuItem = new RoboMenuItem(this.context);
        this.menuItems.add(menuItem);
        menuItem.setTitle(titleRes);
        menuItem.setSubMenu(tsm);
        return tsm;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, CharSequence title) {
        RoboSubMenu tsm = new RoboSubMenu(this.context);
        RoboMenuItem menuItem = new RoboMenuItem(this.context);
        this.menuItems.add(menuItem);
        menuItem.setGroupId(groupId);
        menuItem.setItemId(itemId);
        menuItem.setTitle(title);
        menuItem.setSubMenu(tsm);
        return tsm;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        RoboSubMenu tsm = new RoboSubMenu(this.context);
        RoboMenuItem menuItem = new RoboMenuItem(this.context);
        this.menuItems.add(menuItem);
        menuItem.setGroupId(groupId);
        menuItem.setItemId(itemId);
        menuItem.setTitle(titleRes);
        menuItem.setSubMenu(tsm);
        return tsm;
    }

    public int addIntentOptions(int groupId, int itemId, int order, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        return 0;
    }

    public void removeItem(int id2) {
        MenuItem menuItem = this.findItem(id2);
        this.menuItems.remove(menuItem);
    }

    public void removeGroup(int groupId) {
    }

    public void clear() {
        this.menuItems.clear();
    }

    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
    }

    public void setGroupVisible(int group, boolean visible) {
    }

    public void setGroupEnabled(int group, boolean enabled) {
    }

    public boolean hasVisibleItems() {
        return false;
    }

    public MenuItem findItem(int id2) {
        for (MenuItem item : this.menuItems) {
            if (item.getItemId() != id2) continue;
            return item;
        }
        return null;
    }

    public int size() {
        return this.menuItems.size();
    }

    public MenuItem getItem(int index) {
        return this.menuItems.get(index);
    }

    public void close() {
    }

    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        return false;
    }

    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean performIdentifierAction(int id2, int flags) {
        return false;
    }

    public void setQwertyMode(boolean isQwerty) {
    }

    public RoboMenuItem findMenuItem(CharSequence title) {
        for (int i = 0; i < this.size(); ++i) {
            RoboMenuItem menuItem = (RoboMenuItem)this.getItem(i);
            if (!menuItem.getTitle().equals(title)) continue;
            return menuItem;
        }
        return null;
    }

    public RoboMenuItem findMenuItemContaining(CharSequence desiredText) {
        for (int i = 0; i < this.size(); ++i) {
            RoboMenuItem menuItem = (RoboMenuItem)this.getItem(i);
            if (!menuItem.getTitle().toString().contains(desiredText)) continue;
            return menuItem;
        }
        return null;
    }

    private static class CustomMenuItemComparator
    implements Comparator<MenuItem> {
        private CustomMenuItemComparator() {
        }

        @Override
        public int compare(MenuItem a, MenuItem b) {
            return Integer.compare(a.getOrder(), b.getOrder());
        }
    }
}

