/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android;

import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.android.DeviceConfig;
import org.robolectric.res.Qualifiers;
import org.robolectric.shadows.ShadowDateUtils;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.shadows.ShadowDisplayManagerGlobal;

public class Bootstrap {
    private static final Pattern VERSION_QUALIFIER_PATTERN = Pattern.compile("(v)([0-9]+)$");
    private static Configuration configuration = new Configuration();
    private static DisplayMetrics displayMetrics = new DisplayMetrics();
    private static Resources displayResources;
    public static boolean displaySet;

    public static Configuration getConfiguration() {
        if (displayResources != null) {
            return displayResources.getConfiguration();
        }
        return configuration;
    }

    public static DisplayMetrics getDisplayMetrics() {
        if (displayResources != null) {
            return displayResources.getDisplayMetrics();
        }
        return displayMetrics;
    }

    public static void setDisplayConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        Bootstrap.configuration = configuration;
        Bootstrap.displayMetrics = displayMetrics;
    }

    public static void resetDisplayConfiguration() {
        ShadowDisplayManagerGlobal.reset();
        configuration = new Configuration();
        displayMetrics = new DisplayMetrics();
        displayResources = null;
        displaySet = false;
    }

    public static void updateDisplayResources(Configuration configuration, DisplayMetrics displayMetrics) {
        if (displayResources == null) {
            displayResources = new Resources(AssetManager.getSystem(), Bootstrap.displayMetrics, Bootstrap.configuration);
        }
        displayResources.updateConfiguration(configuration, displayMetrics);
    }

    public static void setUpDisplay() {
        if (!displaySet) {
            displaySet = true;
            ShadowDisplayManager.configureDefaultDisplay(configuration, displayMetrics);
        }
    }

    public static void applyQualifiers(String qualifiersStrs, int apiLevel, Configuration configuration, DisplayMetrics displayMetrics) {
        String qualifiersStr;
        int i;
        String[] qualifiersParts = qualifiersStrs.split(" ", 0);
        for (i = qualifiersParts.length - 1; i >= 0 && (qualifiersStr = qualifiersParts[i]).startsWith("+"); --i) {
            qualifiersParts[i] = qualifiersStr.substring(1);
        }
        for (i = Math.max(i, 0); i < qualifiersParts.length; ++i) {
            qualifiersStr = qualifiersParts[i];
            int platformVersion = Bootstrap.getPlatformVersion(qualifiersStr);
            if (platformVersion != -1 && platformVersion != apiLevel) {
                throw new IllegalArgumentException("Cannot specify conflicting platform version in qualifiers: \"" + qualifiersStr + "\"");
            }
            Qualifiers qualifiers = Qualifiers.parse((String)qualifiersStr);
            DeviceConfig.applyToConfiguration(qualifiers, apiLevel, configuration, displayMetrics);
        }
        DeviceConfig.applyRules(configuration, displayMetrics, apiLevel);
        ShadowDateUtils.resetLastConfig();
    }

    private static int getPlatformVersion(String qualifiers) {
        Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifiers);
        if (m.find()) {
            return Integer.parseInt(m.group(2));
        }
        return -1;
    }

    static {
        displaySet = false;
    }
}

