/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Handler;
import android.os.Looper;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WifiP2pManager.class)
public class ShadowWifiP2pManager {
    private static final int NO_FAILURE = -1;
    private int listeningChannel;
    private int operatingChannel;
    private WifiP2pManager.GroupInfoListener groupInfoListener;
    private Handler handler;
    private int nextActionFailure = -1;
    private Map<WifiP2pManager.Channel, WifiP2pGroup> p2pGroupmap = new HashMap<WifiP2pManager.Channel, WifiP2pGroup>();

    public int getListeningChannel() {
        return this.listeningChannel;
    }

    public int getOperatingChannel() {
        return this.operatingChannel;
    }

    public WifiP2pManager.GroupInfoListener getGroupInfoListener() {
        return this.groupInfoListener;
    }

    @Implementation
    protected void setWifiP2pChannels(WifiP2pManager.Channel c, int listeningChannel, int operatingChannel, WifiP2pManager.ActionListener al) {
        Preconditions.checkNotNull((Object)c);
        Preconditions.checkNotNull((Object)al);
        this.listeningChannel = listeningChannel;
        this.operatingChannel = operatingChannel;
    }

    @Implementation
    protected WifiP2pManager.Channel initialize(Context context, Looper looper, WifiP2pManager.ChannelListener listener) {
        this.handler = new Handler(looper);
        return (WifiP2pManager.Channel)ReflectionHelpers.newInstance(WifiP2pManager.Channel.class);
    }

    @Implementation
    protected void createGroup(WifiP2pManager.Channel c, WifiP2pManager.ActionListener al) {
        this.postActionListener(al);
    }

    private void postActionListener(final WifiP2pManager.ActionListener al) {
        if (al == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (ShadowWifiP2pManager.this.nextActionFailure == -1) {
                    al.onSuccess();
                } else {
                    al.onFailure(ShadowWifiP2pManager.this.nextActionFailure);
                }
                ShadowWifiP2pManager.this.nextActionFailure = -1;
            }
        });
    }

    @Implementation
    protected void requestGroupInfo(final WifiP2pManager.Channel c, final WifiP2pManager.GroupInfoListener gl) {
        if (gl == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                gl.onGroupInfoAvailable((WifiP2pGroup)ShadowWifiP2pManager.this.p2pGroupmap.get(c));
            }
        });
    }

    @Implementation
    protected void removeGroup(WifiP2pManager.Channel c, WifiP2pManager.ActionListener al) {
        this.postActionListener(al);
    }

    public void setNextActionFailure(int nextActionFailure) {
        this.nextActionFailure = nextActionFailure;
    }

    public void setGroupInfo(WifiP2pManager.Channel channel, WifiP2pGroup wifiP2pGroup) {
        this.p2pGroupmap.put(channel, wifiP2pGroup);
    }
}

