/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.HandlerActionQueue;
import android.view.InsetsState;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.window.ClientWindowFrames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.annotation.TextLayoutMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowSurfaceControl;
import org.robolectric.shadows.ShadowWindowManagerGlobal;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=ViewRootImpl.class, isInAndroidSdk=false)
public class ShadowViewRootImpl {
    private static final int RELAYOUT_RES_IN_TOUCH_MODE = 1;
    @RealObject
    protected ViewRootImpl realObject;
    private static Optional<Boolean> isStatusBarVisible = Optional.empty();
    private static Optional<Boolean> isNavigationBarVisible = Optional.empty();

    protected static void setIsStatusBarVisible(boolean isStatusBarVisible) {
        ShadowViewRootImpl.isStatusBarVisible = Optional.of(isStatusBarVisible);
    }

    protected static void clearIsStatusBarVisible() {
        isStatusBarVisible = Optional.empty();
    }

    protected static void setIsNavigationBarVisible(boolean isNavigationBarVisible) {
        ShadowViewRootImpl.isNavigationBarVisible = Optional.of(isNavigationBarVisible);
    }

    protected static void clearIsNavigationBarVisible() {
        isNavigationBarVisible = Optional.empty();
    }

    @Implementation
    public void playSoundEffect(int effectId) {
    }

    @Implementation
    protected int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        int result = 0;
        if (ShadowWindowManagerGlobal.getInTouchMode() && RuntimeEnvironment.getApiLevel() <= 32) {
            result |= 1;
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            SurfaceControl surfaceControl = ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getSurfaceControl();
            ShadowSurfaceControl shadowSurfaceControl = (ShadowSurfaceControl)Shadow.extract((Object)surfaceControl);
            shadowSurfaceControl.initializeNativeObject();
        }
        return result;
    }

    public void callDispatchResized() {
        Optional activityWindowInfoClass = ReflectionHelpers.attemptLoadClass((ClassLoader)this.getClass().getClassLoader(), (String)"android.window.ActivityWindowInfo");
        if (RuntimeEnvironment.getApiLevel() > 34 && activityWindowInfoClass.isPresent()) {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            ClientWindowFrames frames = new ClientWindowFrames();
            ReflectionHelpers.setField((Object)frames, (String)"frame", (Object)frame);
            ReflectionHelpers.ClassParameter[] parameters = new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ClientWindowFrames.class, (Object)frames), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(MergedConfiguration.class, (Object)new MergedConfiguration()), ReflectionHelpers.ClassParameter.from(InsetsState.class, (Object)new InsetsState()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from((Class)((Class)activityWindowInfoClass.get()), (Object)ReflectionHelpers.newInstance((Class)((Class)activityWindowInfoClass.get())))};
            try {
                ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])parameters);
            }
            catch (RuntimeException ex) {
                ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])Arrays.copyOfRange(parameters, 0, parameters.length - 1));
            }
        } else if (RuntimeEnvironment.getApiLevel() > 33) {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            ClientWindowFrames frames = new ClientWindowFrames();
            ReflectionHelpers.setField((Object)frames, (String)"frame", (Object)frame);
            ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ClientWindowFrames.class, (Object)frames), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(MergedConfiguration.class, (Object)new MergedConfiguration()), ReflectionHelpers.ClassParameter.from(InsetsState.class, (Object)new InsetsState()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
        } else if (RuntimeEnvironment.getApiLevel() > 32) {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            ClientWindowFrames frames = new ClientWindowFrames();
            ReflectionHelpers.setField((Object)frames, (String)"frame", (Object)frame);
            ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ClientWindowFrames.class, (Object)frames), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(MergedConfiguration.class, (Object)new MergedConfiguration()), ReflectionHelpers.ClassParameter.from(InsetsState.class, (Object)new InsetsState()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        } else if (RuntimeEnvironment.getApiLevel() > 30) {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            ClientWindowFrames frames = new ClientWindowFrames();
            ReflectionHelpers.setField((Object)frames, (String)"frame", (Object)frame);
            ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ClientWindowFrames.class, (Object)frames), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(MergedConfiguration.class, (Object)new MergedConfiguration()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        } else if (RuntimeEnvironment.getApiLevel() > 29) {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            Rect emptyRect = new Rect(0, 0, 0, 0);
            ReflectionHelpers.callInstanceMethod(ViewRootImpl.class, (Object)this.realObject, (String)"dispatchResized", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Rect.class, (Object)frame), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)emptyRect), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)emptyRect), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)emptyRect), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(MergedConfiguration.class, (Object)new MergedConfiguration()), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)frame), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(DisplayCutout.ParcelableWrapper.class, (Object)new DisplayCutout.ParcelableWrapper())});
        } else {
            Display display = this.getDisplay();
            Rect frame = new Rect();
            display.getRectSize(frame);
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).dispatchResized(frame);
        }
    }

    protected Display getDisplay() {
        return ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getDisplay();
    }

    @Implementation
    protected void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).setView(view, attrs, panelParentView);
        if (ConfigurationRegistry.get(TextLayoutMode.Mode.class) == TextLayoutMode.Mode.REALISTIC) {
            Rect winFrame = new Rect();
            this.getDisplay().getRectSize(winFrame);
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).setWinFrame(winFrame);
        }
    }

    @Implementation(minSdk=30)
    protected void setView(View view, WindowManager.LayoutParams attrs, View panelParentView, int userId) {
        ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).setView(view, attrs, panelParentView, userId);
        if (ConfigurationRegistry.get(TextLayoutMode.Mode.class) == TextLayoutMode.Mode.REALISTIC) {
            Rect winFrame = new Rect();
            this.getDisplay().getRectSize(winFrame);
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).setWinFrame(winFrame);
        }
    }

    @Implementation(minSdk=30)
    protected WindowInsets getWindowInsets(boolean forceConstruct) {
        WindowInsets realInsets = ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getWindowInsets(forceConstruct);
        WindowInsets.Builder overridenInsetsBuilder = new WindowInsets.Builder(realInsets);
        if (isStatusBarVisible.isPresent()) {
            overridenInsetsBuilder = overridenInsetsBuilder.setVisible(WindowInsets.Type.statusBars(), isStatusBarVisible.get().booleanValue());
        }
        if (isNavigationBarVisible.isPresent()) {
            overridenInsetsBuilder = overridenInsetsBuilder.setVisible(WindowInsets.Type.navigationBars(), isNavigationBarVisible.get().booleanValue());
        }
        return overridenInsetsBuilder.build();
    }

    @Resetter
    public static void reset() {
        ViewRootImplReflector viewRootImplStatic = (ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class);
        viewRootImplStatic.setRunQueues(new ThreadLocal<HandlerActionQueue>());
        viewRootImplStatic.setFirstDrawHandlers(new ArrayList<Runnable>());
        viewRootImplStatic.setFirstDrawComplete(false);
        viewRootImplStatic.setConfigCallbacks(new ArrayList<ViewRootImpl.ConfigChangedCallback>());
        ShadowViewRootImpl.clearIsStatusBarVisible();
        ShadowViewRootImpl.clearIsNavigationBarVisible();
    }

    public void callWindowFocusChanged(boolean hasFocus) {
        if (RuntimeEnvironment.getApiLevel() <= 32) {
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).windowFocusChanged(hasFocus, ShadowWindowManagerGlobal.getInTouchMode());
        } else {
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).windowFocusChanged(hasFocus);
        }
    }

    Surface getSurface() {
        return ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getSurface();
    }

    @ForType(value=ViewRootImpl.class)
    protected static interface ViewRootImplReflector {
        @Direct
        public void setView(View var1, WindowManager.LayoutParams var2, View var3);

        @Direct
        public void setView(View var1, WindowManager.LayoutParams var2, View var3, int var4);

        @Static
        @Accessor(value="sRunQueues")
        public void setRunQueues(ThreadLocal<HandlerActionQueue> var1);

        @Static
        @Accessor(value="sFirstDrawHandlers")
        public void setFirstDrawHandlers(ArrayList<Runnable> var1);

        @Static
        @Accessor(value="sFirstDrawComplete")
        public void setFirstDrawComplete(boolean var1);

        @Static
        @Accessor(value="sConfigCallbacks")
        public void setConfigCallbacks(ArrayList<ViewRootImpl.ConfigChangedCallback> var1);

        @Accessor(value="sNewInsetsMode")
        @Static
        public int getNewInsetsMode();

        @Accessor(value="mWinFrame")
        public void setWinFrame(Rect var1);

        @Accessor(value="mDisplay")
        public Display getDisplay();

        @Accessor(value="mSurfaceControl")
        public SurfaceControl getSurfaceControl();

        @Accessor(value="mSurface")
        public Surface getSurface();

        @Accessor(value="mWindowAttributes")
        public WindowManager.LayoutParams getWindowAttributes();

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, boolean var6, Configuration var7);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, Configuration var8);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, Configuration var8, Rect var9, boolean var10, boolean var11);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, @WithType(value="android.util.MergedConfiguration") Object var8, Rect var9, boolean var10, boolean var11, int var12);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, @WithType(value="android.util.MergedConfiguration") Object var8, Rect var9, boolean var10, boolean var11, int var12, @WithType(value="android.view.DisplayCutout$ParcelableWrapper") Object var13);

        default public void dispatchResized(Rect frame) {
            Rect emptyRect = new Rect(0, 0, 0, 0);
            int apiLevel = RuntimeEnvironment.getApiLevel();
            if (apiLevel <= 22) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 23) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 25) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, null, frame, false, false);
            } else if (apiLevel <= 27) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, new MergedConfiguration(), frame, false, false, 0);
            } else {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, new MergedConfiguration(), frame, false, false, 0, new DisplayCutout.ParcelableWrapper());
            }
        }

        public void windowFocusChanged(boolean var1, boolean var2);

        public void windowFocusChanged(boolean var1);

        @Direct
        public WindowInsets getWindowInsets(boolean var1);
    }
}

