/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;

@Implements(value=VMRuntime.class, isInAndroidSdk=false)
public class ShadowVMRuntime {
    private final NativeObjRegistry<WeakReference<Object>> nativeObjRegistry = new NativeObjRegistry("VRRuntime.nativeObjectRegistry");
    private static boolean is64Bit = true;
    @Nullable
    private static String currentInstructionSet = null;

    @Implementation
    public Object newUnpaddedArray(Class<?> klass, int size) {
        return Array.newInstance(klass, size);
    }

    @Implementation
    public Object newNonMovableArray(Class<?> type, int size) {
        if (type.equals(Integer.TYPE)) {
            return new int[size];
        }
        return null;
    }

    @Implementation
    public long addressOf(Object obj) {
        return this.nativeObjRegistry.register(new WeakReference<Object>(obj));
    }

    @Nullable
    public Object getObjectForAddress(long address) {
        return ((WeakReference)this.nativeObjRegistry.getNativeObject(address)).get();
    }

    @Implementation
    protected boolean is64Bit() {
        return is64Bit;
    }

    public static void setIs64Bit(boolean is64Bit) {
        ShadowVMRuntime.is64Bit = is64Bit;
    }

    @Implementation
    protected static String getCurrentInstructionSet() {
        return currentInstructionSet;
    }

    public static void setCurrentInstructionSet(@Nullable String currentInstructionSet) {
        ShadowVMRuntime.currentInstructionSet = currentInstructionSet;
    }

    @Resetter
    public static void reset() {
        is64Bit = true;
        currentInstructionSet = null;
    }

    @Implementation(minSdk=29)
    protected static int getNotifyNativeInterval() {
        return 384;
    }
}

