/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SubscriptionManager.class, minSdk=22)
public class ShadowSubscriptionManager {
    private boolean readPhoneStatePermission = true;
    private boolean readPhoneNumbersPermission = true;
    public static final int INVALID_PHONE_INDEX = (Integer)ReflectionHelpers.getStaticField(SubscriptionManager.class, (String)"INVALID_PHONE_INDEX");
    private static int activeDataSubscriptionId = -1;
    private static int defaultSubscriptionId = -1;
    private static int defaultDataSubscriptionId = -1;
    private static int defaultSmsSubscriptionId = -1;
    private static int defaultVoiceSubscriptionId = -1;
    private final Map<Integer, String> phoneNumberMap = new HashMap<Integer, String>();
    private static Map<Integer, Integer> phoneIds = new HashMap<Integer, Integer>();
    private List<SubscriptionInfo> subscriptionList = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionInfo> accessibleSubscriptionList = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionInfo> availableSubscriptionList = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionManager.OnSubscriptionsChangedListener> listeners = new ArrayList<SubscriptionManager.OnSubscriptionsChangedListener>();
    private Set<Integer> roamingSimSubscriptionIds = new HashSet<Integer>();

    @Implementation(minSdk=30)
    protected static int getActiveDataSubscriptionId() {
        return activeDataSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultSubscriptionId() {
        return defaultSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultDataSubscriptionId() {
        return defaultDataSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultSmsSubscriptionId() {
        return defaultSmsSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultVoiceSubscriptionId() {
        return defaultVoiceSubscriptionId;
    }

    @Implementation(maxSdk=23)
    @HiddenApi
    protected static int getDefaultSubId() {
        return defaultSubscriptionId;
    }

    @Implementation(maxSdk=23)
    @HiddenApi
    protected static int getDefaultVoiceSubId() {
        return defaultVoiceSubscriptionId;
    }

    @Implementation(maxSdk=23)
    @HiddenApi
    protected static int getDefaultSmsSubId() {
        return defaultSmsSubscriptionId;
    }

    @Implementation(maxSdk=23)
    @HiddenApi
    protected static int getDefaultDataSubId() {
        return defaultDataSubscriptionId;
    }

    public static void setActiveDataSubscriptionId(int activeDataSubscriptionId) {
        ShadowSubscriptionManager.activeDataSubscriptionId = activeDataSubscriptionId;
    }

    public static void setDefaultSubscriptionId(int defaultSubscriptionId) {
        ShadowSubscriptionManager.defaultSubscriptionId = defaultSubscriptionId;
    }

    public static void setDefaultDataSubscriptionId(int defaultDataSubscriptionId) {
        ShadowSubscriptionManager.defaultDataSubscriptionId = defaultDataSubscriptionId;
    }

    public static void setDefaultSmsSubscriptionId(int defaultSmsSubscriptionId) {
        ShadowSubscriptionManager.defaultSmsSubscriptionId = defaultSmsSubscriptionId;
    }

    public static void setDefaultVoiceSubscriptionId(int defaultVoiceSubscriptionId) {
        ShadowSubscriptionManager.defaultVoiceSubscriptionId = defaultVoiceSubscriptionId;
    }

    @Implementation(minSdk=22)
    protected List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        this.checkReadPhoneStatePermission();
        return this.subscriptionList;
    }

    @Implementation(minSdk=27)
    protected List<SubscriptionInfo> getAccessibleSubscriptionInfoList() {
        return this.accessibleSubscriptionList;
    }

    @Implementation(minSdk=27)
    protected List<SubscriptionInfo> getAvailableSubscriptionInfoList() {
        return this.availableSubscriptionList;
    }

    @Implementation(minSdk=22)
    protected int getActiveSubscriptionInfoCount() {
        this.checkReadPhoneStatePermission();
        return this.subscriptionList == null ? 0 : this.subscriptionList.size();
    }

    @Implementation(minSdk=22)
    protected SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        this.checkReadPhoneStatePermission();
        if (this.subscriptionList == null) {
            return null;
        }
        for (SubscriptionInfo info : this.subscriptionList) {
            if (info.getSubscriptionId() != subId) continue;
            return info;
        }
        return null;
    }

    @Implementation(minSdk=22)
    protected int getActiveSubscriptionInfoCountMax() {
        List<SubscriptionInfo> infoList = this.getActiveSubscriptionInfoList();
        if (infoList == null) {
            return this.getActiveSubscriptionInfoCount();
        }
        return Math.max(this.getActiveSubscriptionInfoList().size(), this.getActiveSubscriptionInfoCount());
    }

    @Implementation(minSdk=24)
    protected SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        this.checkReadPhoneStatePermission();
        if (this.subscriptionList == null) {
            return null;
        }
        for (SubscriptionInfo info : this.subscriptionList) {
            if (info.getSimSlotIndex() != slotIndex) continue;
            return info;
        }
        return null;
    }

    public void setActiveSubscriptionInfoList(List<SubscriptionInfo> list) {
        this.subscriptionList = list;
        this.dispatchOnSubscriptionsChanged();
    }

    public void setAccessibleSubscriptionInfoList(List<SubscriptionInfo> list) {
        this.accessibleSubscriptionList = list;
        this.dispatchOnSubscriptionsChanged();
    }

    public void setAvailableSubscriptionInfoList(List<SubscriptionInfo> list) {
        this.availableSubscriptionList = list;
        this.dispatchOnSubscriptionsChanged();
    }

    public void setActiveSubscriptionInfos(SubscriptionInfo ... infos) {
        if (infos == null) {
            this.setActiveSubscriptionInfoList((List<SubscriptionInfo>)ImmutableList.of());
        } else {
            this.setActiveSubscriptionInfoList(Arrays.asList(infos));
        }
    }

    public void setAccessibleSubscriptionInfos(SubscriptionInfo ... infos) {
        if (infos == null) {
            this.setAccessibleSubscriptionInfoList((List<SubscriptionInfo>)ImmutableList.of());
        } else {
            this.setAccessibleSubscriptionInfoList(Arrays.asList(infos));
        }
    }

    public void setAvailableSubscriptionInfos(SubscriptionInfo ... infos) {
        if (infos == null) {
            this.setAvailableSubscriptionInfoList((List<SubscriptionInfo>)ImmutableList.of());
        } else {
            this.setAvailableSubscriptionInfoList(Arrays.asList(infos));
        }
    }

    @Implementation(minSdk=22)
    protected void addOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        this.listeners.add(listener);
        listener.onSubscriptionsChanged();
    }

    @Implementation(minSdk=30)
    protected void addOnSubscriptionsChangedListener(Executor executor, SubscriptionManager.OnSubscriptionsChangedListener listener) {
        this.listeners.add(listener);
        listener.onSubscriptionsChanged();
    }

    @Implementation(minSdk=22)
    protected void removeOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        return this.listeners.contains(listener);
    }

    @Implementation(minSdk=22)
    @HiddenApi
    protected int[] getActiveSubscriptionIdList() {
        List<SubscriptionInfo> infos = this.getActiveSubscriptionInfoList();
        if (infos == null) {
            return new int[0];
        }
        int[] ids = new int[infos.size()];
        for (int i = 0; i < infos.size(); ++i) {
            ids[i] = infos.get(i).getSubscriptionId();
        }
        return ids;
    }

    private void dispatchOnSubscriptionsChanged() {
        for (SubscriptionManager.OnSubscriptionsChangedListener listener : this.listeners) {
            listener.onSubscriptionsChanged();
        }
    }

    public void clearNetworkRoamingStatus() {
        this.roamingSimSubscriptionIds.clear();
    }

    public void setNetworkRoamingStatus(int simSubscriptionId, boolean isNetworkRoaming) {
        if (isNetworkRoaming) {
            this.roamingSimSubscriptionIds.add(simSubscriptionId);
        } else {
            this.roamingSimSubscriptionIds.remove(simSubscriptionId);
        }
    }

    @Implementation(minSdk=22)
    protected boolean isNetworkRoaming(int simSubscriptionId) {
        return this.roamingSimSubscriptionIds.contains(simSubscriptionId);
    }

    public static void putPhoneId(int subId, int phoneId) {
        phoneIds.put(subId, phoneId);
    }

    public static Integer removePhoneId(int subId) {
        return phoneIds.remove(subId);
    }

    public static void clearPhoneIds() {
        phoneIds.clear();
    }

    @Implementation(minSdk=22, maxSdk=28)
    @HiddenApi
    protected static int getPhoneId(int subId) {
        if (phoneIds.containsKey(subId)) {
            return phoneIds.get(subId);
        }
        return INVALID_PHONE_INDEX;
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        this.readPhoneStatePermission = readPhoneStatePermission;
    }

    private void checkReadPhoneStatePermission() {
        if (!this.readPhoneStatePermission) {
            throw new SecurityException();
        }
    }

    public void setReadPhoneNumbersPermission(boolean readPhoneNumbersPermission) {
        this.readPhoneNumbersPermission = readPhoneNumbersPermission;
    }

    private void checkReadPhoneNumbersPermission() {
        if (!this.readPhoneNumbersPermission) {
            throw new SecurityException();
        }
    }

    @Implementation(minSdk=33)
    protected String getPhoneNumber(int subscriptionId) {
        this.checkReadPhoneNumbersPermission();
        return this.phoneNumberMap.getOrDefault(subscriptionId, "");
    }

    @Implementation(minSdk=33)
    protected String getPhoneNumber(int subscriptionId, int source) {
        return this.getPhoneNumber(subscriptionId);
    }

    public void setPhoneNumber(int subscriptionId, String phoneNumber) {
        this.phoneNumberMap.put(subscriptionId, phoneNumber);
    }

    @Resetter
    public static void reset() {
        activeDataSubscriptionId = -1;
        defaultDataSubscriptionId = -1;
        defaultSmsSubscriptionId = -1;
        defaultVoiceSubscriptionId = -1;
        defaultSubscriptionId = -1;
        phoneIds.clear();
    }

    public static class SubscriptionInfoBuilder {
        private final SubscriptionInfo subscriptionInfo = (SubscriptionInfo)ReflectionHelpers.callConstructor(SubscriptionInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);

        public static SubscriptionInfoBuilder newBuilder() {
            return new SubscriptionInfoBuilder();
        }

        public SubscriptionInfo buildSubscriptionInfo() {
            return this.subscriptionInfo;
        }

        public SubscriptionInfoBuilder setId(int id2) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mId", (Object)id2);
            return this;
        }

        public SubscriptionInfoBuilder setIccId(String iccId) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIccId", (Object)iccId);
            return this;
        }

        public SubscriptionInfoBuilder setSimSlotIndex(int index) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mSimSlotIndex", (Object)index);
            return this;
        }

        public SubscriptionInfoBuilder setDisplayName(String name) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mDisplayName", (Object)name);
            return this;
        }

        public SubscriptionInfoBuilder setCarrierName(String carrierName) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mCarrierName", (Object)carrierName);
            return this;
        }

        public SubscriptionInfoBuilder setIconTint(int iconTint) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIconTint", (Object)iconTint);
            return this;
        }

        public SubscriptionInfoBuilder setNumber(String number) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mNumber", (Object)number);
            return this;
        }

        public SubscriptionInfoBuilder setDataRoaming(int dataRoaming) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mDataRoaming", (Object)dataRoaming);
            return this;
        }

        public SubscriptionInfoBuilder setCountryIso(String countryIso) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mCountryIso", (Object)countryIso);
            return this;
        }

        public SubscriptionInfoBuilder setProfileClass(int profileClass) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mProfileClass", (Object)profileClass);
            return this;
        }

        public SubscriptionInfoBuilder setIsEmbedded(boolean isEmbedded) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIsEmbedded", (Object)isEmbedded);
            return this;
        }

        public SubscriptionInfoBuilder setIsOpportunistic(boolean isOpportunistic) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIsOpportunistic", (Object)isOpportunistic);
            return this;
        }

        public SubscriptionInfoBuilder setMnc(String mnc) {
            if (Build.VERSION.SDK_INT < 29) {
                ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mMnc", (Object)Integer.valueOf(mnc));
            } else {
                ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mMnc", (Object)mnc);
            }
            return this;
        }

        public SubscriptionInfoBuilder setMcc(String mcc) {
            if (Build.VERSION.SDK_INT < 29) {
                ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mMcc", (Object)Integer.valueOf(mcc));
            } else {
                ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mMcc", (Object)mcc);
            }
            return this;
        }

        private SubscriptionInfoBuilder() {
        }
    }
}

