/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.provider.Settings;
import android.view.accessibility.CaptioningManager;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CaptioningManager.class)
public class ShadowCaptioningManager {
    @RealObject
    private CaptioningManager realCaptioningManager;

    @Implementation(minSdk=33)
    protected void setSystemAudioCaptioningEnabled(boolean isEnabled) {
        Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"odi_captions_enabled", (int)(isEnabled ? 1 : 0));
    }

    @Implementation(minSdk=33)
    protected void setSystemAudioCaptioningUiEnabled(boolean isEnabled) {
        Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"odi_captions_volume_ui_enabled", (int)(isEnabled ? 1 : 0));
    }

    @Implementation(minSdk=33)
    protected boolean isSystemAudioCaptioningUiEnabled() {
        return Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"odi_captions_volume_ui_enabled", (int)1) == 1;
    }

    private ContentResolver getContentResolver() {
        return ((CaptioningManagerReflector)Reflector.reflector(CaptioningManagerReflector.class, (Object)this.realCaptioningManager)).getContentResolver();
    }

    @ForType(value=CaptioningManager.class)
    static interface CaptioningManagerReflector {
        @Accessor(value="mContentResolver")
        public ContentResolver getContentResolver();
    }
}

