/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.util.TypedValue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.shadows.ShadowLegacyBitmap;
import org.robolectric.util.Join;
import org.robolectric.util.Logger;
import org.robolectric.util.NamedStream;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=BitmapFactory.class)
public class ShadowBitmapFactory {
    private static Map<String, Point> widthAndHeightMap = new HashMap<String, Point>();
    private static boolean allowInvalidImageData = true;

    @Implementation
    protected static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        Bitmap bitmap = ((BitmapFactoryReflector)Reflector.reflector(BitmapFactoryReflector.class)).decodeResourceStream(res, value, is, pad, opts);
        if (value != null && value.string != null && value.string.toString().contains(".9.")) {
            ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0])});
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeResource(Resources res, int id2, BitmapFactory.Options options) {
        if (id2 == 0) {
            return null;
        }
        TypedValue value = new TypedValue();
        InputStream is = res.openRawResource(id2, value);
        String resourceName = res.getResourceName(id2);
        ImageUtil.RobolectricBufferedImage image = ImageUtil.getImageFromStream(resourceName, is);
        if (!allowInvalidImageData && image == null) {
            if (options != null) {
                options.outWidth = -1;
                options.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create("resource:" + resourceName, options, image);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromResId = id2;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName) {
        return ShadowBitmapFactory.decodeFile(pathName, null);
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName, BitmapFactory.Options options) {
        ImageUtil.RobolectricBufferedImage image = null;
        if (pathName != null && new File(pathName).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(pathName);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                image = ImageUtil.getImageFromStream(pathName, bufferedInputStream);
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        if (!allowInvalidImageData && image == null) {
            if (options != null) {
                options.outWidth = -1;
                options.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create("file:" + pathName, options, image);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromPath = pathName;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        ImageUtil.RobolectricBufferedImage image = null;
        if (fd != null && fd.valid()) {
            try (FileInputStream fileInputStream = new FileInputStream(fd);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                image = ImageUtil.getImageFromStream(bufferedInputStream);
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create("fd:" + fd, null, outPadding, opts, null, image);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromFileDescriptor = fd;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is) {
        return ShadowBitmapFactory.decodeStream(is, null, null);
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        ImageUtil.RobolectricBufferedImage image;
        byte[] ninePatchChunk = null;
        if (is instanceof AssetManager.AssetInputStream) {
            ShadowAssetInputStream sais = (ShadowAssetInputStream)Shadow.extract((Object)is);
            if (sais.isNinePatch()) {
                ninePatchChunk = new byte[]{};
            }
            if (sais.getDelegate() != null) {
                is = sais.getDelegate();
            }
        }
        try {
            if (is != null) {
                is.reset();
            }
        }
        catch (IOException sais) {
            // empty catch block
        }
        boolean isNamedStream = is instanceof NamedStream;
        String name = isNamedStream ? is.toString().replace("stream for ", "") : null;
        ImageUtil.RobolectricBufferedImage robolectricBufferedImage = image = isNamedStream ? null : ImageUtil.getImageFromStream(is);
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create(name, null, outPadding, opts, null, image);
        ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)ninePatchChunk)});
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromStream = is;
        if (image != null && opts != null) {
            opts.outMimeType = image.getMimeType();
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return ShadowBitmapFactory.decodeByteArray(data, offset, length, new BitmapFactory.Options());
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        String desc = data.length + " bytes";
        if (offset != 0 || length != data.length) {
            desc = desc + " " + offset + ".." + length;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        ImageUtil.RobolectricBufferedImage image = ImageUtil.getImageFromStream(is);
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create(desc, data, null, opts, null, image);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromBytes = data;
        return bitmap;
    }

    static Bitmap create(String name, BitmapFactory.Options options, ImageUtil.RobolectricBufferedImage image) {
        return ShadowBitmapFactory.create(name, null, null, options, null, image);
    }

    private static Bitmap create(String name, byte[] bytes, Rect outPadding, BitmapFactory.Options options, Point widthAndHeightOverride, ImageUtil.RobolectricBufferedImage image) {
        Bitmap bitmap = (Bitmap)Shadow.newInstanceOf(Bitmap.class);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.appendDescription(name == null ? "Bitmap" : "Bitmap for " + name);
        Bitmap.Config config = options != null && options.inPreferredConfig != null ? options.inPreferredConfig : Bitmap.Config.ARGB_8888;
        shadowBitmap.setConfig(config);
        String optionsString = ShadowBitmapFactory.stringify(options);
        if (!optionsString.isEmpty()) {
            shadowBitmap.appendDescription(" with options ");
            shadowBitmap.appendDescription(optionsString);
        }
        Point p = new Point(ShadowBitmapFactory.selectWidthAndHeight(name, bytes, widthAndHeightOverride, image));
        if (options != null && options.inSampleSize > 1) {
            p.x /= options.inSampleSize;
            p.y /= options.inSampleSize;
            p.x = p.x == 0 ? 1 : p.x;
            p.y = p.y == 0 ? 1 : p.y;
        }
        float scale = options != null && options.inScaled && options.inDensity != 0 && options.inTargetDensity != 0 && options.inDensity != options.inScreenDensity ? (float)options.inTargetDensity / (float)options.inDensity : 1.0f;
        int scaledWidth = Math.round((float)p.x * scale);
        int scaledHeight = Math.round((float)p.y * scale);
        shadowBitmap.setWidth(scaledWidth);
        shadowBitmap.setHeight(scaledHeight);
        if (image != null) {
            BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage((Image)image.getBufferedImage(), 0, 0, null);
            g.dispose();
            shadowBitmap.setBufferedImage(bufferedImage);
        } else {
            shadowBitmap.setPixelsInternal(new int[scaledWidth * scaledHeight], 0, 0, 0, 0, scaledWidth, scaledHeight);
        }
        if (options != null) {
            options.outWidth = p.x;
            options.outHeight = p.y;
            shadowBitmap.setMutable(options.inMutable);
        }
        ReflectionHelpers.callStaticMethod(BitmapFactory.class, (String)"setDensityFromOptions", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bitmap.class, (Object)bitmap), ReflectionHelpers.ClassParameter.from(BitmapFactory.Options.class, (Object)options)});
        return bitmap;
    }

    @Deprecated
    public static void provideWidthAndHeightHints(Uri uri, int width, int height) {
        widthAndHeightMap.put(uri.toString(), new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(int resourceId, int width, int height) {
        widthAndHeightMap.put("resource:" + RuntimeEnvironment.getApplication().getResources().getResourceName(resourceId), new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(String file, int width, int height) {
        widthAndHeightMap.put("file:" + file, new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(FileDescriptor fd, int width, int height) {
        widthAndHeightMap.put("fd:" + fd, new Point(width, height));
    }

    private static String stringify(BitmapFactory.Options options) {
        if (options == null) {
            return "";
        }
        ArrayList<String> opts = new ArrayList<String>();
        if (options.inJustDecodeBounds) {
            opts.add("inJustDecodeBounds");
        }
        if (options.inSampleSize > 1) {
            opts.add("inSampleSize=" + options.inSampleSize);
        }
        return Join.join((String)", ", opts);
    }

    @Resetter
    public static void reset() {
        widthAndHeightMap.clear();
        allowInvalidImageData = true;
    }

    private static Point selectWidthAndHeight(String name, byte[] bytes, Point widthAndHeightOverride, ImageUtil.RobolectricBufferedImage robolectricBufferedImage) {
        String sizeKey;
        Point widthAndHeightFromMap;
        if (!widthAndHeightMap.isEmpty() && (widthAndHeightFromMap = widthAndHeightMap.get(sizeKey = bytes == null ? name : new String(bytes, StandardCharsets.UTF_8))) != null) {
            return widthAndHeightFromMap;
        }
        if (robolectricBufferedImage != null) {
            return robolectricBufferedImage.getWidthAndHeight();
        }
        if (widthAndHeightOverride != null) {
            return widthAndHeightOverride;
        }
        return new Point(100, 100);
    }

    public static void setAllowInvalidImageData(boolean allowInvalidImageData) {
        ShadowBitmapFactory.allowInvalidImageData = allowInvalidImageData;
    }

    @ForType(value=BitmapFactory.class)
    static interface BitmapFactoryReflector {
        @Static
        @Direct
        public Bitmap decodeResourceStream(Resources var1, TypedValue var2, InputStream var3, Rect var4, BitmapFactory.Options var5);
    }
}

