/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.media.Image;
import android.media.ImageReader;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.internal.R;
import com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.util.WeakHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;

public final class HardwareRenderingScreenshot {
    private static final WeakHashMap<ViewRootImpl, HardwareRenderer> hardwareRenderers = new WeakHashMap();
    static final String PIXEL_COPY_RENDER_MODE = "robolectric.pixelCopyRenderMode";

    private HardwareRenderingScreenshot() {
    }

    static boolean canTakeScreenshot(View view) {
        return RuntimeEnvironment.getApiLevel() >= 28 && "hardware".equalsIgnoreCase(System.getProperty(PIXEL_COPY_RENDER_MODE, "")) && ShadowView.useRealGraphics() && view.canHaveDisplayList();
    }

    static void takeScreenshot(View view, Bitmap destBitmap) {
        int width = view.getWidth();
        int height = view.getHeight();
        try (ImageReader imageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)1);){
            ViewRootImpl viewRootImpl = view.getViewRootImpl();
            Preconditions.checkNotNull((Object)viewRootImpl, (Object)"View not attached");
            Surface surface = imageReader.getSurface();
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                HardwareRenderer renderer = hardwareRenderers.computeIfAbsent(viewRootImpl, k -> new HardwareRenderer());
                renderer.setSurface(surface);
                HardwareRenderingScreenshot.setupRendererShadowProperties(renderer, view);
                RenderNode node = HardwareRenderingScreenshot.getRenderNode(view);
                renderer.setContentRoot(node);
                renderer.createRenderRequest().syncAndDraw();
            } else {
                Canvas canvas = surface.lockHardwareCanvas();
                view.draw(canvas);
                surface.unlockCanvasAndPost(canvas);
            }
            Image nativeImage = imageReader.acquireNextImage();
            Image.Plane[] planes = nativeImage.getPlanes();
            destBitmap.copyPixelsFromBuffer((Buffer)planes[0].getBuffer());
            surface.release();
        }
    }

    private static RenderNode getRenderNode(View view) {
        return (RenderNode)ReflectionHelpers.callInstanceMethod((Object)view, (String)"updateDisplayListIfDirty", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    private static void setupRendererShadowProperties(HardwareRenderer renderer, View view) {
        Context context = view.getContext();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        float lightX = (float)displayMetrics.widthPixels / 2.0f;
        float lightY = a.getDimension(3, 0.0f);
        float lightZ = a.getDimension(4, 600.0f * displayMetrics.density);
        float lightRadius = a.getDimension(2, 800.0f * displayMetrics.density);
        float ambientShadowAlpha = a.getFloat(0, 0.039f);
        float spotShadowAlpha = a.getFloat(1, 0.19f);
        a.recycle();
        renderer.setLightSourceGeometry(lightX, lightY, lightZ, lightRadius);
        renderer.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
    }
}

