/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.Collections;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

class BluetoothGattProxyDelegate {
    private BluetoothGattProxyDelegate() {
    }

    static IBluetoothGatt createBluetoothGattProxy() {
        Object delegate = RuntimeEnvironment.getApiLevel() >= 26 ? new BluetoothGattProxyDelegate() : new Object();
        return (IBluetoothGatt)ReflectionHelpers.createDelegatingProxy(IBluetoothGatt.class, (Object)delegate);
    }

    private void invokeOnAdvertisingSetStarted(IAdvertisingSetCallback callback) {
        ((IAdvertisingSetCallbackReflectorU)Reflector.reflector(IAdvertisingSetCallbackReflectorU.class, (Object)callback)).onAdvertisingSetStarted(0, 0, 0);
    }

    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, int gattServerIf, IAdvertisingSetCallback callback, AttributionSource attributionSource) {
        ((IAdvertisingSetCallbackReflectorV)Reflector.reflector(IAdvertisingSetCallbackReflectorV.class, (Object)callback)).onAdvertisingSetStarted((IBinder)ReflectionHelpers.createNullProxy(IBinder.class), 0, parameters.getTxPowerLevel(), 0);
    }

    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, int gattServerIf, IAdvertisingSetCallback callback, AttributionSource attributionSource, @ClassName(value="com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver") Object recv) {
        this.invokeOnAdvertisingSetStarted(callback);
        ((SynchronousResultReceiverReflector)Reflector.reflector(SynchronousResultReceiverReflector.class, (Object)recv)).send(null);
    }

    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback, AttributionSource attributionSource, @ClassName(value="com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver") Object recv) {
        this.invokeOnAdvertisingSetStarted(callback);
        ((SynchronousResultReceiverReflector)Reflector.reflector(SynchronousResultReceiverReflector.class, (Object)recv)).send(null);
    }

    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback, AttributionSource attributionSource) {
        this.invokeOnAdvertisingSetStarted(callback);
    }

    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback) {
        this.invokeOnAdvertisingSetStarted(callback);
    }

    public void stopAdvertisingSet(IAdvertisingSetCallback callback, AttributionSource attributionSource) {
        try {
            callback.onAdvertisingSetStopped(0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopAdvertisingSet(IAdvertisingSetCallback callback, AttributionSource attributionSource, @ClassName(value="com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver") Object recv) {
        this.stopAdvertisingSet(callback, attributionSource);
        ((SynchronousResultReceiverReflector)Reflector.reflector(SynchronousResultReceiverReflector.class, (Object)recv)).send(null);
    }

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        return Collections.emptyList();
    }

    @ForType(value=IAdvertisingSetCallback.class)
    private static interface IAdvertisingSetCallbackReflectorU {
        public void onAdvertisingSetStarted(int var1, int var2, int var3);
    }

    @ForType(value=IAdvertisingSetCallback.class)
    private static interface IAdvertisingSetCallbackReflectorV {
        public void onAdvertisingSetStarted(IBinder var1, int var2, int var3, int var4);
    }

    @ForType(className="com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver")
    private static interface SynchronousResultReceiverReflector {
        public void send(Object var1);
    }
}

