/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioProfile;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.robolectric.util.ReflectionHelpers;

public class AudioProfileBuilder {
    private int format = 2;
    private int[] samplingRates = new int[]{48000};
    private int[] channelMasks = new int[]{12};
    private int[] channelIndexMasks = new int[0];
    private int encapsulationType = 0;

    private AudioProfileBuilder() {
    }

    public static AudioProfileBuilder newBuilder() {
        return new AudioProfileBuilder();
    }

    @CanIgnoreReturnValue
    public AudioProfileBuilder setFormat(int format) {
        this.format = format;
        return this;
    }

    @CanIgnoreReturnValue
    public AudioProfileBuilder setSamplingRates(int[] samplingRates) {
        this.samplingRates = samplingRates;
        return this;
    }

    @CanIgnoreReturnValue
    public AudioProfileBuilder setChannelMasks(int[] channelMasks) {
        this.channelMasks = channelMasks;
        return this;
    }

    @CanIgnoreReturnValue
    public AudioProfileBuilder setChannelIndexMasks(int[] channelIndexMasks) {
        this.channelIndexMasks = channelIndexMasks;
        return this;
    }

    @CanIgnoreReturnValue
    public AudioProfileBuilder setEncapsulationType(int encapsulationType) {
        this.encapsulationType = encapsulationType;
        return this;
    }

    public AudioProfile build() {
        return (AudioProfile)ReflectionHelpers.callConstructor(AudioProfile.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.format), ReflectionHelpers.ClassParameter.from(int[].class, (Object)this.samplingRates), ReflectionHelpers.ClassParameter.from(int[].class, (Object)this.channelMasks), ReflectionHelpers.ClassParameter.from(int[].class, (Object)this.channelIndexMasks), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.encapsulationType)});
    }
}

