/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.UiccPortInfo;
import android.telephony.UiccSlotInfo;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class UiccSlotInfoBuilder {
    private boolean isEuicc = true;
    private String cardId = "";
    private int cardStateInfo;
    private boolean isExtendedApduSupported;
    private boolean isRemovable;
    private boolean isActive;
    private int logicalSlotIdx;
    private final List<UiccPortInfo> portList = new ArrayList<UiccPortInfo>();

    private UiccSlotInfoBuilder() {
    }

    public static UiccSlotInfoBuilder newBuilder() {
        return new UiccSlotInfoBuilder();
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder setIsEuicc(boolean isEuicc) {
        this.isEuicc = isEuicc;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder setCardId(String cardId) {
        this.cardId = cardId;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder setCardStateInfo(int cardStateInfo) {
        this.cardStateInfo = cardStateInfo;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder setIsExtendedApduSupported(boolean isExtendedApduSupported) {
        this.isExtendedApduSupported = isExtendedApduSupported;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder setIsRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccSlotInfoBuilder addPort(String iccId, int portIndex, int logicSlotIndex, boolean isActive) {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            this.portList.add(new UiccPortInfo(iccId, portIndex, logicSlotIndex, isActive));
        } else {
            this.isActive = isActive;
            this.logicalSlotIdx = logicSlotIndex;
        }
        return this;
    }

    public UiccSlotInfo build() {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            return new UiccSlotInfo(this.isEuicc, this.cardId, this.cardStateInfo, this.isExtendedApduSupported, this.isRemovable, (List)ImmutableList.copyOf(this.portList));
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return (UiccSlotInfo)ReflectionHelpers.callConstructor(UiccSlotInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isActive), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isEuicc), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.cardId), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.cardStateInfo), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.logicalSlotIdx), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isExtendedApduSupported), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isRemovable)});
        }
        return new UiccSlotInfo(this.isActive, this.isActive, this.cardId, this.cardStateInfo, this.logicalSlotIdx, this.isExtendedApduSupported);
    }
}

