/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.CanvasNatives;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.shadows.ShadowNativeBaseCanvas;

@Implements(value=Canvas.class, minSdk=26, isInAndroidSdk=false)
public class ShadowNativeCanvas
extends ShadowNativeBaseCanvas {
    @Implementation(minSdk=26)
    protected static void nFreeCaches() {
        CanvasNatives.nFreeCaches();
    }

    @Implementation(minSdk=26)
    protected static void nFreeTextLayoutCaches() {
        CanvasNatives.nFreeTextLayoutCaches();
    }

    @Implementation(minSdk=26)
    protected static long nGetNativeFinalizer() {
        return CanvasNatives.nGetNativeFinalizer();
    }

    @Implementation(minSdk=28)
    protected static void nSetCompatibilityVersion(int apiLevel) {
        CanvasNatives.nSetCompatibilityVersion((int)apiLevel);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static long nInitRaster(Bitmap bitmap) {
        return ShadowNativeCanvas.nInitRaster(bitmap != null ? bitmap.getNativeInstance() : 0L);
    }

    @Implementation(minSdk=29)
    protected static long nInitRaster(long bitmapHandle) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return CanvasNatives.nInitRaster((long)bitmapHandle);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nSetBitmap(long canvasHandle, Bitmap bitmap) {
        CanvasNatives.nSetBitmap((long)canvasHandle, (long)(bitmap != null ? bitmap.getNativeInstance() : 0L));
    }

    @Implementation(minSdk=29)
    protected static void nSetBitmap(long canvasHandle, long bitmapHandle) {
        CanvasNatives.nSetBitmap((long)canvasHandle, (long)bitmapHandle);
    }

    @Implementation(minSdk=26)
    protected static boolean nGetClipBounds(long nativeCanvas, Rect bounds) {
        return CanvasNatives.nGetClipBounds((long)nativeCanvas, (Rect)bounds);
    }

    @Implementation(minSdk=26)
    protected static boolean nIsOpaque(long canvasHandle) {
        return CanvasNatives.nIsOpaque((long)canvasHandle);
    }

    @Implementation(minSdk=26)
    protected static int nGetWidth(long canvasHandle) {
        return CanvasNatives.nGetWidth((long)canvasHandle);
    }

    @Implementation(minSdk=26)
    protected static int nGetHeight(long canvasHandle) {
        return CanvasNatives.nGetHeight((long)canvasHandle);
    }

    @Implementation(minSdk=26)
    protected static int nSave(long canvasHandle, int saveFlags) {
        return CanvasNatives.nSave((long)canvasHandle, (int)saveFlags);
    }

    @Implementation(minSdk=31)
    protected static int nSaveLayer(long nativeCanvas, float l, float t, float r, float b, long nativePaint) {
        return CanvasNatives.nSaveLayer((long)nativeCanvas, (float)l, (float)t, (float)r, (float)b, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static int nSaveLayer(long nativeCanvas, float l, float t, float r, float b, long nativePaint, int layerFlags) {
        return ShadowNativeCanvas.nSaveLayer(nativeCanvas, l, t, r, b, nativePaint);
    }

    @Implementation(minSdk=31)
    protected static int nSaveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha) {
        return CanvasNatives.nSaveLayerAlpha((long)nativeCanvas, (float)l, (float)t, (float)r, (float)b, (int)alpha);
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static int nSaveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        return ShadowNativeCanvas.nSaveLayerAlpha(nativeCanvas, l, t, r, b, alpha);
    }

    @Implementation(minSdk=29)
    protected static int nSaveUnclippedLayer(long nativeCanvas, int l, int t, int r, int b) {
        return CanvasNatives.nSaveUnclippedLayer((long)nativeCanvas, (int)l, (int)t, (int)r, (int)b);
    }

    @Implementation(minSdk=29)
    protected static void nRestoreUnclippedLayer(long nativeCanvas, int saveCount, long nativePaint) {
        CanvasNatives.nRestoreUnclippedLayer((long)nativeCanvas, (int)saveCount, (long)nativePaint);
    }

    @Implementation(minSdk=26)
    protected static boolean nRestore(long canvasHandle) {
        return CanvasNatives.nRestore((long)canvasHandle);
    }

    @Implementation(minSdk=26)
    protected static void nRestoreToCount(long canvasHandle, int saveCount) {
        CanvasNatives.nRestoreToCount((long)canvasHandle, (int)saveCount);
    }

    @Implementation(minSdk=26)
    protected static int nGetSaveCount(long canvasHandle) {
        return CanvasNatives.nGetSaveCount((long)canvasHandle);
    }

    @Implementation(minSdk=26)
    protected static void nTranslate(long canvasHandle, float dx, float dy) {
        CanvasNatives.nTranslate((long)canvasHandle, (float)dx, (float)dy);
    }

    @Implementation(minSdk=26)
    protected static void nScale(long canvasHandle, float sx, float sy) {
        CanvasNatives.nScale((long)canvasHandle, (float)sx, (float)sy);
    }

    @Implementation(minSdk=26)
    protected static void nRotate(long canvasHandle, float degrees) {
        CanvasNatives.nRotate((long)canvasHandle, (float)degrees);
    }

    @Implementation(minSdk=26)
    protected static void nSkew(long canvasHandle, float sx, float sy) {
        CanvasNatives.nSkew((long)canvasHandle, (float)sx, (float)sy);
    }

    @Implementation(minSdk=26)
    protected static void nConcat(long nativeCanvas, long nativeMatrix) {
        CanvasNatives.nConcat((long)nativeCanvas, (long)nativeMatrix);
    }

    @Implementation(minSdk=26)
    protected static void nSetMatrix(long nativeCanvas, long nativeMatrix) {
        CanvasNatives.nSetMatrix((long)nativeCanvas, (long)nativeMatrix);
    }

    @Implementation(minSdk=26)
    protected static boolean nClipRect(long nativeCanvas, float left, float top, float right, float bottom, int regionOp) {
        return CanvasNatives.nClipRect((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom, (int)regionOp);
    }

    @Implementation(minSdk=26)
    protected static boolean nClipPath(long nativeCanvas, long nativePath, int regionOp) {
        return CanvasNatives.nClipPath((long)nativeCanvas, (long)nativePath, (int)regionOp);
    }

    @Implementation(minSdk=26)
    protected static void nSetDrawFilter(long nativeCanvas, long nativeFilter) {
        CanvasNatives.nSetDrawFilter((long)nativeCanvas, (long)nativeFilter);
    }

    @Implementation(minSdk=26)
    protected static void nGetMatrix(long nativeCanvas, long nativeMatrix) {
        CanvasNatives.nGetMatrix((long)nativeCanvas, (long)nativeMatrix);
    }

    @Implementation(minSdk=26)
    protected static boolean nQuickReject(long nativeCanvas, long nativePath) {
        return CanvasNatives.nQuickReject((long)nativeCanvas, (long)nativePath);
    }

    @Implementation(minSdk=26)
    protected static boolean nQuickReject(long nativeCanvas, float left, float top, float right, float bottom) {
        return CanvasNatives.nQuickReject((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected int saveUnclippedLayer(int left, int top, int right, int bottom) {
        return ShadowNativeCanvas.nSaveUnclippedLayer(this.getNativeCanvas(), left, top, right, bottom);
    }
}

